<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema"
    xmlns:math="http://www.w3.org/2005/xpath-functions/math" xmlns:svg="http://www.w3.org/2000/svg"
    xmlns:lay="http://jwlresearch.net/2012/layout" xmlns:test="http://jwlresearch.net/2012/TEST" xmlns:doc="http://jwlresearch.net/2012/doc"
    exclude-result-prefixes="xs" version="3.0">

    <doc:synopsis title="Grids and graphs" xmlns="http://www.w3.org/1999/xhtml">
        <p>Constructors for grids and graphs.</p>
    </doc:synopsis>

    <xsl:variable name="svg:min-grid-size" doc:doc="Minimum size for a grid">30</xsl:variable>

    <xsl:function name="svg:grid" as="element()" doc:doc="Generate an SVG grid of a size to cover a set of x/y extents"
        xmlns="http://www.w3.org/2000/svg">
        <xsl:param name="width" as="xs:double*"
            doc:doc="A series of x positions - the maximum will be used, subject to a minimum of $test:min-grid-size"/>
        <xsl:param name="height" as="xs:double*"
            doc:doc="A series of y positions - the maximum will be used, subject to a minimum of $test:min-grid-size"/>
        <xsl:variable name="d" select="10"/>
        <xsl:variable name="nx" select="xs:integer(ceiling(max(($width,$svg:min-grid-size)) div $d)) + 1" as="xs:integer"/>
        <xsl:variable name="ny" select="xs:integer(ceiling(max(($height,$svg:min-grid-size)) div $d)) + 1" as="xs:integer"/>
        <xsl:variable name="emphasize" select="function($a) as xs:boolean {$a mod 5 eq 0}"/>
        <g class="grid" id="backgroundGrid" stroke="grey" stroke-width="0.1" fill="black" lay:width="{$d * $nx}" lay:height="{$d * $ny}"
            font-family="Helvetica" font-size="3">
            <circle r="1"/>
            <xsl:for-each select="0 to $ny">
                <xsl:variable name="y" select="$d * ."/>
                <line x1="0" y1="{$y}" x2="{$d*$nx}" y2="{$y}">
                    <xsl:if test="$emphasize(.)">
                        <xsl:attribute name="stroke-width">0.3</xsl:attribute>
                    </xsl:if>
                </line>
                <xsl:if test="$emphasize(.)">
                    <text x="1" y="{$y}">
                        <xsl:value-of select="$y"/>
                    </text>
                </xsl:if>
            </xsl:for-each>
            <xsl:for-each select="0 to $nx">
                <xsl:variable name="x" select="$d * ."/>
                <line y1="0" x1="{$x}" y2="{$d*$ny}" x2="{$x}">
                    <xsl:if test="$emphasize(.)">
                        <xsl:attribute name="stroke-width">0.3</xsl:attribute>
                    </xsl:if>
                </line>
                <xsl:if test="$emphasize(.)">
                    <text x="{$x}" y="3">
                        <xsl:value-of select="$x"/>
                    </text>
                </xsl:if>
            </xsl:for-each>
        </g>
    </xsl:function>
</xsl:stylesheet>
