/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.XSLGlobalVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class XSLGlobalParam
extends XSLGlobalVariable {
    Expression conversion = null;

    protected int getPermittedAttributes() {
        return 2448;
    }

    public XSLGlobalParam() {
        this.sourceBinding.setProperty(4, true);
    }

    public void validate(Declaration decl) throws XPathException {
        if (this.sourceBinding.hasProperty(16)) {
            if (this.sourceBinding.getSelectExpression() != null) {
                this.compileError("The select attribute should be omitted when required='yes'", "XTSE0010");
            }
            if (this.hasChildNodes()) {
                this.compileError("A parameter specifying required='yes' must have empty content", "XTSE0010");
            }
        }
        super.validate(decl);
    }

    public void compileDeclaration(Executable exec, Declaration decl) throws XPathException {
        if (this.sourceBinding.isStatic()) {
            super.compileDeclaration(exec, decl);
        }
        if (!this.redundant) {
            Expression select;
            StructuredQName name = this.sourceBinding.getVariableQName();
            int slot = exec.getGlobalVariableMap().allocateSlotNumber(name);
            if (this.sourceBinding.getDeclaredType() != null) {
                SuppliedParameterReference pref = new SuppliedParameterReference(slot);
                pref.setLocationId(this.staticContext.getLocationMap().allocateLocationId(this.getSystemId(), this.getLineNumber()));
                RoleLocator role = new RoleLocator(8, name.getDisplayName(), 0);
                role.setErrorCode("XTTE0590");
                this.conversion = TypeChecker.staticTypeCheck(pref, this.sourceBinding.getDeclaredType(), false, role, this.makeExpressionVisitor());
            }
            this.sourceBinding.handleSequenceConstructor(exec, decl);
            GlobalParam binding = new GlobalParam();
            binding.setExecutable(this.getPreparedStylesheet());
            binding.setContainer(binding);
            if (this.sourceBinding.hasProperty(16)) {
                this.getPreparedStylesheet().addRequiredParam(this.sourceBinding.getVariableQName());
            }
            if ((select = this.sourceBinding.getSelectExpression()) != null) {
                select.setContainer(binding);
            }
            binding.setSelectExpression(select);
            binding.setVariableQName(this.sourceBinding.getVariableQName());
            this.initializeBinding(exec, decl, binding);
            binding.setSlotNumber(slot);
            binding.setRequiredType(this.getRequiredType());
            binding.setRequiredParam(this.sourceBinding.hasProperty(16));
            binding.setImplicitlyRequiredParam(this.sourceBinding.hasProperty(32));
            this.sourceBinding.fixupBinding(binding);
            this.compiledVariable = binding;
        }
    }

    public SequenceType getRequiredType() {
        SequenceType declaredType = this.sourceBinding.getDeclaredType();
        if (declaredType != null) {
            return declaredType;
        }
        return SequenceType.ANY_SEQUENCE;
    }
}

