/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceExtent;

public class Reverse
extends SystemFunctionCall
implements Callable {
    public ItemType getItemType(TypeHierarchy th) {
        return this.argument[0].getItemType(th);
    }

    public int computeSpecialProperties() {
        int baseProps = this.argument[0].getSpecialProperties();
        if ((baseProps & 0x40000) != 0) {
            return baseProps & 0xFFFBFFFF | 0x20000;
        }
        if ((baseProps & 0x20000) != 0) {
            return baseProps & 0xFFFDFFFF | 0x40000;
        }
        return baseProps;
    }

    public Expression unordered(boolean retainAllNodes) throws XPathException {
        return this.argument[0].unordered(retainAllNodes);
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        SequenceIterator<? extends Item> forwards = this.argument[0].iterate(context);
        return Reverse.getReverseIterator(forwards);
    }

    public static SequenceIterator getReverseIterator(SequenceIterator forwards) throws XPathException {
        if (forwards instanceof ReversibleIterator) {
            return ((ReversibleIterator)forwards).getReverseIterator();
        }
        SequenceExtent extent = new SequenceExtent(forwards);
        return extent.reverseIterate();
    }

    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        ItemType type = this.argument[0].getItemType(context.getConfiguration().getTypeHierarchy());
        if (type == AnyItemType.getInstance()) {
            return super.effectiveBooleanValue(context);
        }
        return this.argument[0].effectiveBooleanValue(context);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        return SequenceTool.toLazySequence(Reverse.getReverseIterator(arguments[0].iterate()));
    }
}

