/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.Negatable;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.Count;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;

public class BooleanFn
extends SystemFunctionCall
implements Negatable,
Callable {
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
        super.checkArguments(visitor);
        XPathException err = TypeChecker.ebvError(this.argument[0], visitor.getConfiguration().getTypeHierarchy());
        if (err != null) {
            err.setLocator(this);
            throw err;
        }
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        this.argument[0] = ExpressionTool.unsortedIfHomogeneous(opt, this.argument[0]);
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression ebv;
        Expression e = super.optimize(visitor, contextItemType);
        if (e == this && (ebv = BooleanFn.rewriteEffectiveBooleanValue(this.argument[0], visitor, contextItemType)) != null) {
            if ((ebv = ebv.optimize(visitor, contextItemType)).getItemType(visitor.getConfiguration().getTypeHierarchy()) == BuiltInAtomicType.BOOLEAN && ebv.getCardinality() == 16384) {
                return ebv;
            }
            this.argument[0] = ebv;
            this.adoptChildExpression(ebv);
            return this;
        }
        return e;
    }

    public boolean isNegatable(ExpressionVisitor visitor) {
        return true;
    }

    public Expression negate() {
        return SystemFunctionCall.makeSystemFunction("not", this.getArguments());
    }

    public static Expression rewriteEffectiveBooleanValue(Expression exp, ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Configuration config = visitor.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        exp = ExpressionTool.unsortedIfHomogeneous(config.obtainOptimizer(), exp);
        if (exp instanceof ValueComparison) {
            ValueComparison vc = (ValueComparison)exp;
            if (vc.getResultWhenEmpty() == null) {
                vc.setResultWhenEmpty(BooleanValue.FALSE);
            }
            return exp;
        }
        if (exp instanceof BooleanFn) {
            return ((BooleanFn)exp).getArguments()[0];
        }
        if (th.isSubType(exp.getItemType(th), BuiltInAtomicType.BOOLEAN) && exp.getCardinality() == 16384) {
            return exp;
        }
        if (exp instanceof Count) {
            FunctionCall exists = SystemFunctionCall.makeSystemFunction("exists", ((Count)exp).getArguments());
            assert (exists != null);
            exists.setLocationId(exp.getLocationId());
            return exists.optimize(visitor, contextItemType);
        }
        if (exp.getItemType(th) instanceof NodeTest) {
            FunctionCall exists = SystemFunctionCall.makeSystemFunction("exists", new Expression[]{exp});
            assert (exists != null);
            exists.setLocationId(exp.getLocationId());
            return exists.optimize(visitor, contextItemType);
        }
        return null;
    }

    public BooleanValue evaluateItem(XPathContext context) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(context));
    }

    public boolean effectiveBooleanValue(XPathContext c) throws XPathException {
        try {
            return this.argument[0].effectiveBooleanValue(c);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(c);
            throw e;
        }
    }

    public Sequence call(XPathContext c, Sequence[] arguments) throws XPathException {
        try {
            boolean bValue = ExpressionTool.effectiveBooleanValue(arguments[0].iterate());
            return BooleanValue.get(bValue);
        }
        catch (XPathException e) {
            e.maybeSetLocation(this);
            e.maybeSetContext(c);
            throw e;
        }
    }
}

