/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.SAXParseException;

class IdentityTransformer
extends Controller {
    protected IdentityTransformer(Configuration config) {
        super(config);
    }

    public void transform(Source source, Result result) throws TransformerException {
        try {
            if (this.getConfiguration().isLicensedFeature(1)) {
                this.getExecutable().setSchemaAware(true);
            }
            PipelineConfiguration pipe = this.makePipelineConfiguration();
            SerializerFactory sf = this.getConfiguration().getSerializerFactory();
            Receiver receiver = sf.getReceiver(result, pipe, this.getOutputProperties());
            NamespaceReducer reducer = new NamespaceReducer(receiver);
            ParseOptions options = pipe.getParseOptions();
            options.setContinueAfterValidationErrors(true);
            Sender.send(source, reducer, options);
        }
        catch (XPathException err) {
            Throwable cause = err.getException();
            if (cause != null && cause instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)cause;
                if ((cause = spe.getException()) instanceof RuntimeException) {
                    this.reportFatalError(err);
                }
            } else {
                this.reportFatalError(err);
            }
            throw err;
        }
    }
}

