/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.hashing;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.openhft.chronicle.algo.bytes.Access;
import net.openhft.chronicle.algo.bytes.Accessor;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.hashing.CityHash_1_1;
import net.openhft.chronicle.algo.hashing.MurmurHash_3;
import net.openhft.chronicle.algo.hashing.XxHash_r39;
import org.jetbrains.annotations.NotNull;

public abstract class LongHashFunction
implements Serializable {
    static final boolean NATIVE_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final long serialVersionUID = 0L;

    protected LongHashFunction() {
    }

    public static LongHashFunction city_1_1() {
        return CityHash_1_1.asLongHashFunctionWithoutSeed();
    }

    public static LongHashFunction city_1_1(long seed) {
        return CityHash_1_1.asLongHashFunctionWithSeed(seed);
    }

    public static LongHashFunction city_1_1(long seed0, long seed1) {
        return CityHash_1_1.asLongHashFunctionWithTwoSeeds(seed0, seed1);
    }

    public static LongHashFunction xx_r39() {
        return XxHash_r39.asLongHashFunctionWithoutSeed();
    }

    public static LongHashFunction xx_r39(long seed) {
        return XxHash_r39.asLongHashFunctionWithSeed(seed);
    }

    public static LongHashFunction murmur_3() {
        return MurmurHash_3.asLongHashFunctionWithoutSeed();
    }

    public static LongHashFunction murmur_3(long seed) {
        return MurmurHash_3.asLongHashFunctionWithSeed(seed);
    }

    private static void checkArrayOffs(int arrayLength, int off, int len) {
        if (len < 0 || off < 0 || off + len > arrayLength || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    public abstract long hashLong(long var1);

    public abstract long hashInt(int var1);

    public abstract long hashShort(short var1);

    public abstract long hashChar(char var1);

    public abstract long hashByte(byte var1);

    public abstract long hashVoid();

    public abstract <T> long hash(T var1, ReadAccess<T> var2, long var3, long var5);

    public <S, T, A extends ReadAccess<T>> long hash(Accessor<S, T, A> accessor, S source, long off, long len) {
        return this.hash(accessor.handle(source), (ReadAccess)accessor.access(), accessor.offset(source, off), accessor.size(len));
    }

    private long unsafeHash(Object input, long off, long len) {
        return this.hash(input, Access.nativeAccess(), off, len);
    }

    public long hashBoolean(boolean input) {
        return this.hashByte((byte)(input ? 1 : 0));
    }

    public long hashBooleans(@NotNull boolean[] input) {
        return this.hashBooleans(input, 0, input.length);
    }

    public long hashBooleans(@NotNull boolean[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.hash(Accessor.booleanArrayAccessor(), input, (long)off, (long)len);
    }

    public long hashBytes(@NotNull byte[] input) {
        return this.hashBytes(input, 0, input.length);
    }

    public long hashBytes(@NotNull byte[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.hash(Accessor.byteArrayAccessor(), input, (long)off, (long)len);
    }

    public long hashBytes(ByteBuffer input) {
        return this.hashBytes(input, input.position(), input.remaining());
    }

    public long hashBytes(@NotNull ByteBuffer input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.capacity(), off, len);
        return this.hash(Accessor.uncheckedByteBufferAccessor(input), input, (long)off, (long)len);
    }

    public long hashMemory(long address, long len) {
        return this.unsafeHash(null, address, len);
    }

    public long hashChars(@NotNull char[] input) {
        return this.hashChars(input, 0, input.length);
    }

    public long hashChars(@NotNull char[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.hash(Accessor.charArrayAccessor(), input, (long)off, (long)len);
    }

    public long hashChars(@NotNull String input) {
        return this.hashChars(input, 0, input.length());
    }

    public long hashChars(@NotNull String input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length(), off, len);
        return this.hash(Accessor.stringAccessor(), input, (long)off, (long)len);
    }

    public long hashChars(@NotNull StringBuilder input) {
        return this.hashNativeChars(input);
    }

    public long hashChars(@NotNull StringBuilder input, int off, int len) {
        return this.hashNativeChars(input, off, len);
    }

    long hashNativeChars(CharSequence input) {
        return this.hashNativeChars(input, 0, input.length());
    }

    long hashNativeChars(CharSequence input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length(), off, len);
        return this.hash(Accessor.checkedNativeCharSequenceAccessor(), input, (long)off, (long)len);
    }

    public long hashShorts(@NotNull short[] input) {
        return this.hashShorts(input, 0, input.length);
    }

    public long hashShorts(@NotNull short[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.hash(Accessor.shortArrayAccessor(), input, (long)off, (long)len);
    }

    public long hashInts(@NotNull int[] input) {
        return this.hashInts(input, 0, input.length);
    }

    public long hashInts(@NotNull int[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.hash(Accessor.intArrayAccessor(), input, (long)off, (long)len);
    }

    public long hashLongs(@NotNull long[] input) {
        return this.hashLongs(input, 0, input.length);
    }

    public long hashLongs(@NotNull long[] input, int off, int len) {
        LongHashFunction.checkArrayOffs(input.length, off, len);
        return this.hash(Accessor.longArrayAccessor(), input, (long)off, (long)len);
    }
}

