/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.agent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import net.bytebuddy.agent.Installer;
import net.bytebuddy.agent.VirtualMachine;

public class ByteBuddyAgent {
    private static final String AGENT_CLASS_PROPERTY = "Agent-Class";
    private static final String CAN_REDEFINE_CLASSES_PROPERTY = "Can-Redefine-Classes";
    private static final String CAN_RETRANSFORM_CLASSES_PROPERTY = "Can-Retransform-Classes";
    private static final String CAN_SET_NATIVE_METHOD_PREFIX = "Can-Set-Native-Method-Prefix";
    private static final String MANIFEST_VERSION_VALUE = "1.0";
    private static final int BUFFER_SIZE = 1024;
    private static final int START_INDEX = 0;
    private static final int END_OF_FILE = -1;
    private static final Object STATIC_MEMBER = null;
    private static final ClassLoader BOOTSTRAP_CLASS_LOADER = null;
    private static final String WITHOUT_ARGUMENT = null;
    private static final String CLASS_FILE_EXTENSION = ".class";
    private static final String ATTACH_METHOD_NAME = "attach";
    private static final String LOAD_AGENT_METHOD_NAME = "loadAgent";
    private static final String DETACH_METHOD_NAME = "detach";
    private static final String INSTRUMENTATION_FIELD_NAME = "instrumentation";
    private static final Instrumentation UNAVAILABLE = null;

    private ByteBuddyAgent() {
        throw new UnsupportedOperationException();
    }

    public static Instrumentation getInstrumentation() {
        Instrumentation instrumentation = ByteBuddyAgent.doGetInstrumentation();
        if (instrumentation == null) {
            throw new IllegalStateException("The Byte Buddy agent is not initialized");
        }
        return instrumentation;
    }

    public static void attach(File agentJar, String processId) {
        ByteBuddyAgent.attach(agentJar, processId, WITHOUT_ARGUMENT);
    }

    public static void attach(File agentJar, String processId, String argument) {
        ByteBuddyAgent.attach(agentJar, processId, argument, AttachmentProvider.DEFAULT);
    }

    public static void attach(File agentJar, String processId, AttachmentProvider attachmentProvider) {
        ByteBuddyAgent.attach(agentJar, processId, WITHOUT_ARGUMENT, attachmentProvider);
    }

    public static void attach(File agentJar, String processId, String argument, AttachmentProvider attachmentProvider) {
        ByteBuddyAgent.install(attachmentProvider, processId, argument, new AgentProvider.ForExistingAgent(agentJar));
    }

    public static Instrumentation install() {
        return ByteBuddyAgent.install(AttachmentProvider.DEFAULT);
    }

    public static Instrumentation install(AttachmentProvider attachmentProvider) {
        return ByteBuddyAgent.install(attachmentProvider, ProcessProvider.ForCurrentVm.INSTANCE);
    }

    public static Instrumentation install(ProcessProvider processProvider) {
        return ByteBuddyAgent.install(AttachmentProvider.DEFAULT, processProvider);
    }

    public static synchronized Instrumentation install(AttachmentProvider attachmentProvider, ProcessProvider processProvider) {
        Instrumentation instrumentation = ByteBuddyAgent.doGetInstrumentation();
        if (instrumentation != null) {
            return instrumentation;
        }
        ByteBuddyAgent.install(attachmentProvider, processProvider.resolve(), WITHOUT_ARGUMENT, AgentProvider.ForByteBuddyAgent.INSTANCE);
        return ByteBuddyAgent.doGetInstrumentation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void install(AttachmentProvider attachmentProvider, String processId, String argument, AgentProvider agentProvider) {
        AttachmentProvider.Accessor attachmentAccessor = attachmentProvider.attempt();
        if (!attachmentAccessor.isAvailable()) {
            throw new IllegalStateException("No compatible attachment provider is not available");
        }
        try {
            Class<?> virtualMachineType = attachmentAccessor.getVirtualMachineType();
            Object virtualMachineInstance = virtualMachineType.getMethod(ATTACH_METHOD_NAME, String.class).invoke(STATIC_MEMBER, processId);
            try {
                virtualMachineType.getMethod(LOAD_AGENT_METHOD_NAME, String.class, String.class).invoke(virtualMachineInstance, agentProvider.resolve().getAbsolutePath(), argument);
            }
            finally {
                virtualMachineType.getMethod(DETACH_METHOD_NAME, new Class[0]).invoke(virtualMachineInstance, new Object[0]);
            }
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error during attachment using: " + attachmentProvider, exception);
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Legal outcome where reflection communicates errors by throwing an exception")
    private static Instrumentation doGetInstrumentation() {
        try {
            return (Instrumentation)ClassLoader.getSystemClassLoader().loadClass(Installer.class.getName()).getDeclaredField(INSTRUMENTATION_FIELD_NAME).get(STATIC_MEMBER);
        }
        catch (Exception ignored) {
            return UNAVAILABLE;
        }
    }

    protected static interface AgentProvider {
        public File resolve() throws IOException;

        public static class ForExistingAgent
        implements AgentProvider {
            private File agent;

            protected ForExistingAgent(File agent) {
                this.agent = agent;
            }

            @Override
            public File resolve() {
                return this.agent;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                ForExistingAgent that = (ForExistingAgent)object;
                return this.agent.equals(that.agent);
            }

            public int hashCode() {
                return this.agent.hashCode();
            }

            public String toString() {
                return "ByteBuddyAgent.AgentProvider.ForExistingAgent{agent='" + this.agent + '\'' + '}';
            }
        }

        public static enum ForByteBuddyAgent implements AgentProvider
        {
            INSTANCE;

            private static final String AGENT_FILE_NAME = "byteBuddyAgent";
            private static final String JAR_FILE_EXTENSION = ".jar";

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public File resolve() throws IOException {
                File agentJar;
                InputStream inputStream = Installer.class.getResourceAsStream('/' + Installer.class.getName().replace('.', '/') + ByteBuddyAgent.CLASS_FILE_EXTENSION);
                if (inputStream == null) {
                    throw new IllegalStateException("Cannot locate class file for Byte Buddy installer");
                }
                try {
                    agentJar = File.createTempFile(AGENT_FILE_NAME, JAR_FILE_EXTENSION);
                    agentJar.deleteOnExit();
                    Manifest manifest = new Manifest();
                    manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, ByteBuddyAgent.MANIFEST_VERSION_VALUE);
                    manifest.getMainAttributes().put(new Attributes.Name(ByteBuddyAgent.AGENT_CLASS_PROPERTY), Installer.class.getName());
                    manifest.getMainAttributes().put(new Attributes.Name(ByteBuddyAgent.CAN_REDEFINE_CLASSES_PROPERTY), Boolean.TRUE.toString());
                    manifest.getMainAttributes().put(new Attributes.Name(ByteBuddyAgent.CAN_RETRANSFORM_CLASSES_PROPERTY), Boolean.TRUE.toString());
                    manifest.getMainAttributes().put(new Attributes.Name(ByteBuddyAgent.CAN_SET_NATIVE_METHOD_PREFIX), Boolean.TRUE.toString());
                    JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(agentJar), manifest);
                    try {
                        int index;
                        jarOutputStream.putNextEntry(new JarEntry(Installer.class.getName().replace('.', '/') + ByteBuddyAgent.CLASS_FILE_EXTENSION));
                        byte[] buffer = new byte[1024];
                        while ((index = inputStream.read(buffer)) != -1) {
                            jarOutputStream.write(buffer, 0, index);
                        }
                        jarOutputStream.closeEntry();
                    }
                    finally {
                        jarOutputStream.close();
                    }
                }
                finally {
                    inputStream.close();
                }
                return agentJar;
            }

            public String toString() {
                return "ByteBuddyAgent.AgentProvider.ForByteBuddyAgent." + this.name();
            }
        }
    }

    public static interface ProcessProvider {
        public String resolve();

        public static enum ForCurrentVm implements ProcessProvider
        {
            INSTANCE;

            private final ProcessProvider dispatcher = ForJava9CapableVm.make();

            @Override
            public String resolve() {
                return this.dispatcher.resolve();
            }

            public String toString() {
                return "ByteBuddyAgent.ProcessProvider.ForCurrentVm." + this.name();
            }

            protected static class ForJava9CapableVm
            implements ProcessProvider {
                private final Method current;
                private final Method getPid;

                protected ForJava9CapableVm(Method current, Method getPid) {
                    this.current = current;
                    this.getPid = getPid;
                }

                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public static ProcessProvider make() {
                    try {
                        return new ForJava9CapableVm(Class.forName("java.lang.ProcessHandle").getMethod("current", new Class[0]), Class.forName("java.lang.ProcessHandle").getMethod("getPid", new Class[0]));
                    }
                    catch (Exception ignored) {
                        return ForLegacyVm.INSTANCE;
                    }
                }

                @Override
                public String resolve() {
                    try {
                        return this.getPid.invoke(this.current.invoke(STATIC_MEMBER, new Object[0]), new Object[0]).toString();
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access Java 9 process API", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error when accessing Java 9 process API", exception.getCause());
                    }
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    ForJava9CapableVm that = (ForJava9CapableVm)other;
                    return this.current.equals(that.current) && this.getPid.equals(that.getPid);
                }

                public int hashCode() {
                    int result = this.current.hashCode();
                    result = 31 * result + this.getPid.hashCode();
                    return result;
                }

                public String toString() {
                    return "ByteBuddyAgent.ProcessProvider.ForCurrentVm.ForJava9CapableVm{current=" + this.current + ", getPid=" + this.getPid + '}';
                }
            }

            protected static enum ForLegacyVm implements ProcessProvider
            {
                INSTANCE;


                @Override
                public String resolve() {
                    String runtimeName = ManagementFactory.getRuntimeMXBean().getName();
                    int processIdIndex = runtimeName.indexOf(64);
                    if (processIdIndex == -1) {
                        throw new IllegalStateException("Cannot extract process id from runtime management bean");
                    }
                    return runtimeName.substring(0, processIdIndex);
                }

                public String toString() {
                    return "ByteBuddyAgent.ProcessProvider.ForCurrentVm.ForLegacyVm." + this.name();
                }
            }
        }
    }

    @SuppressFBWarnings(value={"IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION"}, justification="Safe initialization is implied")
    public static interface AttachmentProvider {
        public static final AttachmentProvider DEFAULT = new Compound(ForJigsawVm.INSTANCE, ForJ9Vm.INSTANCE, ForToolsJarVm.JVM_ROOT, ForToolsJarVm.JDK_ROOT, ForToolsJarVm.MACINTOSH, ForUnixHotSpotVm.INSTANCE);

        public Accessor attempt();

        public static class Compound
        implements AttachmentProvider {
            private final List<AttachmentProvider> attachmentProviders = new ArrayList<AttachmentProvider>();

            public Compound(AttachmentProvider ... attachmentProvider) {
                this(Arrays.asList(attachmentProvider));
            }

            public Compound(List<? extends AttachmentProvider> attachmentProviders) {
                for (AttachmentProvider attachmentProvider : attachmentProviders) {
                    if (attachmentProvider instanceof Compound) {
                        this.attachmentProviders.addAll(((Compound)attachmentProvider).attachmentProviders);
                        continue;
                    }
                    this.attachmentProviders.add(attachmentProvider);
                }
            }

            @Override
            public Accessor attempt() {
                for (AttachmentProvider attachmentProvider : this.attachmentProviders) {
                    Accessor accessor = attachmentProvider.attempt();
                    if (!accessor.isAvailable()) continue;
                    return accessor;
                }
                return Accessor.Unavailable.INSTANCE;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Compound compound = (Compound)other;
                return this.attachmentProviders.equals(compound.attachmentProviders);
            }

            public int hashCode() {
                return this.attachmentProviders.hashCode();
            }

            public String toString() {
                return "ByteBuddyAgent.AttachmentProvider.Compound{attachmentProviders=" + this.attachmentProviders + '}';
            }
        }

        public static enum ForUnixHotSpotVm implements AttachmentProvider
        {
            INSTANCE;


            @Override
            public Accessor attempt() {
                try {
                    return new Accessor.Simple(VirtualMachine.ForHotSpot.OnUnix.assertAvailability());
                }
                catch (Throwable ignored) {
                    return Accessor.Unavailable.INSTANCE;
                }
            }

            public String toString() {
                return "ByteBuddyAgent.AttachmentProvider.ForUnixHotSpotVm." + this.name();
            }
        }

        public static enum ForToolsJarVm implements AttachmentProvider
        {
            JVM_ROOT("../lib/tools.jar"),
            JDK_ROOT("lib/tools.jar"),
            MACINTOSH("../Classes/classes.jar");

            private static final String JAVA_HOME_PROPERTY = "java.home";
            private final String toolsJarPath;

            private ForToolsJarVm(String toolsJarPath) {
                this.toolsJarPath = toolsJarPath;
            }

            @Override
            @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Privilege is explicit user responsibility")
            public Accessor attempt() {
                File toolsJar = new File(System.getProperty(JAVA_HOME_PROPERTY), this.toolsJarPath);
                try {
                    return toolsJar.isFile() && toolsJar.canRead() ? Accessor.Simple.of(new URLClassLoader(new URL[]{toolsJar.toURI().toURL()}, BOOTSTRAP_CLASS_LOADER)) : Accessor.Unavailable.INSTANCE;
                }
                catch (MalformedURLException exception) {
                    throw new IllegalStateException("Could not represent " + toolsJar + " as URL");
                }
            }

            public String toString() {
                return "ByteBuddyAgent.AttachmentProvider.ForToolsJarVm." + this.name();
            }
        }

        public static enum ForJ9Vm implements AttachmentProvider
        {
            INSTANCE;


            @Override
            public Accessor attempt() {
                return Accessor.Simple.ofJ9();
            }

            public String toString() {
                return "ByteBuddyAgent.AttachmentProvider.ForJ9Vm." + this.name();
            }
        }

        public static enum ForJigsawVm implements AttachmentProvider
        {
            INSTANCE;


            @Override
            public Accessor attempt() {
                return Accessor.Simple.of(ClassLoader.getSystemClassLoader());
            }

            public String toString() {
                return "ByteBuddyAgent.AttachmentProvider.ForJigsawVm." + this.name();
            }
        }

        public static interface Accessor {
            public static final String VIRTUAL_MACHINE_TYPE_NAME = "com.sun.tools.attach.VirtualMachine";
            public static final String VIRTUAL_MACHINE_TYPE_NAME_J9 = "com.ibm.tools.attach.VirtualMachine";

            public boolean isAvailable();

            public Class<?> getVirtualMachineType();

            public static class Simple
            implements Accessor {
                private final Class<?> virtualMachineType;

                protected Simple(Class<?> virtualMachineType) {
                    this.virtualMachineType = virtualMachineType;
                }

                public static Accessor of(ClassLoader classLoader) {
                    try {
                        return new Simple(classLoader.loadClass(Accessor.VIRTUAL_MACHINE_TYPE_NAME));
                    }
                    catch (ClassNotFoundException ignored) {
                        return Unavailable.INSTANCE;
                    }
                }

                public static Accessor ofJ9() {
                    try {
                        return new Simple(ClassLoader.getSystemClassLoader().loadClass(Accessor.VIRTUAL_MACHINE_TYPE_NAME_J9));
                    }
                    catch (ClassNotFoundException ignored) {
                        return Unavailable.INSTANCE;
                    }
                }

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @Override
                public Class<?> getVirtualMachineType() {
                    return this.virtualMachineType;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Simple simple = (Simple)other;
                    return this.virtualMachineType.equals(simple.virtualMachineType);
                }

                public int hashCode() {
                    return this.virtualMachineType.hashCode();
                }

                public String toString() {
                    return "ByteBuddyAgent.AttachmentProvider.Accessor.Simple{virtualMachineType=" + this.virtualMachineType + '}';
                }
            }

            public static enum Unavailable implements Accessor
            {
                INSTANCE;


                @Override
                public boolean isAvailable() {
                    return false;
                }

                @Override
                public Class<?> getVirtualMachineType() {
                    throw new IllegalStateException("Cannot read the virtual machine type for an unavailable accessor");
                }

                public String toString() {
                    return "ByteBuddyAgent.AttachmentProvider.Accessor.Unavailable." + this.name();
                }
            }
        }
    }
}

