/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.util;

import it.tidalwave.util.Key;
import it.tidalwave.util.NotFoundException;
import it.tidalwave.util.TypeSafeMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class TypeSafeHashMap
implements TypeSafeMap,
Serializable {
    @Nonnull
    private final Map<Key<?>, Object> map;

    public TypeSafeHashMap(@Nonnull Map<Key<?>, Object> map) {
        this(new HashMap(), false);
        this.map.putAll(map);
    }

    TypeSafeHashMap(@Nonnull Map<Key<?>, Object> map, boolean dummy) {
        this.map = map;
    }

    @Override
    @Nonnull
    public <T> T get(@Nonnull Key<T> key) throws NotFoundException {
        return (T)NotFoundException.throwWhenNull(this.map.get(key), "not found: %s", key);
    }

    @Override
    public boolean containsKey(@Nonnull Key<?> key) {
        return this.map.containsKey(key);
    }

    @Override
    @Nonnull
    public Set<Key<?>> getKeys() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    @Nonnegative
    public int getSize() {
        return this.map.size();
    }

    @Override
    @Nonnull
    public Iterator<Object> iterator() {
        return Collections.unmodifiableCollection(this.map.values()).iterator();
    }

    @Override
    @Nonnull
    public Map<Key<?>, Object> asMap() {
        return new HashMap(this.map);
    }

    @Nonnull
    public String toString() {
        return this.map.toString();
    }
}

