/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.util;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Parameters {
    private Parameters() {
    }

    public static void checkNonNull(@CheckForNull Object parameter, @Nonnull String name) throws IllegalArgumentException {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("%s is mandatory", name));
        }
    }

    @CheckForNull
    public static <T, O> T find(@Nonnull Class<T> parameterClass, @CheckForNull T defaultOption, O ... parameters) throws IllegalArgumentException {
        Collection<T> c = Parameters.find(parameterClass, parameters);
        if (c.size() > 1) {
            throw new IllegalArgumentException(String.format("Multiple values for %s have been specified", parameterClass.getSimpleName()));
        }
        return c.isEmpty() ? defaultOption : c.iterator().next();
    }

    @Nonnull
    public static <T, O> Collection<T> find(@Nonnull Class<T> parameterClass, O ... parameters) {
        ArrayList<O> result = new ArrayList<O>();
        for (O parameter : parameters) {
            if (!parameterClass.isAssignableFrom(parameter.getClass())) continue;
            result.add(parameter);
        }
        return result;
    }
}

