/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.mailencoder;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmailAddress {
    private static final Pattern PATTERN_EMAIL = Pattern.compile("([^(\\s]+) *\\((.*)\\)");
    private static final Pattern PATTERN_EMAIL_ANGLE = Pattern.compile("([^<]*[^< ])? *\\<([^>]*)\\>");
    private static final Pattern PATTERN_EMAIL_INVALID = Pattern.compile("([^\\s,<>]+@[^\\s,<>]+)|");
    public static final String POSTMASTER = "postmaster";
    private final String email;
    private String name;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EmailAddress(String fullAddress) {
        if (fullAddress.contains("(")) {
            Matcher matcher = PATTERN_EMAIL.matcher(fullAddress);
            if (!matcher.matches()) throw new IllegalArgumentException("invalid email address [" + fullAddress + "]");
            this.email = matcher.group(1);
            this.name = matcher.group(2);
        } else if (fullAddress.contains("<")) {
            Matcher matcher = PATTERN_EMAIL_ANGLE.matcher(fullAddress);
            if (!matcher.matches()) throw new IllegalArgumentException("invalid email address [" + fullAddress + "]");
            this.name = matcher.group(1);
            if (this.name == null) {
                this.name = "";
            }
            this.email = matcher.group(2);
        } else {
            this.email = fullAddress;
            this.name = "";
        }
        if (PATTERN_EMAIL_INVALID.matcher(this.email).matches()) return;
        throw new IllegalArgumentException("invalid email address [" + fullAddress + "]");
    }

    public String getEmail() {
        return this.email;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        if (this.name.isEmpty()) {
            return "[" + this.email + "]";
        }
        return "[" + this.email + "," + this.name + "]";
    }
}

