/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.impl.SMTPAuthentication;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.SMTPInitialDialogue;
import io.vertx.ext.mail.impl.sasl.AuthOperationFactory;

class SMTPStarter {
    private final SMTPConnection connection;
    private final String hostname;
    private final MailConfig config;
    private final AuthOperationFactory authOperationFactory;
    private final Handler<AsyncResult<SMTPConnection>> handler;

    SMTPStarter(SMTPConnection connection, MailConfig config, String hostname, AuthOperationFactory authOperationFactory, Handler<AsyncResult<SMTPConnection>> handler) {
        this.connection = connection;
        this.hostname = hostname;
        this.config = config;
        this.authOperationFactory = authOperationFactory;
        this.handler = handler;
    }

    void serverGreeting(String message) {
        new SMTPInitialDialogue(this.connection, this.config, this.hostname, (Handler<Void>)((Handler)v -> this.doAuthentication()), (Handler<Throwable>)((Handler)this::handleError)).start(message);
    }

    private void doAuthentication() {
        new SMTPAuthentication(this.connection, this.config, this.authOperationFactory, (Handler<Void>)((Handler)v -> this.handler.handle((Object)Future.succeededFuture((Object)this.connection))), (Handler<Throwable>)((Handler)this::handleError)).start();
    }

    private void handleError(Throwable throwable) {
        this.handler.handle((Object)Future.failedFuture((Throwable)throwable));
    }
}

