/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl.sasl;

import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.mail.impl.sasl.AuthBaseClass;

class AuthXOAUTH2
extends AuthBaseClass {
    private static final Logger LOG = LoggerFactory.getLogger(AuthXOAUTH2.class);
    private boolean first = true;

    public AuthXOAUTH2(String username, String token) {
        super("XOAUTH2", username, token);
    }

    @Override
    public String nextStep(String data) {
        if (this.first) {
            this.first = false;
            return "user=" + this.username + "\u0001auth=Bearer " + this.password + "\u0001\u0001";
        }
        if (data == null) {
            return null;
        }
        try {
            JsonObject response = new JsonObject(data);
            if (response.containsKey("status") && response.containsKey("schemes") && response.containsKey("scope")) {
                LOG.debug((Object)("XOAUTH2 Error Response: " + data));
                return "";
            }
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

