/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser.impl;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.nuiton.i18n.plugin.parser.AbstractFileParser;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.I18nParseMojoSupport;
import org.nuiton.i18n.plugin.parser.I18nSourceEntry;
import org.nuiton.i18n.plugin.parser.ParserException;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.i18n.plugin.parser.java.Java8BaseVisitor;
import org.nuiton.i18n.plugin.parser.java.Java8Lexer;
import org.nuiton.i18n.plugin.parser.java.Java8Parser;
import org.nuiton.io.FileUpdater;
import org.nuiton.io.FileUpdaterHelper;
import org.nuiton.io.SortedProperties;

@Mojo(name="parse-java", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class ParseJavaMojo
extends I18nParseMojoSupport {
    public static final String DEFAULT_INCLUDES = "**/*.java";
    @Parameter(property="i18n.defaultBasedir", defaultValue="${basedir}/src/main/java")
    private File defaultBasedir;
    @Parameter(property="i18n.defaultIncludes", defaultValue="**/*.java", required=true)
    private String defaultIncludes;
    @Parameter(property="i18n.outputGetter", defaultValue="java.getter")
    private String outputGetter;

    @Override
    public String[] getDefaultIncludes() {
        return new String[]{this.defaultIncludes};
    }

    @Override
    public String[] getDefaultExcludes() {
        return I18nSourceEntry.EMPTY_STRING_ARRAY;
    }

    @Override
    public File getDefaultBasedir() {
        return this.defaultBasedir;
    }

    @Override
    public FileUpdater newFileUpdater(SourceEntry entry) {
        return FileUpdaterHelper.newJavaFileUpdater((File)entry.getBasedir(), (File)this.buildOutputDirectory);
    }

    @Override
    protected String getOutGetter() {
        return this.outputGetter;
    }

    @Override
    public FileParser newFileParser(File basedir, Pattern acceptPattern) {
        return new JavaFileParser(this.getLog(), this.encoding, null, acceptPattern);
    }

    protected static class JavaFileParser
    extends AbstractFileParser {
        JavaFileParser(Log log, String encoding, SortedProperties oldParser, Pattern acceptKeyPattern) {
            super(log, encoding, acceptKeyPattern);
        }

        @Override
        public void parseFile(File file) throws IOException {
            String content = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
            if (content.contains("org.nuiton.i18n.I18n")) {
                CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)new Java8Lexer((CharStream)CharStreams.fromString((String)content)));
                Java8Parser parser = new Java8Parser((TokenStream)tokenStream);
                try {
                    ((ParserATNSimulator)parser.getInterpreter()).enable_global_context_dfa = true;
                    Java8Parser.CompilationUnitContext compilationUnitContext = parser.compilationUnit();
                    compilationUnitContext.accept(new JavaParserVisitor(file));
                }
                catch (Exception e) {
                    throw new ParserException(e);
                }
            }
        }

        @Override
        public void parseLine(File file, String line) {
        }

        protected class JavaParserVisitor
        extends Java8BaseVisitor<Void> {
            final Set<String> simpleI18nMethodPrefix;
            final Set<String> complexI18nMethodPrefix;
            protected final File file;

            private JavaParserVisitor(File file) {
                this.file = file;
                this.simpleI18nMethodPrefix = new HashSet<String>();
                this.complexI18nMethodPrefix = new HashSet<String>();
                this.simpleI18nMethodPrefix.add("org.nuiton.i18n.I18n.n");
                this.simpleI18nMethodPrefix.add("org.nuiton.i18n.I18n.t");
                this.simpleI18nMethodPrefix.add("I18n.n");
                this.simpleI18nMethodPrefix.add("I18n.t");
                this.simpleI18nMethodPrefix.add("n");
                this.simpleI18nMethodPrefix.add("t");
                this.complexI18nMethodPrefix.add("org.nuiton.i18n.I18n.l");
                this.complexI18nMethodPrefix.add("I18n.l");
                this.complexI18nMethodPrefix.add("l");
            }

            @Override
            public Void visitMethodInvocation_lfno_primary(Java8Parser.MethodInvocation_lfno_primaryContext ctx) {
                Java8Parser.ArgumentListContext list = ctx.argumentList();
                Java8Parser.MethodNameContext mnc = ctx.methodName();
                TerminalNode tn = ctx.Identifier();
                Java8Parser.TypeNameContext tnc = ctx.typeName();
                Void aVoid = null;
                if (!this.visitMethod(list, mnc, tn, tnc)) {
                    aVoid = (Void)super.visitMethodInvocation_lfno_primary(ctx);
                }
                return aVoid;
            }

            @Override
            public Void visitMethodInvocation(Java8Parser.MethodInvocationContext ctx) {
                Java8Parser.ArgumentListContext list = ctx.argumentList();
                Java8Parser.MethodNameContext mnc = ctx.methodName();
                TerminalNode tn = ctx.Identifier();
                Java8Parser.TypeNameContext tnc = ctx.typeName();
                Void aVoid = null;
                if (!this.visitMethod(list, mnc, tn, tnc)) {
                    aVoid = (Void)super.visitMethodInvocation(ctx);
                }
                return aVoid;
            }

            boolean visitMethod(Java8Parser.ArgumentListContext list, Java8Parser.MethodNameContext mnc, TerminalNode tn, Java8Parser.TypeNameContext tnc) {
                boolean match = false;
                if (mnc != null || tnc != null && tn != null) {
                    String methodName;
                    String string = methodName = mnc != null ? mnc.getText() : tnc.getText() + "." + tn.getText();
                    if (this.simpleI18nMethodPrefix.contains(methodName)) {
                        Java8Parser.ExpressionContext argument = list.expression(0);
                        match = this.register(argument);
                    } else if (this.complexI18nMethodPrefix.contains(methodName)) {
                        Java8Parser.ExpressionContext argument = list.expression(1);
                        match = this.register(argument);
                    }
                }
                return match;
            }

            private boolean register(Java8Parser.ExpressionContext argument) {
                String firstArgs = argument.getText();
                if (firstArgs.matches("^\"[^\"]+\"$")) {
                    String key = firstArgs.substring(1).substring(0, firstArgs.length() - 2);
                    if (JavaFileParser.this.getLog().isDebugEnabled()) {
                        JavaFileParser.this.getLog().debug((CharSequence)String.format("%s detected key = %s", this.file.getName(), key));
                    }
                    JavaFileParser.this.registerKey(this.file, key);
                    return true;
                }
                return false;
            }
        }
    }
}

