/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.xml;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.component.annotations.Component;
import org.sonatype.maven.polyglot.mapping.Mapping;
import org.sonatype.maven.polyglot.mapping.MappingSupport;

@Component(role=Mapping.class, hint="xml41")
public class XMLMapping
extends MappingSupport {
    public XMLMapping() {
        super("xml41");
        this.setPomNames(new String[]{"pom.xml41"});
        this.setAcceptLocationExtensions(new String[]{".xml41", ".xml"});
        this.setAcceptOptionKeys(new String[]{"xml41:4.0.0"});
        this.setPriority(-1.0f);
    }

    public boolean accept(Map<String, ?> options) {
        String location;
        if (options != null && (location = this.getLocation(options)) != null) {
            if (location.endsWith(".xml41")) {
                return true;
            }
            if (location.endsWith(".xml")) {
                return this.canParse(options);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canParse(Map<String, ?> options) {
        boolean canParse = false;
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.getLocation(options));
            MavenXpp3Reader reader = new MavenXpp3Reader();
            reader.read((InputStream)in);
            canParse = false;
        }
        catch (Exception ex) {
            canParse = true;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                canParse = true;
            }
        }
        return canParse;
    }
}

