/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import io.smallrye.openapi.model.ReferenceType;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;

public class JandexUtil {
    private JandexUtil() {
    }

    public static String createUniqueMethodReference(ClassInfo classInfo, MethodInfo methodInfo) {
        return "m" + classInfo.hashCode() + "_" + methodInfo.hashCode();
    }

    public static boolean isRef(AnnotationInstance annotation) {
        return ReferenceType.isReference((AnnotationInstance)annotation);
    }

    public static boolean isEmpty(AnnotationInstance annotation) {
        return annotation.values() == null || annotation.values().isEmpty();
    }

    public static String nameFromRef(AnnotationInstance annotation) {
        String ref = annotation.value("ref").asString();
        return ModelUtil.nameFromRef(ref);
    }

    public static List<AnnotationValue> schemaDisplayValues(AnnotationInstance annotation) {
        return annotation.values().stream().filter(value -> !SchemaConstant.PROPERTIES_NONDISPLAY.contains(value.name())).collect(Collectors.toList());
    }

    public static boolean isSimpleClassSchema(AnnotationInstance annotation) {
        return JandexUtil.schemaDisplayValues(annotation).isEmpty() && JandexUtil.hasImplementation(annotation);
    }

    public static boolean isSimpleArraySchema(AnnotationScannerContext context, AnnotationInstance annotation) {
        if (JandexUtil.schemaDisplayValues(annotation).size() != 1) {
            return false;
        }
        return JandexUtil.isArraySchema(context, annotation);
    }

    public static boolean isArraySchema(AnnotationScannerContext context, AnnotationInstance annotation) {
        if (!JandexUtil.hasImplementation(annotation)) {
            return false;
        }
        Schema.SchemaType type = context.annotations().enumValue(annotation, "type", Schema.SchemaType.class);
        return type == Schema.SchemaType.ARRAY;
    }

    public static boolean isBooleanSchema(AnnotationInstance annotation) {
        if (!JandexUtil.hasImplementation(annotation)) {
            return false;
        }
        AnnotationValue impl = annotation.value("implementation");
        if (impl == null) {
            return false;
        }
        DotName name = impl.asClass().name();
        return name.equals((Object)SchemaConstant.DOTNAME_TRUE_SCHEMA) || name.equals((Object)SchemaConstant.DOTNAME_FALSE_SCHEMA);
    }

    public static boolean hasImplementation(AnnotationInstance annotation) {
        return annotation.value("implementation") != null;
    }

    public static boolean equals(AnnotationTarget t1, AnnotationTarget t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1 == null || t2 == null || t1.kind() != t2.kind()) {
            return false;
        }
        switch (t1.kind()) {
            case CLASS: {
                return JandexUtil.equals(t1.asClass(), t2.asClass());
            }
            case FIELD: {
                return JandexUtil.equals(t1.asField(), t2.asField());
            }
            case METHOD_PARAMETER: {
                return JandexUtil.equals(t1.asMethodParameter(), t2.asMethodParameter());
            }
        }
        return t1.equals((Object)t2);
    }

    public static boolean equals(ClassInfo c1, ClassInfo c2) {
        return c1.name().equals((Object)c2.name());
    }

    public static boolean equals(FieldInfo f1, FieldInfo f2) {
        return JandexUtil.equals(f1.declaringClass(), f2.declaringClass()) && f1.name().equals(f2.name());
    }

    public static boolean equals(MethodParameterInfo p1, MethodParameterInfo p2) {
        return p1.method().equals((Object)p2.method()) && p1.position() == p2.position();
    }

    public static List<FieldInfo> fields(AnnotationScannerContext context, ClassInfo currentClass) {
        if (context.getConfig().sortedPropertiesEnable()) {
            return currentClass.fields();
        }
        return currentClass.fieldsInDeclarationOrder();
    }

    public static boolean isSupplier(AnnotationTarget target) {
        if (target.kind() != AnnotationTarget.Kind.METHOD) {
            return false;
        }
        MethodInfo method = target.asMethod();
        return method.returnType().kind() != Type.Kind.VOID && method.parameterTypes().isEmpty();
    }
}

