/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.api.ApplyFaultTolerance;
import io.smallrye.faulttolerance.api.CircuitBreakerName;
import io.smallrye.faulttolerance.api.CustomBackoff;
import io.smallrye.faulttolerance.api.ExponentialBackoff;
import io.smallrye.faulttolerance.api.FibonacciBackoff;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import io.smallrye.faulttolerance.config.ApplyFaultToleranceConfig;
import io.smallrye.faulttolerance.config.ApplyFaultToleranceConfigImpl;
import io.smallrye.faulttolerance.config.AsynchronousConfig;
import io.smallrye.faulttolerance.config.AsynchronousConfigImpl;
import io.smallrye.faulttolerance.config.BlockingConfig;
import io.smallrye.faulttolerance.config.BlockingConfigImpl;
import io.smallrye.faulttolerance.config.BulkheadConfig;
import io.smallrye.faulttolerance.config.BulkheadConfigImpl;
import io.smallrye.faulttolerance.config.CircuitBreakerConfig;
import io.smallrye.faulttolerance.config.CircuitBreakerConfigImpl;
import io.smallrye.faulttolerance.config.CircuitBreakerNameConfig;
import io.smallrye.faulttolerance.config.CircuitBreakerNameConfigImpl;
import io.smallrye.faulttolerance.config.CustomBackoffConfig;
import io.smallrye.faulttolerance.config.CustomBackoffConfigImpl;
import io.smallrye.faulttolerance.config.ExponentialBackoffConfig;
import io.smallrye.faulttolerance.config.ExponentialBackoffConfigImpl;
import io.smallrye.faulttolerance.config.FallbackConfig;
import io.smallrye.faulttolerance.config.FallbackConfigImpl;
import io.smallrye.faulttolerance.config.FibonacciBackoffConfig;
import io.smallrye.faulttolerance.config.FibonacciBackoffConfigImpl;
import io.smallrye.faulttolerance.config.NonBlockingConfig;
import io.smallrye.faulttolerance.config.NonBlockingConfigImpl;
import io.smallrye.faulttolerance.config.RetryConfig;
import io.smallrye.faulttolerance.config.RetryConfigImpl;
import io.smallrye.faulttolerance.config.TimeoutConfig;
import io.smallrye.faulttolerance.config.TimeoutConfigImpl;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceDefinitionException;

public class FaultToleranceOperation {
    private final Class<?> beanClass;
    private final MethodDescriptor methodDescriptor;
    private final ApplyFaultToleranceConfig applyFaultTolerance;
    private final AsynchronousConfig asynchronous;
    private final BlockingConfig blocking;
    private final NonBlockingConfig nonBlocking;
    private final BulkheadConfig bulkhead;
    private final CircuitBreakerConfig circuitBreaker;
    private final CircuitBreakerNameConfig circuitBreakerName;
    private final FallbackConfig fallback;
    private final RetryConfig retry;
    private final TimeoutConfig timeout;
    private final ExponentialBackoffConfig exponentialBackoff;
    private final FibonacciBackoffConfig fibonacciBackoff;
    private final CustomBackoffConfig customBackoff;

    public static FaultToleranceOperation create(FaultToleranceMethod method) {
        return new FaultToleranceOperation(method.beanClass, method.method, ApplyFaultToleranceConfigImpl.create(method), AsynchronousConfigImpl.create(method), BlockingConfigImpl.create(method), NonBlockingConfigImpl.create(method), BulkheadConfigImpl.create(method), CircuitBreakerConfigImpl.create(method), CircuitBreakerNameConfigImpl.create(method), FallbackConfigImpl.create(method), RetryConfigImpl.create(method), TimeoutConfigImpl.create(method), ExponentialBackoffConfigImpl.create(method), FibonacciBackoffConfigImpl.create(method), CustomBackoffConfigImpl.create(method));
    }

    private FaultToleranceOperation(Class<?> beanClass, MethodDescriptor methodDescriptor, ApplyFaultToleranceConfig applyFaultTolerance, AsynchronousConfig asynchronous, BlockingConfig blocking, NonBlockingConfig nonBlocking, BulkheadConfig bulkhead, CircuitBreakerConfig circuitBreaker, CircuitBreakerNameConfig circuitBreakerName, FallbackConfig fallback, RetryConfig retry, TimeoutConfig timeout, ExponentialBackoffConfig exponentialBackoff, FibonacciBackoffConfig fibonacciBackoff, CustomBackoffConfig customBackoff) {
        this.beanClass = beanClass;
        this.methodDescriptor = methodDescriptor;
        this.applyFaultTolerance = applyFaultTolerance;
        this.asynchronous = asynchronous;
        this.blocking = blocking;
        this.nonBlocking = nonBlocking;
        this.bulkhead = bulkhead;
        this.circuitBreaker = circuitBreaker;
        this.circuitBreakerName = circuitBreakerName;
        this.fallback = fallback;
        this.retry = retry;
        this.timeout = timeout;
        this.exponentialBackoff = exponentialBackoff;
        this.fibonacciBackoff = fibonacciBackoff;
        this.customBackoff = customBackoff;
    }

    public Class<?>[] getParameterTypes() {
        return this.methodDescriptor.parameterTypes;
    }

    public Class<?> getReturnType() {
        return this.methodDescriptor.returnType;
    }

    public boolean hasApplyFaultTolerance() {
        return this.applyFaultTolerance != null;
    }

    public ApplyFaultTolerance getApplyFaultTolerance() {
        return this.applyFaultTolerance;
    }

    public boolean hasAsynchronous() {
        return this.asynchronous != null;
    }

    public boolean hasBlocking() {
        return this.blocking != null;
    }

    public boolean hasNonBlocking() {
        return this.nonBlocking != null;
    }

    public boolean isThreadOffloadRequired() {
        if (this.blocking != null && this.blocking.isOnMethod()) {
            return true;
        }
        if (this.nonBlocking != null && this.nonBlocking.isOnMethod()) {
            return false;
        }
        if (this.blocking != null) {
            return true;
        }
        if (this.nonBlocking != null) {
            return false;
        }
        return this.asynchronous != null;
    }

    public boolean hasBulkhead() {
        return this.bulkhead != null;
    }

    public Bulkhead getBulkhead() {
        return this.bulkhead;
    }

    public boolean hasCircuitBreaker() {
        return this.circuitBreaker != null;
    }

    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    public boolean hasCircuitBreakerName() {
        return this.circuitBreakerName != null;
    }

    public CircuitBreakerName getCircuitBreakerName() {
        return this.circuitBreakerName;
    }

    public boolean hasFallback() {
        return this.fallback != null;
    }

    public Fallback getFallback() {
        return this.fallback;
    }

    public boolean hasRetry() {
        return this.retry != null;
    }

    public Retry getRetry() {
        return this.retry;
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public Timeout getTimeout() {
        return this.timeout;
    }

    public boolean hasExponentialBackoff() {
        return this.exponentialBackoff != null;
    }

    public ExponentialBackoff getExponentialBackoff() {
        return this.exponentialBackoff;
    }

    public boolean hasFibonacciBackoff() {
        return this.fibonacciBackoff != null;
    }

    public FibonacciBackoff getFibonacciBackoff() {
        return this.fibonacciBackoff;
    }

    public boolean hasCustomBackoff() {
        return this.customBackoff != null;
    }

    public CustomBackoff getCustomBackoff() {
        return this.customBackoff;
    }

    public String getName() {
        return this.beanClass.getCanonicalName() + "." + this.methodDescriptor.name;
    }

    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (FaultToleranceDefinitionException e) {
            return false;
        }
    }

    public void validate() {
        if (this.applyFaultTolerance != null) {
            this.applyFaultTolerance.validate();
        }
        if (this.asynchronous != null) {
            this.asynchronous.validate();
        }
        if (this.blocking != null) {
            this.blocking.validate();
        }
        if (this.nonBlocking != null) {
            this.nonBlocking.validate();
        }
        if (this.bulkhead != null) {
            this.bulkhead.validate();
        }
        if (this.circuitBreaker != null) {
            this.circuitBreaker.validate();
        }
        if (this.fallback != null) {
            this.fallback.validate();
        }
        if (this.retry != null) {
            this.retry.validate();
        }
        if (this.timeout != null) {
            this.timeout.validate();
        }
        this.validateRetryBackoff();
    }

    private void validateRetryBackoff() {
        long retryMaxDuration;
        HashSet<Class> backoffAnnotations = new HashSet<Class>();
        for (Config config : Arrays.asList(this.exponentialBackoff, this.fibonacciBackoff, this.customBackoff)) {
            if (config == null) continue;
            config.validate();
            if (this.retry == null) {
                throw new FaultToleranceDefinitionException("Invalid @" + config.annotationType().getSimpleName() + " on " + this.methodDescriptor + ": missing @Retry");
            }
            backoffAnnotations.add(config.annotationType());
        }
        if (backoffAnnotations.size() > 1) {
            throw new FaultToleranceDefinitionException("More than one backoff defined for " + this.methodDescriptor + ": " + backoffAnnotations);
        }
        if (this.retry != null && (retryMaxDuration = Duration.of(this.retry.maxDuration(), this.retry.durationUnit()).toMillis()) > 0L) {
            long maxDelay;
            if (this.exponentialBackoff != null && retryMaxDuration <= (maxDelay = Duration.of(this.exponentialBackoff.maxDelay(), this.exponentialBackoff.maxDelayUnit()).toMillis())) {
                throw new FaultToleranceDefinitionException("Invalid @ExponentialBackoff on " + this.methodDescriptor + ": @Retry.maxDuration should be greater than maxDelay");
            }
            if (this.fibonacciBackoff != null && retryMaxDuration <= (maxDelay = Duration.of(this.fibonacciBackoff.maxDelay(), this.fibonacciBackoff.maxDelayUnit()).toMillis())) {
                throw new FaultToleranceDefinitionException("Invalid @FibonacciBackoff on " + this.methodDescriptor + ": @Retry.maxDuration should be greater than maxDelay");
            }
        }
    }

    public String toString() {
        return "FaultToleranceOperation[" + this.methodDescriptor + "]";
    }
}

