/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.ext.auth;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.ext.auth.AuthProvider;
import io.vertx.mutiny.ext.auth.authorization.Authorization;
import io.vertx.mutiny.ext.auth.authorization.Authorizations;

@MutinyGen(value=io.vertx.ext.auth.User.class)
public class User {
    public static final TypeArg<User> __TYPE_ARG = new TypeArg(obj -> new User((io.vertx.ext.auth.User)obj), User::getDelegate);
    private final io.vertx.ext.auth.User delegate;

    public User(io.vertx.ext.auth.User delegate) {
        this.delegate = delegate;
    }

    public User(Object delegate) {
        this.delegate = (io.vertx.ext.auth.User)delegate;
    }

    User() {
        this.delegate = null;
    }

    public io.vertx.ext.auth.User getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User that = (User)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static User fromName(String username) {
        User ret = User.newInstance(io.vertx.ext.auth.User.fromName((String)username));
        return ret;
    }

    public static User fromToken(String token) {
        User ret = User.newInstance(io.vertx.ext.auth.User.fromToken((String)token));
        return ret;
    }

    public static User create(JsonObject principal) {
        User ret = User.newInstance(io.vertx.ext.auth.User.create((JsonObject)principal));
        return ret;
    }

    public static User create(JsonObject principal, JsonObject attributes) {
        User ret = User.newInstance(io.vertx.ext.auth.User.create((JsonObject)principal, (JsonObject)attributes));
        return ret;
    }

    public JsonObject attributes() {
        JsonObject ret = this.delegate.attributes();
        return ret;
    }

    public boolean expired() {
        boolean ret = this.delegate.expired();
        return ret;
    }

    public boolean expired(int leeway) {
        boolean ret = this.delegate.expired(leeway);
        return ret;
    }

    public <T> T get(String key) {
        Object ret = this.delegate.get(key);
        return (T)ret;
    }

    public boolean containsKey(String key) {
        boolean ret = this.delegate.containsKey(key);
        return ret;
    }

    public Authorizations authorizations() {
        Authorizations ret = Authorizations.newInstance(this.delegate.authorizations());
        return ret;
    }

    @Deprecated
    public Uni<Boolean> isAuthorized(Authorization authority) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.isAuthorized(authority.getDelegate(), resultHandler));
    }

    @Deprecated
    public Boolean isAuthorizedAndAwait(Authorization authority) {
        return (Boolean)this.isAuthorized(authority).await().indefinitely();
    }

    @Deprecated
    @Fluent
    public User isAuthorizedAndForget(Authorization authority) {
        this.isAuthorized(authority).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Deprecated
    public Uni<Boolean> isAuthorized(String authority) {
        return AsyncResultUni.toUni(resultHandler -> this.delegate.isAuthorized(authority, resultHandler));
    }

    @Deprecated
    public Boolean isAuthorizedAndAwait(String authority) {
        return (Boolean)this.isAuthorized(authority).await().indefinitely();
    }

    @Deprecated
    @Fluent
    public User isAuthorizedAndForget(String authority) {
        this.isAuthorized(authority).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Deprecated
    @Fluent
    public User clearCache() {
        this.delegate.clearCache();
        return this;
    }

    public JsonObject principal() {
        JsonObject ret = this.delegate.principal();
        return ret;
    }

    @Deprecated
    public void setAuthProvider(AuthProvider authProvider) {
        this.delegate.setAuthProvider(authProvider.getDelegate());
    }

    public static User newInstance(io.vertx.ext.auth.User arg) {
        return arg != null ? new User(arg) : null;
    }
}

