package io.vertx.mutiny.ext.auth;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;

/**
 * Chain several authentication providers as if they were one. This is useful for cases where one want to authenticate across
 * several providers, for example, database and fallback to passwd file.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.ChainAuth original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.auth.ChainAuth.class)
public class ChainAuth extends io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider {

  public static final io.smallrye.mutiny.vertx.TypeArg<ChainAuth> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ChainAuth((io.vertx.ext.auth.ChainAuth) obj),
    ChainAuth::getDelegate
  );

  private final io.vertx.ext.auth.ChainAuth delegate;
  
  public ChainAuth(io.vertx.ext.auth.ChainAuth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public ChainAuth(Object delegate) {
    super((io.vertx.ext.auth.ChainAuth)delegate);
    this.delegate = (io.vertx.ext.auth.ChainAuth)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ChainAuth() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.ext.auth.ChainAuth getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ChainAuth that = (ChainAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the auth provider
   * @deprecated   */
  @Deprecated
  public static io.vertx.mutiny.ext.auth.ChainAuth create() { 
    io.vertx.mutiny.ext.auth.ChainAuth ret = io.vertx.mutiny.ext.auth.ChainAuth.newInstance((io.vertx.ext.auth.ChainAuth)io.vertx.ext.auth.ChainAuth.create());
    return ret;
  }

  /**
   * @return the auth provider
   */
  public static io.vertx.mutiny.ext.auth.ChainAuth all() { 
    io.vertx.mutiny.ext.auth.ChainAuth ret = io.vertx.mutiny.ext.auth.ChainAuth.newInstance((io.vertx.ext.auth.ChainAuth)io.vertx.ext.auth.ChainAuth.all());
    return ret;
  }

  /**
   * @return the auth provider
   */
  public static io.vertx.mutiny.ext.auth.ChainAuth any() { 
    io.vertx.mutiny.ext.auth.ChainAuth ret = io.vertx.mutiny.ext.auth.ChainAuth.newInstance((io.vertx.ext.auth.ChainAuth)io.vertx.ext.auth.ChainAuth.any());
    return ret;
  }

  /**
   * @param other auth provider
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.ext.auth.ChainAuth add(io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider other) { 
    delegate.add(other.getDelegate());
    return this;
  }

  public static  ChainAuth newInstance(io.vertx.ext.auth.ChainAuth arg) {
    return arg != null ? new ChainAuth(arg) : null;
  }

}
