/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.subscription.ContextSupport;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class MultiCacheOp<T>
extends AbstractMultiOperator<T, T>
implements Subscriber<T>,
ContextSupport {
    private final AtomicBoolean hasSubscribedToUpstream = new AtomicBoolean();
    private final List<CacheSubscription<T>> subscribers = new CopyOnWriteArrayList<CacheSubscription<T>>();
    private volatile boolean terminated;
    private final CopyOnWriteArrayList<Node<T>> history = new CopyOnWriteArrayList();
    private volatile Context context;
    private Throwable failure;
    private volatile boolean done;

    public MultiCacheOp(Multi<T> upstream) {
        super(upstream);
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        CacheSubscription<T> consumer = new CacheSubscription<T>(downstream, this);
        downstream.onSubscribe(consumer);
        this.addDownstreamSubscription(consumer);
        if (this.hasSubscribedToUpstream.compareAndSet(false, true)) {
            this.context = downstream instanceof ContextSupport ? ((ContextSupport)((Object)downstream)).context() : Context.empty();
            this.upstream.subscribe().withSubscriber(this);
        } else {
            consumer.replay();
        }
    }

    private synchronized void addDownstreamSubscription(CacheSubscription<T> consumer) {
        if (this.terminated) {
            return;
        }
        this.subscribers.add(consumer);
    }

    private synchronized void remove(CacheSubscription<T> consumer) {
        this.subscribers.remove(consumer);
    }

    public void onSubscribe(Subscription s) {
        s.request(Long.MAX_VALUE);
    }

    public synchronized void onNext(T item) {
        this.history.add(new Node<T>(item));
        for (CacheSubscription<T> consumer : this.subscribers) {
            consumer.replay();
        }
    }

    public void onError(Throwable t) {
        if (this.done) {
            return;
        }
        this.failure = t;
        this.done = true;
        this.terminated = true;
        for (CacheSubscription<T> consumer : this.subscribers) {
            consumer.replay();
        }
    }

    public void onComplete() {
        this.done = true;
        this.terminated = true;
        for (CacheSubscription<T> consumer : this.subscribers) {
            consumer.replay();
        }
    }

    @Override
    public Context context() {
        return this.context;
    }

    static final class Node<T> {
        private final T item;

        Node(T item) {
            this.item = item;
        }
    }

    static final class CacheSubscription<T>
    implements Subscription {
        private final MultiSubscriber<? super T> downstream;
        private final MultiCacheOp<T> cache;
        private final AtomicLong requested = new AtomicLong();
        private final AtomicInteger wip = new AtomicInteger();
        private int lastIndex;

        CacheSubscription(MultiSubscriber<? super T> downstream, MultiCacheOp<T> cache) {
            this.downstream = downstream;
            this.cache = cache;
            this.lastIndex = -1;
        }

        public void request(long n) {
            if (n > 0L) {
                Subscriptions.add(this.requested, n);
                this.replay();
            }
        }

        public void replay() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            CopyOnWriteArrayList history = ((MultiCacheOp)this.cache).history;
            while (true) {
                if (((MultiCacheOp)this.cache).done && !this.hasNext()) {
                    if (((MultiCacheOp)this.cache).failure != null) {
                        this.downstream.onError(((MultiCacheOp)this.cache).failure);
                    } else {
                        this.downstream.onCompletion();
                    }
                    return;
                }
                long consumerRequested = this.requested.get();
                if (consumerRequested == Long.MIN_VALUE) {
                    return;
                }
                if (consumerRequested > 0L && this.hasNext()) {
                    ++this.lastIndex;
                    Node node = (Node)history.get(this.lastIndex);
                    this.downstream.onItem(node.item);
                    Subscriptions.subtract(this.requested, 1L);
                    continue;
                }
                if ((missed = this.wip.addAndGet(-missed)) == 0) break;
            }
        }

        public void cancel() {
            if (this.requested.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                ((MultiCacheOp)this.cache).remove(this);
            }
        }

        boolean hasNext() {
            return this.lastIndex < ((MultiCacheOp)this.cache).history.size() - 1;
        }
    }
}

