/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.helpers.test;

import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.CompletableFuture;

public class UniAssertSubscriber<T>
implements UniSubscriber<T> {
    private volatile boolean cancelImmediatelyOnSubscription;
    private volatile UniSubscription subscription;
    private volatile boolean gotSignal;
    private volatile T item;
    private volatile Throwable failure;
    private final CompletableFuture<T> future = new CompletableFuture();
    private volatile String onResultThreadName;
    private volatile String onErrorThreadName;
    private volatile String onSubscribeThreadName;

    public UniAssertSubscriber(boolean cancelled) {
        this.cancelImmediatelyOnSubscription = cancelled;
    }

    public UniAssertSubscriber() {
        this(false);
    }

    public static <T> UniAssertSubscriber<T> create() {
        return new UniAssertSubscriber<T>();
    }

    @Override
    public synchronized void onSubscribe(UniSubscription subscription) {
        this.onSubscribeThreadName = Thread.currentThread().getName();
        if (this.cancelImmediatelyOnSubscription) {
            this.subscription = subscription;
            subscription.cancel();
            this.future.cancel(false);
            return;
        }
        this.subscription = subscription;
    }

    @Override
    public synchronized void onItem(T item) {
        this.gotSignal = true;
        this.item = item;
        this.onResultThreadName = Thread.currentThread().getName();
        this.future.complete(item);
    }

    @Override
    public synchronized void onFailure(Throwable failure) {
        this.gotSignal = true;
        this.failure = failure;
        this.onErrorThreadName = Thread.currentThread().getName();
        this.future.completeExceptionally(failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniAssertSubscriber<T> await() {
        CompletableFuture<T> fut;
        UniAssertSubscriber uniAssertSubscriber = this;
        synchronized (uniAssertSubscriber) {
            fut = this.future;
        }
        try {
            fut.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public synchronized UniAssertSubscriber<T> assertCompleted() {
        if (!this.future.isDone()) {
            throw new IllegalStateException("Not done yet");
        }
        if (this.future.isCompletedExceptionally()) {
            throw new AssertionError((Object)("The uni didn't completed successfully: " + this.failure));
        }
        if (this.future.isCancelled()) {
            throw new AssertionError((Object)"The uni didn't completed successfully, it was cancelled");
        }
        return this;
    }

    public synchronized UniAssertSubscriber<T> assertFailed() {
        if (!this.future.isDone()) {
            throw new IllegalStateException("Not done yet");
        }
        if (!this.future.isCompletedExceptionally()) {
            throw new AssertionError((Object)("The uni completed successfully: " + this.item));
        }
        if (this.future.isCancelled()) {
            throw new AssertionError((Object)"The uni didn't completed successfully, it was cancelled");
        }
        return this;
    }

    public synchronized T getItem() {
        if (!this.future.isDone()) {
            throw new IllegalStateException("Not done yet");
        }
        return this.item;
    }

    public synchronized Throwable getFailure() {
        if (!this.future.isDone()) {
            throw new IllegalStateException("Not done yet");
        }
        return this.failure;
    }

    public UniAssertSubscriber<T> assertItem(T expected) {
        T item = this.getItem();
        if (item == null && expected != null) {
            throw new AssertionError((Object)("Expected: " + expected + " but was `null`"));
        }
        if (item != null && !item.equals(expected)) {
            throw new AssertionError((Object)("Expected: " + expected + " but was " + item));
        }
        if (this.failure != null) {
            throw new AssertionError((Object)("Got item and failure " + this.failure));
        }
        return this;
    }

    public UniAssertSubscriber<T> assertFailedWith(Class<? extends Throwable> typeOfException, String message) {
        Throwable failure = this.getFailure();
        if (failure == null) {
            throw new AssertionError((Object)"Expected a failure, but the Uni completed with an item");
        }
        if (!typeOfException.isInstance(failure)) {
            throw new AssertionError((Object)("Expected a failure of type " + typeOfException + ", but it was a " + failure.getClass()));
        }
        if (!failure.getMessage().contains(message)) {
            throw new AssertionError((Object)("Expected a failure with a message containing '" + message + "', but it was '" + failure.getMessage() + "'"));
        }
        return this;
    }

    public String getOnItemThreadName() {
        return this.onResultThreadName;
    }

    public String getOnFailureThreadName() {
        return this.onErrorThreadName;
    }

    public String getOnSubscribeThreadName() {
        return this.onSubscribeThreadName;
    }

    public void cancel() {
        if (this.subscription == null) {
            this.cancelImmediatelyOnSubscription = true;
        } else {
            this.subscription.cancel();
        }
    }

    public UniAssertSubscriber<T> assertTerminated() {
        if (this.gotSignal) {
            return this;
        }
        throw new AssertionError((Object)"The uni didn't sent a signal");
    }

    public UniAssertSubscriber<T> assertNotTerminated() {
        if (!this.gotSignal) {
            return this;
        }
        throw new AssertionError((Object)"The uni completed");
    }

    public UniAssertSubscriber<T> assertSubscribed() {
        if (this.subscription == null) {
            throw new AssertionError((Object)"Expected to have a subscription");
        }
        return this;
    }

    public UniAssertSubscriber<T> assertNotSubscribed() {
        if (this.subscription != null) {
            throw new AssertionError((Object)"Expected to not have a subscription");
        }
        return this;
    }
}

