/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.context;

import io.smallrye.context.SmallRyeThreadContext;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.concurrent.CompletableFuture;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.context.spi.ContextManager;
import org.eclipse.microprofile.context.spi.ContextManagerExtension;

public class MutinyContextManagerExtension
implements ContextManagerExtension {
    public void setup(ContextManager manager) {
        Infrastructure.setCompletableFutureWrapper((UnaryOperator)new UnaryOperator<CompletableFuture<?>>(){

            @Override
            public CompletableFuture<?> apply(CompletableFuture<?> t) {
                SmallRyeThreadContext threadContext = SmallRyeThreadContext.getCurrentThreadContextOrDefaultContexts();
                return threadContext.withContextCapture(t);
            }
        });
    }
}

