/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.version;

import io.smallrye.common.version.AbstractVersionIterator;
import io.smallrye.common.version.Messages;
import io.smallrye.common.version.VersionSyntaxException;
import java.util.NoSuchElementException;

final class JpmsVersionIterator
extends AbstractVersionIterator {
    static final int GOT_PRE_RELEASE = 1;
    static final int GOT_BUILD = 2;

    JpmsVersionIterator(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        if (!super.hasNext()) {
            return false;
        }
        long mark = this.mark();
        try {
            super.next();
            AbstractVersionIterator.TokenType t = this.currentType();
            if (t == AbstractVersionIterator.TokenType.PART_ALPHA || t == AbstractVersionIterator.TokenType.PART_NUMBER && !this.numberPartEquals(0) || JpmsVersionIterator.cookieToExtraBits(mark) == 0 && t == AbstractVersionIterator.TokenType.SEP && super.getSeparatorCodePoint() != 46) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.hasNext();
            return bl;
        }
        finally {
            this.reset(mark);
        }
    }

    void skipTrailer(long mark) {
        assert (this.hasNext());
        this.next();
        if (this.isNumberPart() && this.numberPartEquals(0)) {
            this.next();
            if (this.isSeparator()) {
                int scp = this.getSeparatorCodePoint();
                if (scp == 45) {
                    return;
                }
                if (scp == 43) {
                    this.skipTrailer(this.mark());
                    return;
                }
            }
            this.skipTrailer(mark);
        } else {
            this.reset(mark);
        }
    }

    @Override
    public void next() throws NoSuchElementException, VersionSyntaxException {
        AbstractVersionIterator.TokenType p = this.currentType();
        super.next();
        AbstractVersionIterator.TokenType t = this.currentType();
        if (!(p != AbstractVersionIterator.TokenType.SEP && p != AbstractVersionIterator.TokenType.SEP_EMPTY || t != AbstractVersionIterator.TokenType.SEP && t != AbstractVersionIterator.TokenType.SEP_EMPTY)) {
            int idx = JpmsVersionIterator.cookieToStartIndex(this.cookie);
            throw Messages.msg.invalidCodePoint(new String(Character.toChars(this.string.codePointAt(idx))), idx, this.string);
        }
        if (p == AbstractVersionIterator.TokenType.INITIAL && !this.isNumberPart()) {
            throw Messages.msg.expectedNumber();
        }
        int got = this.getExtraBits();
        if (this.isSeparator()) {
            if (super.isEmptySeparator()) {
                this.skipTrailer(this.mark());
            } else {
                int scp = super.getSeparatorCodePoint();
                if (scp == 46 || got >= 1 && scp == 45 || got >= 2 && scp == 43) {
                    this.setCurrentToken(AbstractVersionIterator.TokenType.SEP_EMPTY, this.getEndIndex(), this.getEndIndex(), got);
                    this.skipTrailer(this.mark());
                } else {
                    this.setCurrentToken(this.currentType(), this.getStartIndex(), this.getEndIndex(), got + 1);
                    if (!super.hasNext()) {
                        if (got == 0) {
                            throw Messages.msg.emptyPreRelease();
                        }
                        if (got == 1) {
                            throw Messages.msg.emptyBuild();
                        }
                    }
                }
            }
        }
    }

    @Override
    protected boolean isSeparatorCodePoint(int cp) {
        int got = this.getExtraBits();
        return cp == 46 || got < 1 && cp == 45 || got < 2 && cp == 43;
    }

    @Override
    protected int numericCodePointValue(int cp) {
        int v = cp - 48;
        return v < 0 || v > 9 ? -1 : v;
    }

    @Override
    protected boolean isAlphaCodePoint(int cp) {
        return !this.isSeparatorCodePoint(cp) && this.numericCodePointValue(cp) == -1;
    }

    @Override
    public boolean isEmptySeparator() {
        return false;
    }

    @Override
    public int getSeparatorCodePoint() {
        if (super.isEmptySeparator()) {
            return 46;
        }
        int got = this.getExtraBits();
        if (got == 1) {
            return 45;
        }
        assert (got == 2);
        return 43;
    }

    @Override
    public boolean isNonEmptySeparator() {
        return super.isSeparator();
    }
}

