/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl.verifier;

import io.smallrye.classfile.impl.verifier.VerificationFrame;
import io.smallrye.classfile.impl.verifier.VerificationType;
import io.smallrye.classfile.impl.verifier.VerificationWrapper;
import io.smallrye.classfile.impl.verifier.VerifierImpl;
import java.util.ArrayList;
import java.util.List;

class VerificationTable {
    private final int _code_length;
    private final int _frame_count;
    private final List<VerificationFrame> _frame_array;
    private final VerifierImpl _verifier;

    int get_frame_count() {
        return this._frame_count;
    }

    int get_offset(int index) {
        return this._frame_array.get(index).offset();
    }

    VerificationTable(StackMapReader reader, VerificationWrapper.ConstantPoolWrapper cp, VerifierImpl v) {
        this._verifier = v;
        this._code_length = reader.code_length();
        int _frame_count = reader.get_frame_count();
        this._frame_array = new ArrayList<VerificationFrame>(_frame_count);
        if (_frame_count > 0) {
            while (!reader.at_end()) {
                VerificationFrame frame = reader.next();
                if (frame == null) continue;
                this._frame_array.add(frame);
            }
        }
        reader.check_end();
        this._frame_count = this._frame_array.size();
    }

    int get_index_from_offset(int offset) {
        int i;
        for (i = 0; i < this._frame_count; ++i) {
            if (this._frame_array.get(i).offset() != offset) continue;
            return i;
        }
        return i;
    }

    boolean match_stackmap(VerificationFrame frame, int target, boolean match, boolean update) {
        int index = this.get_index_from_offset(target);
        return this.match_stackmap(frame, target, index, match, update);
    }

    boolean match_stackmap(VerificationFrame frame, int target, int frame_index, boolean match, boolean update) {
        if (frame_index < 0 || frame_index >= this._frame_count) {
            this._verifier.verifyError(String.format("Expecting a stackmap frame at branch target %d", target));
        }
        VerificationFrame stackmap_frame = this._frame_array.get(frame_index);
        boolean result = true;
        if (match) {
            result = frame.is_assignable_to(stackmap_frame);
        }
        if (update) {
            int lsize = stackmap_frame.locals_size();
            int ssize = stackmap_frame.stack_size();
            if (frame.locals_size() > lsize || frame.stack_size() > ssize) {
                frame.reset();
            }
            frame.set_locals_size(lsize);
            frame.copy_locals(stackmap_frame);
            frame.set_stack_size(ssize);
            frame.copy_stack(stackmap_frame);
            frame.set_flags(stackmap_frame.flags());
        }
        return result;
    }

    void check_jump_target(VerificationFrame frame, int target) {
        boolean match = this.match_stackmap(frame, target, true, false);
        if (!match || target < 0 || target >= this._code_length) {
            this._verifier.verifyError(String.format("Inconsistent stackmap frames at branch target %d", target));
        }
    }

    static class StackMapReader {
        private final VerificationWrapper.ConstantPoolWrapper _cp;
        private final StackMapStream _stream;
        private final byte[] _code_data;
        private final int _code_length;
        private final int _frame_count;
        private int _parsed_frame_count;
        private VerificationFrame _prev_frame;
        char _max_locals;
        char _max_stack;
        boolean _first;
        private final VerifierImpl _verifier;

        void check_verification_type_array_size(int size, int max_size) {
            if (size < 0 || size > max_size) {
                this._verifier.classError("StackMapTable format error: bad type array size");
            }
        }

        public int get_frame_count() {
            return this._frame_count;
        }

        public VerificationFrame prev_frame() {
            return this._prev_frame;
        }

        public byte[] code_data() {
            return this._code_data;
        }

        public int code_length() {
            return this._code_length;
        }

        public boolean at_end() {
            return this._stream.at_end();
        }

        public VerificationFrame next() {
            ++this._parsed_frame_count;
            this.check_size();
            VerificationFrame frame = this.next_helper();
            if (frame != null) {
                this.check_offset(frame);
                this._prev_frame = frame;
            }
            return frame;
        }

        public void check_end() {
            if (this._frame_count != this._parsed_frame_count) {
                this._verifier.verifyError("wrong attribute size");
            }
        }

        public StackMapReader(byte[] stackmapData, byte[] code_data, int code_len, VerificationFrame init_frame, char max_locals, char max_stack, VerificationWrapper.ConstantPoolWrapper cp, VerifierImpl context) {
            this._verifier = context;
            this._stream = new StackMapStream(stackmapData, this._verifier);
            this._code_data = code_data;
            this._code_length = code_len;
            this._parsed_frame_count = 0;
            this._prev_frame = init_frame;
            this._max_locals = max_locals;
            this._max_stack = max_stack;
            this._first = true;
            if (stackmapData != null) {
                this._cp = cp;
                this._frame_count = this._stream.get_u2();
            } else {
                this._cp = null;
                this._frame_count = 0;
            }
        }

        void check_offset(VerificationFrame frame) {
            int offset = frame.offset();
            if (offset >= this._code_length || this._code_data[offset] == 0) {
                this._verifier.verifyError("StackMapTable error: bad offset");
            }
        }

        void check_size() {
            if (this._frame_count < this._parsed_frame_count) {
                this._verifier.verifyError("wrong attribute size");
            }
        }

        int chop(VerificationType[] locals, int length, int chops) {
            if (locals == null) {
                return -1;
            }
            int pos = length - 1;
            for (int i = 0; i < chops; ++i) {
                pos = locals[pos].is_category2_2nd() ? (pos -= 2) : --pos;
                if (pos >= 0 || i >= chops - 1) continue;
                return -1;
            }
            return pos + 1;
        }

        VerificationType parse_verification_type(int[] flags) {
            int tag = this._stream.get_u1();
            if (tag < 6) {
                return VerificationType.from_tag(tag, this._verifier);
            }
            if (tag == 7) {
                int class_index = this._stream.get_u2();
                int nconstants = this._cp.entryCount();
                if (class_index <= 0 || class_index >= nconstants || this._cp.tagAt(class_index) != 7) {
                    this._verifier.classError("bad class index");
                }
                return VerificationType.reference_type(this._cp.classNameAt(class_index));
            }
            if (tag == 6) {
                if (flags != null) {
                    flags[0] = flags[0] | 1;
                }
                return VerificationType.uninitialized_this_type;
            }
            if (tag == 8) {
                int offset = this._stream.get_u2();
                if (offset >= this._code_length || this._code_data[offset] != 2) {
                    this._verifier.classError("StackMapTable format error: bad offset for Uninitialized");
                }
                return VerificationType.uninitialized_type(offset);
            }
            this._verifier.classError("bad verification type");
            return VerificationType.bogus_type;
        }

        VerificationFrame next_helper() {
            Object locals = null;
            int frame_type = this._stream.get_u1();
            if (frame_type <= 63) {
                int offset;
                if (this._first) {
                    offset = frame_type;
                    if (this._prev_frame.locals_size() > 0) {
                        locals = new VerificationType[this._prev_frame.locals_size()];
                    }
                } else {
                    offset = this._prev_frame.offset() + frame_type + 1;
                    locals = this._prev_frame.locals();
                }
                VerificationFrame frame = new VerificationFrame(offset, this._prev_frame.flags(), this._prev_frame.locals_size(), 0, this._max_locals, this._max_stack, (VerificationType[])locals, null, this._verifier);
                if (this._first && locals != null) {
                    frame.copy_locals(this._prev_frame);
                }
                this._first = false;
                return frame;
            }
            if (frame_type <= 127) {
                int offset;
                if (this._first) {
                    offset = frame_type - 64;
                    if (this._prev_frame.locals_size() > 0) {
                        locals = new VerificationType[this._prev_frame.locals_size()];
                    }
                } else {
                    offset = this._prev_frame.offset() + frame_type - 64 + 1;
                    locals = this._prev_frame.locals();
                }
                VerificationType[] stack = new VerificationType[2];
                int stack_size = 1;
                stack[0] = this.parse_verification_type(null);
                if (stack[0].is_category2()) {
                    stack[1] = stack[0].to_category2_2nd(this._verifier);
                    stack_size = 2;
                }
                this.check_verification_type_array_size(stack_size, this._max_stack);
                VerificationFrame frame = new VerificationFrame(offset, this._prev_frame.flags(), this._prev_frame.locals_size(), stack_size, this._max_locals, this._max_stack, (VerificationType[])locals, stack, this._verifier);
                if (this._first && locals != null) {
                    frame.copy_locals(this._prev_frame);
                }
                this._first = false;
                return frame;
            }
            int offset_delta = this._stream.get_u2();
            if (frame_type < 247) {
                this._verifier.classError("reserved frame type");
            }
            if (frame_type == 247) {
                int offset;
                if (this._first) {
                    offset = offset_delta;
                    if (this._prev_frame.locals_size() > 0) {
                        locals = new VerificationType[this._prev_frame.locals_size()];
                    }
                } else {
                    offset = this._prev_frame.offset() + offset_delta + 1;
                    locals = this._prev_frame.locals();
                }
                VerificationType[] stack = new VerificationType[2];
                int stack_size = 1;
                stack[0] = this.parse_verification_type(null);
                if (stack[0].is_category2()) {
                    stack[1] = stack[0].to_category2_2nd(this._verifier);
                    stack_size = 2;
                }
                this.check_verification_type_array_size(stack_size, this._max_stack);
                VerificationFrame frame = new VerificationFrame(offset, this._prev_frame.flags(), this._prev_frame.locals_size(), stack_size, this._max_locals, this._max_stack, (VerificationType[])locals, stack, this._verifier);
                if (this._first && locals != null) {
                    frame.copy_locals(this._prev_frame);
                }
                this._first = false;
                return frame;
            }
            if (frame_type <= 251) {
                int offset;
                locals = this._prev_frame.locals();
                int length = this._prev_frame.locals_size();
                int chops = 251 - frame_type;
                int new_length = length;
                int flags = this._prev_frame.flags();
                if (chops != 0) {
                    new_length = this.chop((VerificationType[])locals, length, chops);
                    this.check_verification_type_array_size(new_length, this._max_locals);
                    flags = 0;
                    for (int i = 0; i < new_length; ++i) {
                        if (!locals[i].is_uninitialized_this(this._verifier)) continue;
                        flags |= 1;
                        break;
                    }
                }
                if (this._first) {
                    offset = offset_delta;
                    locals = new_length > 0 ? new VerificationType[new_length] : null;
                } else {
                    offset = this._prev_frame.offset() + offset_delta + 1;
                }
                VerificationFrame frame = new VerificationFrame(offset, flags, new_length, 0, this._max_locals, this._max_stack, (VerificationType[])locals, null, this._verifier);
                if (this._first && locals != null) {
                    frame.copy_locals(this._prev_frame);
                }
                this._first = false;
                return frame;
            }
            if (frame_type <= 254) {
                int i;
                int appends = frame_type - 252 + 1;
                int real_length = this._prev_frame.locals_size();
                int new_length = real_length + appends * 2;
                locals = new VerificationType[new_length];
                VerificationType[] pre_locals = this._prev_frame.locals();
                for (i = 0; i < this._prev_frame.locals_size(); ++i) {
                    locals[i] = pre_locals[i];
                }
                int[] flags = new int[]{this._prev_frame.flags()};
                for (i = 0; i < appends; ++i) {
                    locals[real_length] = this.parse_verification_type(flags);
                    if (locals[real_length].is_category2()) {
                        locals[real_length + 1] = locals[real_length].to_category2_2nd(this._verifier);
                        ++real_length;
                    }
                    ++real_length;
                }
                this.check_verification_type_array_size(real_length, this._max_locals);
                int offset = this._first ? offset_delta : this._prev_frame.offset() + offset_delta + 1;
                VerificationFrame frame = new VerificationFrame(offset, flags[0], real_length, 0, this._max_locals, this._max_stack, (VerificationType[])locals, null, this._verifier);
                this._first = false;
                return frame;
            }
            if (frame_type == 255) {
                int i;
                int[] flags = new int[]{0};
                int locals_size = this._stream.get_u2();
                int real_locals_size = 0;
                if (locals_size > 0) {
                    locals = new VerificationType[locals_size * 2];
                }
                for (i = 0; i < locals_size; ++i) {
                    locals[real_locals_size] = this.parse_verification_type(flags);
                    if (locals[real_locals_size].is_category2()) {
                        locals[real_locals_size + 1] = locals[real_locals_size].to_category2_2nd(this._verifier);
                        ++real_locals_size;
                    }
                    ++real_locals_size;
                }
                this.check_verification_type_array_size(real_locals_size, this._max_locals);
                int stack_size = this._stream.get_u2();
                int real_stack_size = 0;
                VerificationType[] stack = null;
                if (stack_size > 0) {
                    stack = new VerificationType[stack_size * 2];
                }
                for (i = 0; i < stack_size; ++i) {
                    stack[real_stack_size] = this.parse_verification_type(null);
                    if (stack[real_stack_size].is_category2()) {
                        stack[real_stack_size + 1] = stack[real_stack_size].to_category2_2nd(this._verifier);
                        ++real_stack_size;
                    }
                    ++real_stack_size;
                }
                this.check_verification_type_array_size(real_stack_size, this._max_stack);
                int offset = this._first ? offset_delta : this._prev_frame.offset() + offset_delta + 1;
                VerificationFrame frame = new VerificationFrame(offset, flags[0], real_locals_size, real_stack_size, this._max_locals, this._max_stack, (VerificationType[])locals, stack, this._verifier);
                this._first = false;
                return frame;
            }
            this._verifier.classError("reserved frame type");
            return null;
        }
    }

    static class StackMapStream {
        private final byte[] _data;
        private int _index;
        private final VerifierImpl _verifier;

        StackMapStream(byte[] ah, VerifierImpl context) {
            this._data = ah;
            this._index = 0;
            this._verifier = context;
        }

        int get_u1() {
            if (this._data == null || this._index >= this._data.length) {
                this._verifier.classError("access beyond the end of attribute");
            }
            return this._data[this._index++] & 0xFF;
        }

        int get_u2() {
            int res = this.get_u1() << 8;
            return res | this.get_u1();
        }

        boolean at_end() {
            return this._data == null || this._index == this._data.length;
        }
    }
}

