/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl.verifier;

import io.smallrye.classfile.impl.verifier.VerificationSignature;
import io.smallrye.classfile.impl.verifier.VerificationType;
import io.smallrye.classfile.impl.verifier.VerificationWrapper;
import io.smallrye.classfile.impl.verifier.VerifierImpl;
import java.util.Arrays;

class VerificationFrame {
    public static final int FLAG_THIS_UNINIT = 1;
    private int _offset;
    private int _locals_size;
    private int _stack_size;
    private int _stack_mark;
    private final int _max_locals;
    private final int _max_stack;
    private int _flags;
    private final VerificationType[] _locals;
    private final VerificationType[] _stack;
    private final VerifierImpl _verifier;

    public VerificationFrame(int offset, int flags, int locals_size, int stack_size, int max_locals, int max_stack, VerificationType[] locals, VerificationType[] stack, VerifierImpl v) {
        this._offset = offset;
        this._locals_size = locals_size;
        this._stack_size = stack_size;
        this._stack_mark = -1;
        this._max_locals = max_locals;
        this._max_stack = max_stack;
        this._flags = flags;
        this._locals = locals;
        this._stack = stack;
        this._verifier = v;
    }

    public String toString() {
        return "frame @" + this._offset + " with locals " + String.valueOf(this._locals == null ? "[]" : Arrays.asList(this._locals)) + " and stack " + String.valueOf(this._stack == null ? "[]" : Arrays.asList(this._stack));
    }

    void set_offset(int offset) {
        this._offset = offset;
    }

    void set_flags(int flags) {
        this._flags = flags;
    }

    void set_locals_size(int locals_size) {
        this._locals_size = locals_size;
    }

    void set_stack_size(int stack_size) {
        this._stack_size = this._stack_mark = stack_size;
    }

    int offset() {
        return this._offset;
    }

    VerifierImpl verifier() {
        return this._verifier;
    }

    int flags() {
        return this._flags;
    }

    int locals_size() {
        return this._locals_size;
    }

    VerificationType[] locals() {
        return this._locals;
    }

    int stack_size() {
        return this._stack_size;
    }

    VerificationType[] stack() {
        return this._stack;
    }

    int max_locals() {
        return this._max_locals;
    }

    boolean flag_this_uninit() {
        return (this._flags & 1) == 1;
    }

    void reset() {
        int i;
        for (i = 0; i < this._max_locals; ++i) {
            this._locals[i] = VerificationType.bogus_type;
        }
        for (i = 0; i < this._max_stack; ++i) {
            this._stack[i] = VerificationType.bogus_type;
        }
    }

    void set_mark() {
        if (this._stack_mark != -1) {
            for (int i = this._stack_mark - 1; i >= this._stack_size; --i) {
                this._stack[i] = VerificationType.bogus_type;
            }
            this._stack_mark = this._stack_size;
        }
    }

    void push_stack(VerificationType type) {
        if (type.is_check()) {
            this._verifier.verifyError("Must be a real type");
        }
        if (this._stack_size >= this._max_stack) {
            this._verifier.verifyError("Operand stack overflow");
        }
        this._stack[this._stack_size++] = type;
    }

    void push_stack_2(VerificationType type1, VerificationType type2) {
        if (!type1.is_long() && !type1.is_double()) {
            this._verifier.verifyError("must be long/double");
        }
        if (!type2.is_long2() && !type2.is_double2()) {
            this._verifier.verifyError("must be long/double_2");
        }
        if (this._stack_size >= this._max_stack - 1) {
            this._verifier.verifyError("Operand stack overflow");
        }
        this._stack[this._stack_size++] = type1;
        this._stack[this._stack_size++] = type2;
    }

    VerificationType pop_stack() {
        if (this._stack_size <= 0) {
            this._verifier.verifyError("Operand stack underflow");
        }
        return this._stack[--this._stack_size];
    }

    VerificationType pop_stack(VerificationType type) {
        VerificationType top;
        boolean subtype;
        if (this._stack_size != 0 && (subtype = type.is_assignable_from(top = this._stack[this._stack_size - 1], this.verifier()))) {
            --this._stack_size;
            return top;
        }
        return this.pop_stack_ex(type);
    }

    void pop_stack_2(VerificationType type1, VerificationType type2) {
        if (!type1.is_long2() && !type1.is_double2()) {
            this._verifier.verifyError("must be long/double");
        }
        if (!type2.is_long() && !type2.is_double()) {
            this._verifier.verifyError("must be long/double_2");
        }
        if (this._stack_size >= 2) {
            VerificationType top1 = this._stack[this._stack_size - 1];
            boolean subtype1 = type1.is_assignable_from(top1, this.verifier());
            VerificationType top2 = this._stack[this._stack_size - 2];
            boolean subtype2 = type2.is_assignable_from(top2, this.verifier());
            if (subtype1 && subtype2) {
                this._stack_size -= 2;
                return;
            }
        }
        this.pop_stack_ex(type1);
        this.pop_stack_ex(type2);
    }

    VerificationFrame(int max_locals, int max_stack, VerifierImpl verifier) {
        int i;
        this._offset = 0;
        this._locals_size = 0;
        this._stack_size = 0;
        this._stack_mark = 0;
        this._max_locals = max_locals;
        this._max_stack = max_stack;
        this._flags = 0;
        this._verifier = verifier;
        this._locals = new VerificationType[max_locals];
        this._stack = new VerificationType[max_stack];
        for (i = 0; i < max_locals; ++i) {
            this._locals[i] = VerificationType.bogus_type;
        }
        for (i = 0; i < max_stack; ++i) {
            this._stack[i] = VerificationType.bogus_type;
        }
    }

    VerificationFrame frame_in_exception_handler(int flags) {
        return new VerificationFrame(this._offset, flags, this._locals_size, 0, this._max_locals, this._max_stack, this._locals, new VerificationType[1], this._verifier);
    }

    void initialize_object(VerificationType old_object, VerificationType new_object) {
        int i;
        for (i = 0; i < this._max_locals; ++i) {
            if (!this._locals[i].equals(old_object)) continue;
            this._locals[i] = new_object;
        }
        for (i = 0; i < this._stack_size; ++i) {
            if (!this._stack[i].equals(old_object)) continue;
            this._stack[i] = new_object;
        }
        if (old_object.is_uninitialized_this(this._verifier)) {
            this._flags = 0;
        }
    }

    VerificationType set_locals_from_arg(VerificationWrapper.MethodWrapper m, VerificationType thisKlass) {
        VerificationSignature ss = new VerificationSignature(m.descriptor(), true, this._verifier);
        int init_local_num = 0;
        if (!m.isStatic()) {
            ++init_local_num;
            if ("<init>".equals(m.name()) && !"java/lang/Object".equals(thisKlass.name())) {
                this._locals[0] = VerificationType.uninitialized_this_type;
                this._flags |= 1;
            } else {
                this._locals[0] = thisKlass;
            }
        }
        while (!ss.atReturnType()) {
            init_local_num += this._verifier.change_sig_to_verificationType(ss, this._locals, init_local_num);
            ss.next();
        }
        this._locals_size = init_local_num;
        switch (ss.type()) {
            case T_OBJECT: 
            case T_ARRAY: {
                String sig = ss.asSymbol();
                return VerificationType.reference_type(sig);
            }
            case T_INT: {
                return VerificationType.integer_type;
            }
            case T_BYTE: {
                return VerificationType.byte_type;
            }
            case T_CHAR: {
                return VerificationType.char_type;
            }
            case T_SHORT: {
                return VerificationType.short_type;
            }
            case T_BOOLEAN: {
                return VerificationType.boolean_type;
            }
            case T_FLOAT: {
                return VerificationType.float_type;
            }
            case T_DOUBLE: {
                return VerificationType.double_type;
            }
            case T_LONG: {
                return VerificationType.long_type;
            }
            case T_VOID: {
                return VerificationType.bogus_type;
            }
        }
        this._verifier.verifyError("Should not reach here");
        return VerificationType.bogus_type;
    }

    void copy_locals(VerificationFrame src) {
        int len;
        int n = len = src.locals_size() < this._locals_size ? src.locals_size() : this._locals_size;
        if (len > 0) {
            System.arraycopy(src.locals(), 0, this._locals, 0, len);
        }
    }

    void copy_stack(VerificationFrame src) {
        int len;
        int n = len = src.stack_size() < this._stack_size ? src.stack_size() : this._stack_size;
        if (len > 0) {
            System.arraycopy(src.stack(), 0, this._stack, 0, len);
        }
    }

    private int is_assignable_to(VerificationType[] from, VerificationType[] to, int len) {
        int i;
        for (i = 0; i < len && to[i].is_assignable_from(from[i], this.verifier()); ++i) {
        }
        return i;
    }

    boolean is_assignable_to(VerificationFrame target) {
        int mismatch_loc;
        if (this._max_locals != target.max_locals()) {
            this._verifier.verifyError("Locals size mismatch", this, target);
        }
        if (this._stack_size != target.stack_size()) {
            this._verifier.verifyError("Stack size mismatch", this, target);
        }
        if ((mismatch_loc = this.is_assignable_to(this._locals, target.locals(), target.locals_size())) != target.locals_size()) {
            this._verifier.verifyError("Bad type", this, target);
        }
        if ((mismatch_loc = this.is_assignable_to(this._stack, target.stack(), this._stack_size)) != this._stack_size) {
            this._verifier.verifyError("Bad type", this, target);
        }
        if ((this._flags | target.flags()) == target.flags()) {
            return true;
        }
        this._verifier.verifyError("Bad flags", this, target);
        return false;
    }

    VerificationType pop_stack_ex(VerificationType type) {
        VerificationType top;
        boolean subtype;
        if (this._stack_size <= 0) {
            this._verifier.verifyError("Operand stack underflow");
        }
        if (!(subtype = type.is_assignable_from(top = this._stack[--this._stack_size], this.verifier()))) {
            this._verifier.verifyError("Bad type on operand stack");
        }
        return top;
    }

    VerificationType get_local(int index, VerificationType type) {
        boolean subtype;
        if (index >= this._max_locals) {
            this._verifier.verifyError("Local variable table overflow");
        }
        if (!(subtype = type.is_assignable_from(this._locals[index], this.verifier()))) {
            this._verifier.verifyError("Bad local variable type");
        }
        if (index >= this._locals_size) {
            this._locals_size = index + 1;
        }
        return this._locals[index];
    }

    void get_local_2(int index, VerificationType type1, VerificationType type2) {
        boolean subtype;
        if (!type1.is_long() && !type1.is_double()) {
            this._verifier.verifyError("must be long/double");
        }
        if (!type2.is_long2() && !type2.is_double2()) {
            this._verifier.verifyError("must be long/double_2");
        }
        if (index >= this._locals_size - 1) {
            this._verifier.verifyError("get long/double overflows locals");
        }
        if (!(subtype = type1.is_assignable_from(this._locals[index], this.verifier()))) {
            this._verifier.verifyError("Bad local variable type");
        } else {
            subtype = type2.is_assignable_from(this._locals[index + 1], this.verifier());
            if (!subtype) {
                this._verifier.verifyError("Bad local variable type");
            }
        }
    }

    void set_local(int index, VerificationType type) {
        if (type.is_check()) {
            this._verifier.verifyError("Must be a real type");
        }
        if (index >= this._max_locals) {
            this._verifier.verifyError("Local variable table overflow");
        }
        if (this._locals[index].is_double() || this._locals[index].is_long()) {
            if (index + 1 >= this._locals_size) {
                this._verifier.verifyError("Local variable table overflow");
            }
            this._locals[index + 1] = VerificationType.bogus_type;
        }
        if (this._locals[index].is_double2() || this._locals[index].is_long2()) {
            if (index < 1) {
                this._verifier.verifyError("Local variable table underflow");
            }
            this._locals[index - 1] = VerificationType.bogus_type;
        }
        this._locals[index] = type;
        if (index >= this._locals_size) {
            for (int i = this._locals_size; i < index; ++i) {
                if (this._locals[i] == VerificationType.bogus_type) continue;
                this._verifier.verifyError("holes must be bogus type");
            }
            this._locals_size = index + 1;
        }
    }

    void set_local_2(int index, VerificationType type1, VerificationType type2) {
        if (!type1.is_long() && !type1.is_double()) {
            this._verifier.verifyError("must be long/double");
        }
        if (!type2.is_long2() && !type2.is_double2()) {
            this._verifier.verifyError("must be long/double_2");
        }
        if (index >= this._max_locals - 1) {
            this._verifier.verifyError("Local variable table overflow");
        }
        if (this._locals[index + 1].is_double() || this._locals[index + 1].is_long()) {
            if (index + 2 >= this._locals_size) {
                this._verifier.verifyError("Local variable table overflow");
            }
            this._locals[index + 2] = VerificationType.bogus_type;
        }
        if (this._locals[index].is_double2() || this._locals[index].is_long2()) {
            if (index < 1) {
                this._verifier.verifyError("Local variable table underflow");
            }
            this._locals[index - 1] = VerificationType.bogus_type;
        }
        this._locals[index] = type1;
        this._locals[index + 1] = type2;
        if (index >= this._locals_size - 1) {
            for (int i = this._locals_size; i < index; ++i) {
                if (this._locals[i] == VerificationType.bogus_type) continue;
                this._verifier.verifyError("holes must be bogus type");
            }
            this._locals_size = index + 2;
        }
    }
}

