/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.Attributes;
import io.smallrye.classfile.BootstrapMethodEntry;
import io.smallrye.classfile.ClassReader;
import io.smallrye.classfile.attribute.BootstrapMethodsAttribute;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.constantpool.ConstantDynamicEntry;
import io.smallrye.classfile.constantpool.ConstantPool;
import io.smallrye.classfile.constantpool.ConstantPoolBuilder;
import io.smallrye.classfile.constantpool.ConstantPoolException;
import io.smallrye.classfile.constantpool.DoubleEntry;
import io.smallrye.classfile.constantpool.FieldRefEntry;
import io.smallrye.classfile.constantpool.FloatEntry;
import io.smallrye.classfile.constantpool.IntegerEntry;
import io.smallrye.classfile.constantpool.InterfaceMethodRefEntry;
import io.smallrye.classfile.constantpool.InvokeDynamicEntry;
import io.smallrye.classfile.constantpool.LoadableConstantEntry;
import io.smallrye.classfile.constantpool.LongEntry;
import io.smallrye.classfile.constantpool.MemberRefEntry;
import io.smallrye.classfile.constantpool.MethodHandleEntry;
import io.smallrye.classfile.constantpool.MethodRefEntry;
import io.smallrye.classfile.constantpool.MethodTypeEntry;
import io.smallrye.classfile.constantpool.ModuleEntry;
import io.smallrye.classfile.constantpool.NameAndTypeEntry;
import io.smallrye.classfile.constantpool.PackageEntry;
import io.smallrye.classfile.constantpool.PoolEntry;
import io.smallrye.classfile.constantpool.StringEntry;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.AbstractPoolEntry;
import io.smallrye.classfile.impl.BootstrapMethodEntryImpl;
import io.smallrye.classfile.impl.BufWriterImpl;
import io.smallrye.classfile.impl.ClassReaderImpl;
import io.smallrye.classfile.impl.EntryMap;
import io.smallrye.classfile.impl.UnboundAttribute;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.invoke.TypeDescriptor;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class SplitConstantPool
implements ConstantPoolBuilder {
    private final ClassReaderImpl parent;
    private final int parentSize;
    private final int parentBsmSize;
    private int size;
    private int bsmSize;
    private PoolEntry[] myEntries;
    private BootstrapMethodEntryImpl[] myBsmEntries;
    private boolean doneFullScan;
    private EntryMap map;
    private EntryMap bsmMap;

    public SplitConstantPool() {
        this.size = 1;
        this.bsmSize = 0;
        this.myEntries = new PoolEntry[1024];
        this.myBsmEntries = new BootstrapMethodEntryImpl[8];
        this.parent = null;
        this.parentSize = 0;
        this.parentBsmSize = 0;
        this.doneFullScan = true;
    }

    public SplitConstantPool(ClassReader parent) {
        this.parent = (ClassReaderImpl)parent;
        this.parentSize = parent.size();
        this.parentBsmSize = parent.bootstrapMethodCount();
        this.size = this.parentSize;
        this.bsmSize = this.parentBsmSize;
        this.myEntries = new PoolEntry[8];
        this.myBsmEntries = new BootstrapMethodEntryImpl[8];
        this.doneFullScan = true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int bootstrapMethodCount() {
        return this.bsmSize;
    }

    @Override
    public PoolEntry entryByIndex(int index) {
        PoolEntry pe;
        if (index <= 0 || index >= this.size()) {
            throw SplitConstantPool.badCP(index);
        }
        PoolEntry poolEntry = pe = index < this.parentSize ? this.parent.entryByIndex(index) : this.myEntries[index - this.parentSize];
        if (pe == null) {
            throw SplitConstantPool.unusableCP(index);
        }
        return pe;
    }

    private static ConstantPoolException badCP(int index) {
        return new ConstantPoolException("Bad CP index: " + index);
    }

    private static ConstantPoolException unusableCP(int index) {
        return new ConstantPoolException("Unusable CP index: " + index);
    }

    @Override
    public <T extends PoolEntry> T entryByIndex(int index, Class<T> cls) {
        return ClassReaderImpl.checkType(this.entryByIndex(index), index, cls);
    }

    @Override
    public BootstrapMethodEntryImpl bootstrapMethodEntry(int index) {
        if (index < 0 || index >= this.bootstrapMethodCount()) {
            throw new ConstantPoolException("Bad BSM index: " + index);
        }
        return index < this.parentBsmSize ? this.parent.bootstrapMethodEntry(index) : this.myBsmEntries[index - this.parentBsmSize];
    }

    @Override
    public boolean canWriteDirect(ConstantPool other) {
        Objects.requireNonNull(other);
        return this == other || this.parent == other;
    }

    public boolean writeBootstrapMethods(final BufWriterImpl buf) {
        if (this.bsmSize == 0) {
            return false;
        }
        int pos = buf.size();
        Util.checkU2(this.bsmSize, "num bootstrap methods");
        if (this.parent != null && this.parentBsmSize != 0) {
            this.parent.writeBootstrapMethods(buf);
            for (int i = this.parentBsmSize; i < this.bsmSize; ++i) {
                this.bootstrapMethodEntry(i).writeTo(buf);
            }
            int attrLen = buf.size() - pos;
            buf.patchInt(pos + 2, attrLen - 6);
            buf.patchU2(pos + 6, this.bsmSize);
        } else {
            UnboundAttribute.AdHocAttribute<BootstrapMethodsAttribute> a = new UnboundAttribute.AdHocAttribute<BootstrapMethodsAttribute>(Attributes.bootstrapMethods()){

                @Override
                public void writeBody(BufWriterImpl b) {
                    buf.writeU2(SplitConstantPool.this.bsmSize);
                    for (int i = 0; i < SplitConstantPool.this.bsmSize; ++i) {
                        SplitConstantPool.this.bootstrapMethodEntry(i).writeTo(buf);
                    }
                }

                @Override
                public Utf8Entry attributeName() {
                    return SplitConstantPool.this.utf8Entry("BootstrapMethods");
                }
            };
            ((UnboundAttribute)a).writeTo(buf);
        }
        return true;
    }

    void writeTo(BufWriterImpl buf) {
        AbstractPoolEntry info;
        int writeFrom = 1;
        int mySize = this.size();
        Util.checkU2(mySize, "constant pool count");
        buf.writeU2(mySize);
        if (this.parent != null && buf.constantPool().canWriteDirect(this)) {
            this.parent.writeConstantPoolEntries(buf);
            writeFrom = this.parent.size();
        }
        for (int i = writeFrom; i < mySize; i += info.width()) {
            info = (AbstractPoolEntry)((Object)this.entryByIndex(i));
            info.writeTo(buf);
        }
    }

    private EntryMap map() {
        int parentSize = this.parentSize;
        EntryMap map = this.map;
        if (map == null) {
            PoolEntry cpi;
            this.map = map = new EntryMap(Math.max(this.size, 1024), 0.75f);
            int i = 1;
            while (i < parentSize) {
                cpi = this.parent.cp[i];
                if (cpi == null) {
                    this.doneFullScan = false;
                    ++i;
                    continue;
                }
                map.put(cpi.hashCode(), cpi.index());
                i += cpi.width();
            }
            for (i = Math.max(parentSize, 1); i < this.size; i += cpi.width()) {
                cpi = this.myEntries[i - parentSize];
                map.put(cpi.hashCode(), cpi.index());
            }
        }
        return map;
    }

    private void fullScan() {
        PoolEntry cpi;
        for (int i = 1; i < this.parentSize; i += cpi.width()) {
            cpi = this.parent.entryByIndex(i);
            this.map.put(cpi.hashCode(), cpi.index());
        }
        this.doneFullScan = true;
    }

    private EntryMap bsmMap() {
        int bsmSize = this.bsmSize;
        EntryMap bsmMap = this.bsmMap;
        if (bsmMap == null) {
            BootstrapMethodEntryImpl bsm;
            int i;
            this.bsmMap = bsmMap = new EntryMap(Math.max(bsmSize, 16), 0.75f);
            for (i = 0; i < this.parentBsmSize; ++i) {
                bsm = this.parent.bootstrapMethodEntry(i);
                bsmMap.put(bsm.hash, bsm.index);
            }
            for (i = this.parentBsmSize; i < bsmSize; ++i) {
                bsm = this.myBsmEntries[i - this.parentBsmSize];
                bsmMap.put(bsm.hash, bsm.index);
            }
        }
        return bsmMap;
    }

    private <E extends PoolEntry> E internalAdd(E cpi) {
        return this.internalAdd(cpi, cpi.hashCode());
    }

    private <E extends PoolEntry> E internalAdd(E cpi, int hash) {
        int newIndex = this.size - this.parentSize;
        if (newIndex + 2 > this.myEntries.length) {
            this.myEntries = (PoolEntry[])Arrays.copyOf(this.myEntries, 2 * newIndex, PoolEntry[].class);
        }
        this.myEntries[newIndex] = cpi;
        this.size += cpi.width();
        this.map().put(hash, cpi.index());
        return cpi;
    }

    private BootstrapMethodEntryImpl internalAdd(BootstrapMethodEntryImpl bsm, int hash) {
        int newIndex = this.bsmSize - this.parentBsmSize;
        if (newIndex + 2 > this.myBsmEntries.length) {
            this.myBsmEntries = (BootstrapMethodEntryImpl[])Arrays.copyOf(this.myBsmEntries, 2 * newIndex, BootstrapMethodEntryImpl[].class);
        }
        this.myBsmEntries[newIndex] = bsm;
        ++this.bsmSize;
        this.bsmMap().put(hash, bsm.index);
        return bsm;
    }

    private IntegerEntry findIntEntry(int val) {
        int hash = AbstractPoolEntry.hash1(3, Integer.hashCode(val));
        EntryMap map = this.map();
        int token = map.firstToken(hash);
        while (token != -1) {
            AbstractPoolEntry.IntegerEntryImpl ce;
            PoolEntry e = this.entryByIndex(map.getIndexByToken(token));
            if (e.tag() == 3 && e instanceof AbstractPoolEntry.IntegerEntryImpl && (ce = (AbstractPoolEntry.IntegerEntryImpl)e).intValue() == val) {
                return ce;
            }
            token = map.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.findIntEntry(val);
        }
        return null;
    }

    private LongEntry findLongEntry(long val) {
        int hash = AbstractPoolEntry.hash1(5, Long.hashCode(val));
        EntryMap map = this.map();
        int token = map.firstToken(hash);
        while (token != -1) {
            AbstractPoolEntry.LongEntryImpl ce;
            PoolEntry e = this.entryByIndex(map.getIndexByToken(token));
            if (e.tag() == 5 && e instanceof AbstractPoolEntry.LongEntryImpl && (ce = (AbstractPoolEntry.LongEntryImpl)e).longValue() == val) {
                return ce;
            }
            token = map.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.findLongEntry(val);
        }
        return null;
    }

    private FloatEntry findFloatEntry(float val) {
        int hash = AbstractPoolEntry.hash1(4, Float.hashCode(val));
        EntryMap map = this.map();
        int token = map.firstToken(hash);
        while (token != -1) {
            AbstractPoolEntry.FloatEntryImpl ce;
            PoolEntry e = this.entryByIndex(map.getIndexByToken(token));
            if (e.tag() == 4 && e instanceof AbstractPoolEntry.FloatEntryImpl && (ce = (AbstractPoolEntry.FloatEntryImpl)e).floatValue() == val) {
                return ce;
            }
            token = map.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.findFloatEntry(val);
        }
        return null;
    }

    private DoubleEntry findDoubleEntry(double val) {
        int hash = AbstractPoolEntry.hash1(6, Double.hashCode(val));
        EntryMap map = this.map();
        int token = map.firstToken(hash);
        while (token != -1) {
            AbstractPoolEntry.DoubleEntryImpl ce;
            PoolEntry e = this.entryByIndex(map.getIndexByToken(token));
            if (e.tag() == 6 && e instanceof AbstractPoolEntry.DoubleEntryImpl && (ce = (AbstractPoolEntry.DoubleEntryImpl)e).doubleValue() == val) {
                return ce;
            }
            token = map.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.findDoubleEntry(val);
        }
        return null;
    }

    private <T extends AbstractPoolEntry> AbstractPoolEntry findEntry(int tag, T ref1) {
        int hash = AbstractPoolEntry.hash1(tag, ref1.index());
        EntryMap map = this.map();
        int token = map.firstToken(hash);
        while (token != -1) {
            PoolEntry e = this.entryByIndex(map.getIndexByToken(token));
            if (e.tag() == tag && e instanceof AbstractPoolEntry.AbstractRefEntry) {
                AbstractPoolEntry.AbstractRefEntry re = (AbstractPoolEntry.AbstractRefEntry)((Object)e);
                if (re.ref1 == ref1) {
                    return re;
                }
            }
            token = map.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.findEntry(tag, ref1);
        }
        return null;
    }

    private <T extends AbstractPoolEntry, U extends AbstractPoolEntry> AbstractPoolEntry findEntry(int tag, T ref1, U ref2) {
        int hash = AbstractPoolEntry.hash2(tag, ref1.index(), ref2.index());
        EntryMap map = this.map();
        int token = map.firstToken(hash);
        while (token != -1) {
            PoolEntry e = this.entryByIndex(map.getIndexByToken(token));
            if (e.tag() == tag && e instanceof AbstractPoolEntry.AbstractRefsEntry) {
                AbstractPoolEntry.AbstractRefsEntry re = (AbstractPoolEntry.AbstractRefsEntry)((Object)e);
                if (re.ref1 == ref1 && re.ref2 == ref2) {
                    return re;
                }
            }
            token = map.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.findEntry(tag, ref1, ref2);
        }
        return null;
    }

    private AbstractPoolEntry.Utf8EntryImpl tryFindUtf8(int hash, String target) {
        EntryMap map = this.map();
        int token = map.firstToken(hash);
        while (token != -1) {
            AbstractPoolEntry.Utf8EntryImpl ce;
            PoolEntry e = this.entryByIndex(map.getIndexByToken(token));
            if (e.tag() == 1 && e instanceof AbstractPoolEntry.Utf8EntryImpl && target.equals((ce = (AbstractPoolEntry.Utf8EntryImpl)e).stringValue())) {
                return ce;
            }
            token = map.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.tryFindUtf8(hash, target);
        }
        return null;
    }

    private AbstractPoolEntry.Utf8EntryImpl tryFindUtf8(int hash, AbstractPoolEntry.Utf8EntryImpl target) {
        EntryMap map = this.map();
        int token = map.firstToken(hash);
        while (token != -1) {
            AbstractPoolEntry.Utf8EntryImpl ce;
            PoolEntry e = this.entryByIndex(map.getIndexByToken(token));
            if (e.tag() == 1 && e instanceof AbstractPoolEntry.Utf8EntryImpl && target.equalsUtf8(ce = (AbstractPoolEntry.Utf8EntryImpl)e)) {
                return ce;
            }
            token = map.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.tryFindUtf8(hash, target);
        }
        return null;
    }

    private AbstractPoolEntry.ClassEntryImpl tryFindClassOrInterface(int hash, ClassDesc cd) {
        while (true) {
            EntryMap map = this.map();
            int token = map.firstToken(hash);
            while (token != -1) {
                PoolEntry e = this.entryByIndex(map.getIndexByToken(token));
                if (e.tag() == 7 && e instanceof AbstractPoolEntry.ClassEntryImpl) {
                    AbstractPoolEntry.ClassEntryImpl ce = (AbstractPoolEntry.ClassEntryImpl)e;
                    ClassDesc esym = ce.sym;
                    if (esym != null) {
                        if (cd.equals(esym)) {
                            return ce;
                        }
                    } else if (((AbstractPoolEntry.Utf8EntryImpl)ce.ref1).equalsString(Util.toInternalName(cd))) {
                        ce.sym = cd;
                        return ce;
                    }
                }
                token = map.nextToken(hash, token);
            }
            if (this.doneFullScan) break;
            this.fullScan();
        }
        return null;
    }

    private AbstractPoolEntry.ClassEntryImpl classEntryForClassOrInterface(ClassDesc cd) {
        String desc = cd.descriptorString();
        int hash = AbstractPoolEntry.hashClassFromDescriptor(desc.hashCode());
        AbstractPoolEntry.ClassEntryImpl ce = this.tryFindClassOrInterface(hash, cd);
        if (ce != null) {
            return ce;
        }
        String internalName = Util.toInternalName(cd);
        int utfHash = internalName.hashCode();
        AbstractPoolEntry.Utf8EntryImpl utf = this.tryFindUtf8(AbstractPoolEntry.hashString(utfHash), internalName);
        if (utf == null) {
            utf = this.internalAdd(new AbstractPoolEntry.Utf8EntryImpl(this, this.size, internalName, utfHash));
        }
        return this.internalAdd(new AbstractPoolEntry.ClassEntryImpl(this, this.size, utf, hash, cd));
    }

    private AbstractPoolEntry.ClassEntryImpl tryFindClassEntry(int hash, AbstractPoolEntry.Utf8EntryImpl utf8) {
        EntryMap map = this.map();
        int token = map.firstToken(hash);
        while (token != -1) {
            PoolEntry e = this.entryByIndex(map.getIndexByToken(token));
            if (e.tag() == 7 && e instanceof AbstractPoolEntry.ClassEntryImpl) {
                AbstractPoolEntry.ClassEntryImpl ce = (AbstractPoolEntry.ClassEntryImpl)e;
                if (((AbstractPoolEntry.Utf8EntryImpl)ce.ref1).equalsUtf8(utf8)) {
                    return ce;
                }
            }
            token = map.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.tryFindClassEntry(hash, utf8);
        }
        return null;
    }

    @Override
    public AbstractPoolEntry.Utf8EntryImpl utf8Entry(ClassDesc desc) {
        AbstractPoolEntry.Utf8EntryImpl utf8 = this.utf8Entry(desc.descriptorString());
        if (utf8.typeSym == null) {
            utf8.typeSym = desc;
        }
        return utf8;
    }

    @Override
    public Utf8Entry utf8Entry(MethodTypeDesc desc) {
        AbstractPoolEntry.Utf8EntryImpl utf8 = this.utf8Entry(desc.descriptorString());
        if (utf8.typeSym == null) {
            utf8.typeSym = desc;
        }
        return utf8;
    }

    @Override
    public AbstractPoolEntry.Utf8EntryImpl utf8Entry(String s) {
        int contentHash = s.hashCode();
        AbstractPoolEntry.Utf8EntryImpl ce = this.tryFindUtf8(AbstractPoolEntry.hashString(contentHash), s);
        return ce == null ? this.internalAdd(new AbstractPoolEntry.Utf8EntryImpl(this, this.size, s, contentHash)) : ce;
    }

    AbstractPoolEntry.Utf8EntryImpl maybeCloneUtf8Entry(Utf8Entry entry) {
        AbstractPoolEntry.Utf8EntryImpl e = (AbstractPoolEntry.Utf8EntryImpl)entry;
        if (e.constantPool == this || e.constantPool == this.parent) {
            return e;
        }
        AbstractPoolEntry.Utf8EntryImpl ce = this.tryFindUtf8(e.hashCode(), e);
        return ce == null ? this.internalAdd(new AbstractPoolEntry.Utf8EntryImpl((ConstantPool)this, this.size, e)) : ce;
    }

    @Override
    public AbstractPoolEntry.ClassEntryImpl classEntry(Utf8Entry nameEntry) {
        AbstractPoolEntry.Utf8EntryImpl ne = this.maybeCloneUtf8Entry(nameEntry);
        return this.classEntry(ne, ne.mayBeArrayDescriptor());
    }

    AbstractPoolEntry.ClassEntryImpl classEntry(AbstractPoolEntry.Utf8EntryImpl ne, boolean isArray) {
        ClassDesc cd;
        TypeDescriptor typeDescriptor;
        int hash = AbstractPoolEntry.hashClassFromUtf8(isArray, ne);
        AbstractPoolEntry.ClassEntryImpl e = this.tryFindClassEntry(hash, ne);
        return e == null ? this.internalAdd(new AbstractPoolEntry.ClassEntryImpl(this, this.size, ne, hash, isArray && (typeDescriptor = ne.typeSym) instanceof ClassDesc ? (cd = (ClassDesc)typeDescriptor) : null)) : e;
    }

    @Override
    public ClassEntry classEntry(ClassDesc cd) {
        if (cd.isClassOrInterface()) {
            return this.classEntryForClassOrInterface(cd);
        }
        if (cd.isArray()) {
            return this.classEntry(this.utf8Entry(cd), true);
        }
        throw new IllegalArgumentException("Cannot be encoded as ClassEntry: " + cd.displayName());
    }

    AbstractPoolEntry.ClassEntryImpl cloneClassEntry(AbstractPoolEntry.ClassEntryImpl e) {
        AbstractPoolEntry.ClassEntryImpl ce = this.tryFindClassEntry(e.hashCode(), (AbstractPoolEntry.Utf8EntryImpl)e.ref1);
        if (ce != null) {
            ClassDesc mySym = e.sym;
            if (ce.sym == null && mySym != null) {
                ce.sym = mySym;
            }
            return ce;
        }
        AbstractPoolEntry.Utf8EntryImpl utf8 = this.maybeCloneUtf8Entry((Utf8Entry)e.ref1);
        return this.internalAdd(new AbstractPoolEntry.ClassEntryImpl(this, this.size, utf8, e.hashCode(), e.sym));
    }

    @Override
    public PackageEntry packageEntry(Utf8Entry nameEntry) {
        AbstractPoolEntry.Utf8EntryImpl ne = this.maybeCloneUtf8Entry(nameEntry);
        AbstractPoolEntry.PackageEntryImpl e = (AbstractPoolEntry.PackageEntryImpl)this.findEntry(20, ne);
        return e == null ? (PackageEntry)this.internalAdd(new AbstractPoolEntry.PackageEntryImpl((ConstantPool)this, this.size, ne)) : e;
    }

    @Override
    public ModuleEntry moduleEntry(Utf8Entry nameEntry) {
        AbstractPoolEntry.Utf8EntryImpl ne = this.maybeCloneUtf8Entry(nameEntry);
        AbstractPoolEntry.ModuleEntryImpl e = (AbstractPoolEntry.ModuleEntryImpl)this.findEntry(19, ne);
        return e == null ? (ModuleEntry)this.internalAdd(new AbstractPoolEntry.ModuleEntryImpl((ConstantPool)this, this.size, ne)) : e;
    }

    @Override
    public AbstractPoolEntry.NameAndTypeEntryImpl nameAndTypeEntry(Utf8Entry nameEntry, Utf8Entry typeEntry) {
        AbstractPoolEntry.Utf8EntryImpl te;
        AbstractPoolEntry.Utf8EntryImpl ne = this.maybeCloneUtf8Entry(nameEntry);
        AbstractPoolEntry.NameAndTypeEntryImpl e = (AbstractPoolEntry.NameAndTypeEntryImpl)this.findEntry(12, ne, te = this.maybeCloneUtf8Entry(typeEntry));
        return e == null ? this.internalAdd(new AbstractPoolEntry.NameAndTypeEntryImpl(this, this.size, ne, te)) : e;
    }

    @Override
    public FieldRefEntry fieldRefEntry(ClassEntry owner, NameAndTypeEntry nameAndType) {
        AbstractPoolEntry.NameAndTypeEntryImpl ne;
        AbstractPoolEntry.ClassEntryImpl oe = AbstractPoolEntry.maybeClone(this, (AbstractPoolEntry.ClassEntryImpl)owner);
        AbstractPoolEntry.FieldRefEntryImpl e = (AbstractPoolEntry.FieldRefEntryImpl)this.findEntry(9, oe, ne = AbstractPoolEntry.maybeClone(this, (AbstractPoolEntry.NameAndTypeEntryImpl)nameAndType));
        return e == null ? (FieldRefEntry)this.internalAdd(new AbstractPoolEntry.FieldRefEntryImpl(this, this.size, oe, ne)) : e;
    }

    @Override
    public MethodRefEntry methodRefEntry(ClassEntry owner, NameAndTypeEntry nameAndType) {
        AbstractPoolEntry.NameAndTypeEntryImpl ne;
        AbstractPoolEntry.ClassEntryImpl oe = AbstractPoolEntry.maybeClone(this, (AbstractPoolEntry.ClassEntryImpl)owner);
        AbstractPoolEntry.MethodRefEntryImpl e = (AbstractPoolEntry.MethodRefEntryImpl)this.findEntry(10, oe, ne = AbstractPoolEntry.maybeClone(this, (AbstractPoolEntry.NameAndTypeEntryImpl)nameAndType));
        return e == null ? (MethodRefEntry)this.internalAdd(new AbstractPoolEntry.MethodRefEntryImpl(this, this.size, oe, ne)) : e;
    }

    @Override
    public InterfaceMethodRefEntry interfaceMethodRefEntry(ClassEntry owner, NameAndTypeEntry nameAndType) {
        AbstractPoolEntry.NameAndTypeEntryImpl ne;
        AbstractPoolEntry.ClassEntryImpl oe = AbstractPoolEntry.maybeClone(this, (AbstractPoolEntry.ClassEntryImpl)owner);
        AbstractPoolEntry.InterfaceMethodRefEntryImpl e = (AbstractPoolEntry.InterfaceMethodRefEntryImpl)this.findEntry(11, oe, ne = AbstractPoolEntry.maybeClone(this, (AbstractPoolEntry.NameAndTypeEntryImpl)nameAndType));
        return e == null ? (InterfaceMethodRefEntry)this.internalAdd(new AbstractPoolEntry.InterfaceMethodRefEntryImpl(this, this.size, oe, ne)) : e;
    }

    @Override
    public MethodTypeEntry methodTypeEntry(MethodTypeDesc descriptor) {
        return this.methodTypeEntry(this.utf8Entry(descriptor));
    }

    @Override
    public MethodTypeEntry methodTypeEntry(Utf8Entry descriptor) {
        AbstractPoolEntry.Utf8EntryImpl de = this.maybeCloneUtf8Entry(descriptor);
        AbstractPoolEntry.MethodTypeEntryImpl e = (AbstractPoolEntry.MethodTypeEntryImpl)this.findEntry(16, de);
        return e == null ? (MethodTypeEntry)this.internalAdd(new AbstractPoolEntry.MethodTypeEntryImpl((ConstantPool)this, this.size, de)) : e;
    }

    @Override
    public MethodHandleEntry methodHandleEntry(int refKind, MemberRefEntry reference) {
        Util.checkU1(refKind, "reference kind");
        reference = AbstractPoolEntry.maybeClone(this, reference);
        int hash = AbstractPoolEntry.hash2(15, refKind, reference.index());
        EntryMap map1 = this.map();
        int token = map1.firstToken(hash);
        while (token != -1) {
            AbstractPoolEntry.MethodHandleEntryImpl ce;
            PoolEntry e = this.entryByIndex(map1.getIndexByToken(token));
            if (e.tag() == 15 && e instanceof AbstractPoolEntry.MethodHandleEntryImpl && (ce = (AbstractPoolEntry.MethodHandleEntryImpl)e).kind() == refKind && ce.reference() == reference) {
                return ce;
            }
            token = map1.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.methodHandleEntry(refKind, reference);
        }
        return this.internalAdd(new AbstractPoolEntry.MethodHandleEntryImpl(this, this.size, hash, refKind, (AbstractPoolEntry.AbstractMemberRefEntry)reference), hash);
    }

    @Override
    public InvokeDynamicEntry invokeDynamicEntry(BootstrapMethodEntry bootstrapMethodEntry, NameAndTypeEntry nameAndType) {
        if (!this.canWriteDirect(bootstrapMethodEntry.constantPool())) {
            bootstrapMethodEntry = this.bsmEntry(bootstrapMethodEntry.bootstrapMethod(), bootstrapMethodEntry.arguments());
        }
        nameAndType = AbstractPoolEntry.maybeClone(this, nameAndType);
        int hash = AbstractPoolEntry.hash2(18, bootstrapMethodEntry.bsmIndex(), nameAndType.index());
        EntryMap map1 = this.map();
        int token = map1.firstToken(hash);
        while (token != -1) {
            AbstractPoolEntry.InvokeDynamicEntryImpl ce;
            PoolEntry e = this.entryByIndex(map1.getIndexByToken(token));
            if (e.tag() == 18 && e instanceof AbstractPoolEntry.InvokeDynamicEntryImpl && (ce = (AbstractPoolEntry.InvokeDynamicEntryImpl)e).bootstrap() == bootstrapMethodEntry && ce.nameAndType() == nameAndType) {
                return ce;
            }
            token = map1.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.invokeDynamicEntry(bootstrapMethodEntry, nameAndType);
        }
        AbstractPoolEntry.InvokeDynamicEntryImpl ce = new AbstractPoolEntry.InvokeDynamicEntryImpl((ConstantPool)this, this.size, hash, (BootstrapMethodEntryImpl)bootstrapMethodEntry, (AbstractPoolEntry.NameAndTypeEntryImpl)nameAndType);
        this.internalAdd(ce, hash);
        return ce;
    }

    @Override
    public ConstantDynamicEntry constantDynamicEntry(BootstrapMethodEntry bootstrapMethodEntry, NameAndTypeEntry nameAndType) {
        if (!this.canWriteDirect(bootstrapMethodEntry.constantPool())) {
            bootstrapMethodEntry = this.bsmEntry(bootstrapMethodEntry.bootstrapMethod(), bootstrapMethodEntry.arguments());
        }
        nameAndType = AbstractPoolEntry.maybeClone(this, nameAndType);
        int hash = AbstractPoolEntry.hash2(17, bootstrapMethodEntry.bsmIndex(), nameAndType.index());
        EntryMap map1 = this.map();
        int token = map1.firstToken(hash);
        while (token != -1) {
            AbstractPoolEntry.ConstantDynamicEntryImpl ce;
            PoolEntry e = this.entryByIndex(map1.getIndexByToken(token));
            if (e.tag() == 17 && e instanceof AbstractPoolEntry.ConstantDynamicEntryImpl && (ce = (AbstractPoolEntry.ConstantDynamicEntryImpl)e).bootstrap() == bootstrapMethodEntry && ce.nameAndType() == nameAndType) {
                return ce;
            }
            token = map1.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.constantDynamicEntry(bootstrapMethodEntry, nameAndType);
        }
        AbstractPoolEntry.ConstantDynamicEntryImpl ce = new AbstractPoolEntry.ConstantDynamicEntryImpl((ConstantPool)this, this.size, hash, (BootstrapMethodEntryImpl)bootstrapMethodEntry, (AbstractPoolEntry.NameAndTypeEntryImpl)nameAndType);
        this.internalAdd(ce, hash);
        return ce;
    }

    @Override
    public IntegerEntry intEntry(int value) {
        IntegerEntry e = this.findIntEntry(value);
        return e == null ? (IntegerEntry)this.internalAdd(new AbstractPoolEntry.IntegerEntryImpl(this, this.size, value)) : e;
    }

    @Override
    public FloatEntry floatEntry(float value) {
        FloatEntry e = this.findFloatEntry(value);
        return e == null ? (FloatEntry)this.internalAdd(new AbstractPoolEntry.FloatEntryImpl((ConstantPool)this, this.size, value)) : e;
    }

    @Override
    public LongEntry longEntry(long value) {
        LongEntry e = this.findLongEntry(value);
        return e == null ? (LongEntry)this.internalAdd(new AbstractPoolEntry.LongEntryImpl((ConstantPool)this, this.size, value)) : e;
    }

    @Override
    public DoubleEntry doubleEntry(double value) {
        DoubleEntry e = this.findDoubleEntry(value);
        return e == null ? (DoubleEntry)this.internalAdd(new AbstractPoolEntry.DoubleEntryImpl((ConstantPool)this, this.size, value)) : e;
    }

    @Override
    public StringEntry stringEntry(Utf8Entry utf8) {
        AbstractPoolEntry.Utf8EntryImpl ue = this.maybeCloneUtf8Entry(utf8);
        AbstractPoolEntry.StringEntryImpl e = (AbstractPoolEntry.StringEntryImpl)this.findEntry(8, ue);
        return e == null ? (StringEntry)this.internalAdd(new AbstractPoolEntry.StringEntryImpl((ConstantPool)this, this.size, ue)) : e;
    }

    @Override
    public BootstrapMethodEntry bsmEntry(MethodHandleEntry methodReference, List<LoadableConstantEntry> arguments) {
        methodReference = AbstractPoolEntry.maybeClone(this, methodReference);
        for (LoadableConstantEntry a : arguments) {
            if (this.canWriteDirect(a.constantPool())) continue;
            LoadableConstantEntry[] arr = arguments.toArray(new LoadableConstantEntry[0]);
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = AbstractPoolEntry.maybeClone(this, arr[i]);
            }
            arguments = List.of(arr);
            break;
        }
        AbstractPoolEntry.MethodHandleEntryImpl mre = (AbstractPoolEntry.MethodHandleEntryImpl)methodReference;
        int hash = BootstrapMethodEntryImpl.computeHashCode(mre, arguments);
        EntryMap map = this.bsmMap();
        int token = map.firstToken(hash);
        while (token != -1) {
            BootstrapMethodEntryImpl e = this.bootstrapMethodEntry(map.getIndexByToken(token));
            if (e.bootstrapMethod() == mre && e.arguments().equals(arguments)) {
                return e;
            }
            token = map.nextToken(hash, token);
        }
        BootstrapMethodEntryImpl ne = new BootstrapMethodEntryImpl(this, this.bsmSize, hash, mre, arguments);
        return this.internalAdd(ne, hash);
    }
}

