/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.AccessFlags;
import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.Attributes;
import io.smallrye.classfile.ClassModel;
import io.smallrye.classfile.ClassReader;
import io.smallrye.classfile.CodeModel;
import io.smallrye.classfile.MethodElement;
import io.smallrye.classfile.MethodModel;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.extras.reflect.AccessFlag;
import io.smallrye.classfile.impl.AbstractElement;
import io.smallrye.classfile.impl.AccessFlagsImpl;
import io.smallrye.classfile.impl.BoundAttribute;
import io.smallrye.classfile.impl.BufWriterImpl;
import io.smallrye.classfile.impl.ClassReaderImpl;
import io.smallrye.classfile.impl.DirectClassBuilder;
import io.smallrye.classfile.impl.MethodInfo;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.MethodTypeDesc;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public final class MethodImpl
extends AbstractElement
implements MethodModel,
MethodInfo,
Util.Writable {
    private final ClassReader reader;
    private final int startPos;
    private final int endPos;
    private final int attributesPos;
    private List<Attribute<?>> attributes;
    private int[] parameterSlots;

    public MethodImpl(ClassReader reader, int startPos, int endPos, int attrStart) {
        this.reader = reader;
        this.startPos = startPos;
        this.endPos = endPos;
        this.attributesPos = attrStart;
    }

    @Override
    public AccessFlags flags() {
        return new AccessFlagsImpl(AccessFlag.Location.METHOD, this.reader.readU2(this.startPos));
    }

    @Override
    public Optional<ClassModel> parent() {
        ClassReader classReader = this.reader;
        if (classReader instanceof ClassReaderImpl) {
            ClassReaderImpl cri = (ClassReaderImpl)classReader;
            return Optional.of(cri.getContainedClass());
        }
        return Optional.empty();
    }

    @Override
    public Utf8Entry methodName() {
        return this.reader.readEntry(this.startPos + 2, Utf8Entry.class);
    }

    @Override
    public Utf8Entry methodType() {
        return this.reader.readEntry(this.startPos + 4, Utf8Entry.class);
    }

    @Override
    public MethodTypeDesc methodTypeSymbol() {
        return Util.methodTypeSymbol(this.methodType());
    }

    @Override
    public int methodFlags() {
        return this.reader.readU2(this.startPos);
    }

    @Override
    public int parameterSlot(int paramNo) {
        if (this.parameterSlots == null) {
            this.parameterSlots = Util.parseParameterSlots(this.methodFlags(), this.methodTypeSymbol());
        }
        return this.parameterSlots[paramNo];
    }

    @Override
    public List<Attribute<?>> attributes() {
        if (this.attributes == null) {
            this.attributes = BoundAttribute.readAttributes(this, this.reader, this.attributesPos, this.reader.customAttributes());
        }
        return this.attributes;
    }

    @Override
    public void writeTo(BufWriterImpl buf) {
        if (buf.canWriteDirect(this.reader)) {
            this.reader.copyBytesTo(buf, this.startPos, this.endPos - this.startPos);
        } else {
            buf.writeU2U2U2(this.flags().flagsMask(), buf.cpIndex(this.methodName()), buf.cpIndex(this.methodType()));
            Util.writeAttributes(buf, this.attributes());
        }
    }

    @Override
    public Optional<CodeModel> code() {
        return this.findAttribute(Attributes.code()).map(a -> a);
    }

    @Override
    public void forEach(Consumer<? super MethodElement> consumer) {
        consumer.accept(this.flags());
        for (Attribute<?> attr : this.attributes()) {
            if (!(attr instanceof MethodElement)) continue;
            MethodElement e = (MethodElement)((Object)attr);
            consumer.accept(e);
        }
    }

    @Override
    public void writeTo(DirectClassBuilder builder) {
        if (builder.canWriteDirect(this.reader)) {
            builder.withMethod(this);
        } else {
            builder.withMethod(this.methodName(), this.methodType(), this.methodFlags(), Util.writingAll(this));
        }
    }

    public String toString() {
        return String.format("MethodModel[methodName=%s, methodType=%s, flags=%d]", this.methodName().stringValue(), this.methodType().stringValue(), this.flags().flagsMask());
    }
}

