/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.FieldBuilder;
import io.smallrye.classfile.FieldElement;
import io.smallrye.classfile.constantpool.ConstantPoolBuilder;
import io.smallrye.classfile.impl.TerminalFieldBuilder;
import java.util.Objects;
import java.util.function.Consumer;

public final class ChainedFieldBuilder
implements FieldBuilder {
    private final TerminalFieldBuilder terminal;
    private final Consumer<FieldElement> consumer;

    public ChainedFieldBuilder(FieldBuilder downstream, Consumer<FieldElement> consumer) {
        TerminalFieldBuilder terminalFieldBuilder;
        this.consumer = consumer;
        if (downstream instanceof ChainedFieldBuilder) {
            ChainedFieldBuilder cfb = (ChainedFieldBuilder)downstream;
            terminalFieldBuilder = cfb.terminal;
        } else {
            terminalFieldBuilder = (TerminalFieldBuilder)downstream;
        }
        this.terminal = terminalFieldBuilder;
    }

    @Override
    public ConstantPoolBuilder constantPool() {
        return this.terminal.constantPool();
    }

    @Override
    public FieldBuilder with(FieldElement element) {
        this.consumer.accept(Objects.requireNonNull(element));
        return this;
    }
}

