/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.Annotation;
import io.smallrye.classfile.AnnotationValue;
import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.AttributeMapper;
import io.smallrye.classfile.AttributedElement;
import io.smallrye.classfile.Attributes;
import io.smallrye.classfile.BootstrapMethodEntry;
import io.smallrye.classfile.BufWriter;
import io.smallrye.classfile.ClassReader;
import io.smallrye.classfile.MethodModel;
import io.smallrye.classfile.TypeAnnotation;
import io.smallrye.classfile.attribute.AnnotationDefaultAttribute;
import io.smallrye.classfile.attribute.BootstrapMethodsAttribute;
import io.smallrye.classfile.attribute.CharacterRangeInfo;
import io.smallrye.classfile.attribute.CharacterRangeTableAttribute;
import io.smallrye.classfile.attribute.CodeAttribute;
import io.smallrye.classfile.attribute.CompilationIDAttribute;
import io.smallrye.classfile.attribute.ConstantValueAttribute;
import io.smallrye.classfile.attribute.DeprecatedAttribute;
import io.smallrye.classfile.attribute.EnclosingMethodAttribute;
import io.smallrye.classfile.attribute.ExceptionsAttribute;
import io.smallrye.classfile.attribute.InnerClassInfo;
import io.smallrye.classfile.attribute.InnerClassesAttribute;
import io.smallrye.classfile.attribute.LineNumberInfo;
import io.smallrye.classfile.attribute.LineNumberTableAttribute;
import io.smallrye.classfile.attribute.LocalVariableInfo;
import io.smallrye.classfile.attribute.LocalVariableTableAttribute;
import io.smallrye.classfile.attribute.LocalVariableTypeInfo;
import io.smallrye.classfile.attribute.LocalVariableTypeTableAttribute;
import io.smallrye.classfile.attribute.MethodParameterInfo;
import io.smallrye.classfile.attribute.MethodParametersAttribute;
import io.smallrye.classfile.attribute.ModuleAttribute;
import io.smallrye.classfile.attribute.ModuleExportInfo;
import io.smallrye.classfile.attribute.ModuleHashInfo;
import io.smallrye.classfile.attribute.ModuleHashesAttribute;
import io.smallrye.classfile.attribute.ModuleMainClassAttribute;
import io.smallrye.classfile.attribute.ModuleOpenInfo;
import io.smallrye.classfile.attribute.ModulePackagesAttribute;
import io.smallrye.classfile.attribute.ModuleProvideInfo;
import io.smallrye.classfile.attribute.ModuleRequireInfo;
import io.smallrye.classfile.attribute.ModuleResolutionAttribute;
import io.smallrye.classfile.attribute.ModuleTargetAttribute;
import io.smallrye.classfile.attribute.NestHostAttribute;
import io.smallrye.classfile.attribute.NestMembersAttribute;
import io.smallrye.classfile.attribute.PermittedSubclassesAttribute;
import io.smallrye.classfile.attribute.RecordAttribute;
import io.smallrye.classfile.attribute.RecordComponentInfo;
import io.smallrye.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import io.smallrye.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import io.smallrye.classfile.attribute.SignatureAttribute;
import io.smallrye.classfile.attribute.SourceDebugExtensionAttribute;
import io.smallrye.classfile.attribute.SourceFileAttribute;
import io.smallrye.classfile.attribute.SourceIDAttribute;
import io.smallrye.classfile.attribute.StackMapFrameInfo;
import io.smallrye.classfile.attribute.StackMapTableAttribute;
import io.smallrye.classfile.attribute.SyntheticAttribute;
import io.smallrye.classfile.attribute.UnknownAttribute;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.constantpool.ConstantPool;
import io.smallrye.classfile.constantpool.ConstantValueEntry;
import io.smallrye.classfile.constantpool.LoadableConstantEntry;
import io.smallrye.classfile.constantpool.ModuleEntry;
import io.smallrye.classfile.constantpool.NameAndTypeEntry;
import io.smallrye.classfile.constantpool.PackageEntry;
import io.smallrye.classfile.constantpool.PoolEntry;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.AbstractElement;
import io.smallrye.classfile.impl.AbstractPoolEntry;
import io.smallrye.classfile.impl.AnnotationReader;
import io.smallrye.classfile.impl.BootstrapMethodEntryImpl;
import io.smallrye.classfile.impl.BoundLocalVariable;
import io.smallrye.classfile.impl.BoundLocalVariableType;
import io.smallrye.classfile.impl.BoundRecordComponentInfo;
import io.smallrye.classfile.impl.BufWriterImpl;
import io.smallrye.classfile.impl.ClassReaderImpl;
import io.smallrye.classfile.impl.CodeImpl;
import io.smallrye.classfile.impl.DirectClassBuilder;
import io.smallrye.classfile.impl.DirectCodeBuilder;
import io.smallrye.classfile.impl.DirectFieldBuilder;
import io.smallrye.classfile.impl.DirectMethodBuilder;
import io.smallrye.classfile.impl.LabelContext;
import io.smallrye.classfile.impl.StackMapDecoder;
import io.smallrye.classfile.impl.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class BoundAttribute<T extends Attribute<T>>
extends AbstractElement
implements Attribute<T>,
Util.Writable {
    static final int NAME_AND_LENGTH_PREFIX = 6;
    private final AttributeMapper<T> mapper;
    final ClassReaderImpl classReader;
    final int payloadStart;
    Utf8Entry name;

    BoundAttribute(ClassReader classReader, AttributeMapper<T> mapper, int payloadStart) {
        this.mapper = mapper;
        this.classReader = (ClassReaderImpl)classReader;
        this.payloadStart = payloadStart;
    }

    public int payloadLen() {
        return this.classReader.readInt(this.payloadStart - 4);
    }

    @Override
    public Utf8Entry attributeName() {
        if (this.name == null) {
            this.name = this.classReader.readEntry(this.payloadStart - 6, Utf8Entry.class);
        }
        return this.name;
    }

    @Override
    public AttributeMapper<T> attributeMapper() {
        return this.mapper;
    }

    public byte[] contents() {
        return this.classReader.readBytes(this.payloadStart, this.payloadLen());
    }

    @Override
    public void writeTo(DirectClassBuilder builder) {
        builder.writeAttribute(this);
    }

    @Override
    public void writeTo(DirectCodeBuilder builder) {
        builder.writeAttribute(this);
    }

    @Override
    public void writeTo(DirectMethodBuilder builder) {
        builder.writeAttribute(this);
    }

    @Override
    public void writeTo(DirectFieldBuilder builder) {
        builder.writeAttribute(this);
    }

    @Override
    public void writeTo(BufWriterImpl buf) {
        if (!buf.canWriteDirect(this.classReader)) {
            this.attributeMapper().writeAttribute(buf, this);
        } else {
            this.classReader.copyBytesTo(buf, this.payloadStart - 6, this.payloadLen() + 6);
        }
    }

    public ConstantPool constantPool() {
        return this.classReader;
    }

    public String toString() {
        return String.format("Attribute[name=%s]", this.mapper.name());
    }

    <E extends PoolEntry> List<E> readEntryList(int p, Class<E> type) {
        int cnt = this.classReader.readU2(p);
        PoolEntry[] entries = new PoolEntry[cnt];
        int end = (p += 2) + cnt * 2;
        int i = 0;
        while (p < end) {
            entries[i] = this.classReader.readEntry(p, type);
            ++i;
            p += 2;
        }
        return List.of(entries);
    }

    public static List<Attribute<?>> readAttributes(AttributedElement enclosing, ClassReader reader, int pos, Function<Utf8Entry, AttributeMapper<?>> customAttributes) {
        int size = reader.readU2(pos);
        ArrayList<Attribute> filled = new ArrayList<Attribute>(size);
        int p = pos + 2;
        int cfLen = reader.classfileLength();
        for (int i = 0; i < size; ++i) {
            final Utf8Entry name = reader.readEntry(p, Utf8Entry.class);
            int len = reader.readInt(p + 2);
            if (len < 0 || len > cfLen - (p += 6)) {
                throw new IllegalArgumentException("attribute " + name.stringValue() + " too big to handle");
            }
            AttributeMapper<?> mapper = BoundAttribute.standardAttribute(name);
            if (mapper == null) {
                mapper = customAttributes.apply(name);
            }
            if (mapper != null) {
                filled.add((Attribute)Objects.requireNonNull(mapper.readAttribute(enclosing, reader, p)));
            } else {
                AttributeMapper<UnknownAttribute> fakeMapper = new AttributeMapper<UnknownAttribute>(){

                    @Override
                    public String name() {
                        return name.stringValue();
                    }

                    @Override
                    public UnknownAttribute readAttribute(AttributedElement enclosing, ClassReader cf, int pos) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void writeAttribute(BufWriter buf, UnknownAttribute attr) {
                        buf.writeIndex(name);
                        byte[] cont = attr.contents();
                        buf.writeInt(cont.length);
                        buf.writeBytes(cont);
                    }

                    @Override
                    public boolean allowMultiple() {
                        return true;
                    }

                    @Override
                    public AttributeMapper.AttributeStability stability() {
                        return AttributeMapper.AttributeStability.UNKNOWN;
                    }
                };
                filled.add(new BoundUnknownAttribute(reader, fakeMapper, p));
            }
            p += len;
        }
        return Collections.unmodifiableList(filled);
    }

    public static AttributeMapper<?> standardAttribute(Utf8Entry name) {
        return switch (name.hashCode()) {
            case 1181327346 -> {
                if (name.equalsString("AnnotationDefault")) {
                    yield Attributes.annotationDefault();
                }
                yield null;
            }
            case 1376313732 -> {
                if (name.equalsString("BootstrapMethods")) {
                    yield Attributes.bootstrapMethods();
                }
                yield null;
            }
            case -882864006 -> {
                if (name.equalsString("CharacterRangeTable")) {
                    yield Attributes.characterRangeTable();
                }
                yield null;
            }
            case 1075847693 -> {
                if (name.equalsString("Code")) {
                    yield Attributes.code();
                }
                yield null;
            }
            case -1039281666 -> {
                if (name.equalsString("CompilationID")) {
                    yield Attributes.compilationId();
                }
                yield null;
            }
            case -894331891 -> {
                if (name.equalsString("ConstantValue")) {
                    yield Attributes.constantValue();
                }
                yield null;
            }
            case 1434862035 -> {
                if (name.equalsString("Deprecated")) {
                    yield Attributes.deprecated();
                }
                yield null;
            }
            case 1372865485 -> {
                if (name.equalsString("EnclosingMethod")) {
                    yield Attributes.enclosingMethod();
                }
                yield null;
            }
            case 1752962596 -> {
                if (name.equalsString("Exceptions")) {
                    yield Attributes.exceptions();
                }
                yield null;
            }
            case 2061183248 -> {
                if (name.equalsString("InnerClasses")) {
                    yield Attributes.innerClasses();
                }
                yield null;
            }
            case 1698628945 -> {
                if (name.equalsString("LineNumberTable")) {
                    yield Attributes.lineNumberTable();
                }
                yield null;
            }
            case 1690786087 -> {
                if (name.equalsString("LocalVariableTable")) {
                    yield Attributes.localVariableTable();
                }
                yield null;
            }
            case 1721235853 -> {
                if (name.equalsString("LocalVariableTypeTable")) {
                    yield Attributes.localVariableTypeTable();
                }
                yield null;
            }
            case -609169973 -> {
                if (name.equalsString("MethodParameters")) {
                    yield Attributes.methodParameters();
                }
                yield null;
            }
            case -911175028 -> {
                if (name.equalsString("Module")) {
                    yield Attributes.module();
                }
                yield null;
            }
            case 1103964136 -> {
                if (name.equalsString("ModuleHashes")) {
                    yield Attributes.moduleHashes();
                }
                yield null;
            }
            case 2112555539 -> {
                if (name.equalsString("ModuleMainClass")) {
                    yield Attributes.moduleMainClass();
                }
                yield null;
            }
            case 1728511897 -> {
                if (name.equalsString("ModulePackages")) {
                    yield Attributes.modulePackages();
                }
                yield null;
            }
            case 1613178968 -> {
                if (name.equalsString("ModuleResolution")) {
                    yield Attributes.moduleResolution();
                }
                yield null;
            }
            case 1447483197 -> {
                if (name.equalsString("ModuleTarget")) {
                    yield Attributes.moduleTarget();
                }
                yield null;
            }
            case 1345547328 -> {
                if (name.equalsString("NestHost")) {
                    yield Attributes.nestHost();
                }
                yield null;
            }
            case 1194699649 -> {
                if (name.equalsString("NestMembers")) {
                    yield Attributes.nestMembers();
                }
                yield null;
            }
            case 1895881214 -> {
                if (name.equalsString("PermittedSubclasses")) {
                    yield Attributes.permittedSubclasses();
                }
                yield null;
            }
            case -777299855 -> {
                if (name.equalsString("Record")) {
                    yield Attributes.record();
                }
                yield null;
            }
            case 1971868943 -> {
                if (name.equalsString("RuntimeInvisibleAnnotations")) {
                    yield Attributes.runtimeInvisibleAnnotations();
                }
                yield null;
            }
            case -864757200 -> {
                if (name.equalsString("RuntimeInvisibleParameterAnnotations")) {
                    yield Attributes.runtimeInvisibleParameterAnnotations();
                }
                yield null;
            }
            case -160000011 -> {
                if (name.equalsString("RuntimeInvisibleTypeAnnotations")) {
                    yield Attributes.runtimeInvisibleTypeAnnotations();
                }
                yield null;
            }
            case -528253654 -> {
                if (name.equalsString("RuntimeVisibleAnnotations")) {
                    yield Attributes.runtimeVisibleAnnotations();
                }
                yield null;
            }
            case -918183819 -> {
                if (name.equalsString("RuntimeVisibleParameterAnnotations")) {
                    yield Attributes.runtimeVisibleParameterAnnotations();
                }
                yield null;
            }
            case 1629108880 -> {
                if (name.equalsString("RuntimeVisibleTypeAnnotations")) {
                    yield Attributes.runtimeVisibleTypeAnnotations();
                }
                yield null;
            }
            case -143673192 -> {
                if (name.equalsString("Signature")) {
                    yield Attributes.signature();
                }
                yield null;
            }
            case 1799467079 -> {
                if (name.equalsString("SourceDebugExtension")) {
                    yield Attributes.sourceDebugExtension();
                }
                yield null;
            }
            case 1955342423 -> {
                if (name.equalsString("SourceFile")) {
                    yield Attributes.sourceFile();
                }
                yield null;
            }
            case 1810971286 -> {
                if (name.equalsString("SourceID")) {
                    yield Attributes.sourceId();
                }
                yield null;
            }
            case -91885990 -> {
                if (name.equalsString("StackMapTable")) {
                    yield Attributes.stackMapTable();
                }
                yield null;
            }
            case -228128987 -> {
                if (name.equalsString("Synthetic")) {
                    yield Attributes.synthetic();
                }
                yield null;
            }
            default -> null;
        };
    }

    public static final class BoundUnknownAttribute
    extends BoundAttribute<UnknownAttribute>
    implements UnknownAttribute {
        public BoundUnknownAttribute(ClassReader cf, AttributeMapper<UnknownAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static abstract class BoundCodeAttribute
    extends BoundAttribute<CodeAttribute>
    implements CodeAttribute {
        protected final int codeStart;
        protected final int codeLength;
        protected final int codeEnd;
        protected final int attributePos;
        protected final int exceptionHandlerPos;
        protected final int exceptionHandlerCnt;
        protected final MethodModel enclosingMethod;

        public BoundCodeAttribute(AttributedElement enclosing, ClassReader reader, AttributeMapper<CodeAttribute> mapper, int payloadStart) {
            super(reader, mapper, payloadStart);
            this.codeLength = this.classReader.readInt(payloadStart + 4);
            this.enclosingMethod = (MethodModel)enclosing;
            this.codeStart = payloadStart + 8;
            this.exceptionHandlerPos = this.codeEnd = this.codeStart + this.codeLength;
            this.exceptionHandlerCnt = this.classReader.readU2(this.exceptionHandlerPos);
            this.attributePos = this.exceptionHandlerPos + 2 + this.exceptionHandlerCnt * 8;
        }

        @Override
        public int maxStack() {
            return this.classReader.readU2(this.payloadStart);
        }

        @Override
        public int maxLocals() {
            return this.classReader.readU2(this.payloadStart + 2);
        }

        @Override
        public int codeLength() {
            return this.codeLength;
        }

        @Override
        public byte[] codeArray() {
            return this.classReader.readBytes(this.payloadStart + 8, this.codeLength());
        }
    }

    public static final class BoundPermittedSubclassesAttribute
    extends BoundAttribute<PermittedSubclassesAttribute>
    implements PermittedSubclassesAttribute {
        private List<ClassEntry> permittedSubclasses = null;

        public BoundPermittedSubclassesAttribute(ClassReader cf, AttributeMapper<PermittedSubclassesAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<ClassEntry> permittedSubclasses() {
            if (this.permittedSubclasses == null) {
                this.permittedSubclasses = this.readEntryList(this.payloadStart, ClassEntry.class);
            }
            return this.permittedSubclasses;
        }
    }

    public static final class BoundRuntimeVisibleAnnotationsAttribute
    extends BoundAttribute<RuntimeVisibleAnnotationsAttribute>
    implements RuntimeVisibleAnnotationsAttribute {
        private List<Annotation> inflated;

        public BoundRuntimeVisibleAnnotationsAttribute(ClassReader cf, int payloadStart) {
            super(cf, Attributes.runtimeVisibleAnnotations(), payloadStart);
        }

        @Override
        public List<Annotation> annotations() {
            if (this.inflated == null) {
                this.inflated = AnnotationReader.readAnnotations(this.classReader, this.payloadStart);
            }
            return this.inflated;
        }
    }

    public static final class BoundRuntimeInvisibleAnnotationsAttribute
    extends BoundAttribute<RuntimeInvisibleAnnotationsAttribute>
    implements RuntimeInvisibleAnnotationsAttribute {
        private List<Annotation> inflated;

        public BoundRuntimeInvisibleAnnotationsAttribute(ClassReader cf, int payloadStart) {
            super(cf, Attributes.runtimeInvisibleAnnotations(), payloadStart);
        }

        @Override
        public List<Annotation> annotations() {
            if (this.inflated == null) {
                this.inflated = AnnotationReader.readAnnotations(this.classReader, this.payloadStart);
            }
            return this.inflated;
        }
    }

    public static final class BoundRuntimeInvisibleParameterAnnotationsAttribute
    extends BoundAttribute<RuntimeInvisibleParameterAnnotationsAttribute>
    implements RuntimeInvisibleParameterAnnotationsAttribute {
        public BoundRuntimeInvisibleParameterAnnotationsAttribute(ClassReader cf, AttributeMapper<RuntimeInvisibleParameterAnnotationsAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<List<Annotation>> parameterAnnotations() {
            return AnnotationReader.readParameterAnnotations(this.classReader, this.payloadStart);
        }
    }

    public static final class BoundRuntimeVisibleParameterAnnotationsAttribute
    extends BoundAttribute<RuntimeVisibleParameterAnnotationsAttribute>
    implements RuntimeVisibleParameterAnnotationsAttribute {
        public BoundRuntimeVisibleParameterAnnotationsAttribute(ClassReader cf, AttributeMapper<RuntimeVisibleParameterAnnotationsAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<List<Annotation>> parameterAnnotations() {
            return AnnotationReader.readParameterAnnotations(this.classReader, this.payloadStart);
        }
    }

    public static final class BoundRuntimeInvisibleTypeAnnotationsAttribute
    extends BoundAttribute<RuntimeInvisibleTypeAnnotationsAttribute>
    implements RuntimeInvisibleTypeAnnotationsAttribute {
        private final LabelContext labelContext;

        public BoundRuntimeInvisibleTypeAnnotationsAttribute(AttributedElement enclosing, ClassReader cf, AttributeMapper<RuntimeInvisibleTypeAnnotationsAttribute> mapper, int pos) {
            super(cf, mapper, pos);
            LabelContext lc;
            this.labelContext = enclosing instanceof LabelContext ? (lc = (LabelContext)((Object)enclosing)) : null;
        }

        @Override
        public List<TypeAnnotation> annotations() {
            return AnnotationReader.readTypeAnnotations(this.classReader, this.payloadStart, this.labelContext);
        }
    }

    public static final class BoundRuntimeVisibleTypeAnnotationsAttribute
    extends BoundAttribute<RuntimeVisibleTypeAnnotationsAttribute>
    implements RuntimeVisibleTypeAnnotationsAttribute {
        private final LabelContext labelContext;

        public BoundRuntimeVisibleTypeAnnotationsAttribute(AttributedElement enclosing, ClassReader cf, AttributeMapper<RuntimeVisibleTypeAnnotationsAttribute> mapper, int pos) {
            super(cf, mapper, pos);
            LabelContext lc;
            this.labelContext = enclosing instanceof LabelContext ? (lc = (LabelContext)((Object)enclosing)) : null;
        }

        @Override
        public List<TypeAnnotation> annotations() {
            return AnnotationReader.readTypeAnnotations(this.classReader, this.payloadStart, this.labelContext);
        }
    }

    public static final class BoundAnnotationDefaultAttr
    extends BoundAttribute<AnnotationDefaultAttribute>
    implements AnnotationDefaultAttribute {
        private AnnotationValue annotationValue;

        public BoundAnnotationDefaultAttr(ClassReader cf, AttributeMapper<AnnotationDefaultAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public AnnotationValue defaultValue() {
            if (this.annotationValue == null) {
                this.annotationValue = AnnotationReader.readElementValue(this.classReader, this.payloadStart);
            }
            return this.annotationValue;
        }
    }

    public static final class BoundEnclosingMethodAttribute
    extends BoundAttribute<EnclosingMethodAttribute>
    implements EnclosingMethodAttribute {
        public BoundEnclosingMethodAttribute(ClassReader cf, AttributeMapper<EnclosingMethodAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public ClassEntry enclosingClass() {
            return this.classReader.readEntry(this.payloadStart, ClassEntry.class);
        }

        @Override
        public Optional<NameAndTypeEntry> enclosingMethod() {
            return Optional.ofNullable(this.classReader.readEntryOrNull(this.payloadStart + 2, NameAndTypeEntry.class));
        }
    }

    public static final class BoundInnerClassesAttribute
    extends BoundAttribute<InnerClassesAttribute>
    implements InnerClassesAttribute {
        private List<InnerClassInfo> classes;

        public BoundInnerClassesAttribute(ClassReader cf, AttributeMapper<InnerClassesAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<InnerClassInfo> classes() {
            if (this.classes == null) {
                int cnt = this.classReader.readU2(this.payloadStart);
                int p = this.payloadStart + 2;
                InnerClassInfo[] elements = new InnerClassInfo[cnt];
                for (int i = 0; i < cnt; ++i) {
                    ClassEntry innerClass = this.classReader.readEntry(p, ClassEntry.class);
                    ClassEntry outerClass = this.classReader.readEntryOrNull(p + 2, ClassEntry.class);
                    Utf8Entry innerName = this.classReader.readEntryOrNull(p + 4, Utf8Entry.class);
                    int flags = this.classReader.readU2(p + 6);
                    p += 8;
                    elements[i] = InnerClassInfo.of(innerClass, Optional.ofNullable(outerClass), Optional.ofNullable(innerName), flags);
                }
                this.classes = List.of(elements);
            }
            return this.classes;
        }
    }

    public static final class BoundBootstrapMethodsAttribute
    extends BoundAttribute<BootstrapMethodsAttribute>
    implements BootstrapMethodsAttribute {
        private List<BootstrapMethodEntry> bootstraps = null;
        private final int size;

        public BoundBootstrapMethodsAttribute(ClassReader reader, AttributeMapper<BootstrapMethodsAttribute> mapper, int pos) {
            super(reader, mapper, pos);
            this.size = this.classReader.readU2(pos);
        }

        @Override
        public int bootstrapMethodsSize() {
            return this.size;
        }

        @Override
        public List<BootstrapMethodEntry> bootstrapMethods() {
            if (this.bootstraps == null) {
                BootstrapMethodEntry[] bs = new BootstrapMethodEntry[this.size];
                int p = this.payloadStart + 2;
                for (int i = 0; i < this.size; ++i) {
                    AbstractPoolEntry.MethodHandleEntryImpl handle = this.classReader.readEntry(p, AbstractPoolEntry.MethodHandleEntryImpl.class);
                    List<LoadableConstantEntry> args = this.readEntryList(p + 2, LoadableConstantEntry.class);
                    p += 4 + args.size() * 2;
                    int hash = BootstrapMethodEntryImpl.computeHashCode(handle, args);
                    bs[i] = new BootstrapMethodEntryImpl(this.classReader, i, hash, handle, args);
                }
                this.bootstraps = List.of(bs);
            }
            return this.bootstraps;
        }
    }

    public static final class BoundNestMembersAttribute
    extends BoundAttribute<NestMembersAttribute>
    implements NestMembersAttribute {
        private List<ClassEntry> members = null;

        public BoundNestMembersAttribute(ClassReader cf, AttributeMapper<NestMembersAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<ClassEntry> nestMembers() {
            if (this.members == null) {
                this.members = this.readEntryList(this.payloadStart, ClassEntry.class);
            }
            return this.members;
        }
    }

    public static final class BoundModulePackagesAttribute
    extends BoundAttribute<ModulePackagesAttribute>
    implements ModulePackagesAttribute {
        private List<PackageEntry> packages = null;

        public BoundModulePackagesAttribute(ClassReader cf, AttributeMapper<ModulePackagesAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<PackageEntry> packages() {
            if (this.packages == null) {
                this.packages = this.readEntryList(this.payloadStart, PackageEntry.class);
            }
            return this.packages;
        }
    }

    public static final class BoundModuleAttribute
    extends BoundAttribute<ModuleAttribute>
    implements ModuleAttribute {
        private List<ModuleRequireInfo> requires = null;
        private List<ModuleExportInfo> exports = null;
        private List<ModuleOpenInfo> opens = null;
        private List<ClassEntry> uses = null;
        private List<ModuleProvideInfo> provides = null;

        public BoundModuleAttribute(ClassReader cf, AttributeMapper<ModuleAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public ModuleEntry moduleName() {
            return this.classReader.readEntry(this.payloadStart, ModuleEntry.class);
        }

        @Override
        public int moduleFlagsMask() {
            return this.classReader.readU2(this.payloadStart + 2);
        }

        @Override
        public Optional<Utf8Entry> moduleVersion() {
            return Optional.ofNullable(this.classReader.readEntryOrNull(this.payloadStart + 4, Utf8Entry.class));
        }

        @Override
        public List<ModuleRequireInfo> requires() {
            if (this.requires == null) {
                this.structure();
            }
            return this.requires;
        }

        @Override
        public List<ModuleExportInfo> exports() {
            if (this.exports == null) {
                this.structure();
            }
            return this.exports;
        }

        @Override
        public List<ModuleOpenInfo> opens() {
            if (this.opens == null) {
                this.structure();
            }
            return this.opens;
        }

        @Override
        public List<ClassEntry> uses() {
            if (this.uses == null) {
                this.structure();
            }
            return this.uses;
        }

        @Override
        public List<ModuleProvideInfo> provides() {
            if (this.provides == null) {
                this.structure();
            }
            return this.provides;
        }

        private void structure() {
            int i;
            int p = this.payloadStart + 8;
            int cnt = this.classReader.readU2(this.payloadStart + 6);
            Object[] elements = new ModuleRequireInfo[cnt];
            int end = p + cnt * 6;
            int i2 = 0;
            while (p < end) {
                elements[i2] = ModuleRequireInfo.of(this.classReader.readEntry(p, ModuleEntry.class), this.classReader.readU2(p + 2), this.classReader.readEntryOrNull(p + 4, Utf8Entry.class));
                p += 6;
                ++i2;
            }
            this.requires = List.of(elements);
            cnt = this.classReader.readU2(p);
            p += 2;
            elements = new ModuleExportInfo[cnt];
            for (i = 0; i < cnt; ++i) {
                PackageEntry pe = this.classReader.readEntry(p, PackageEntry.class);
                int exportFlags = this.classReader.readU2(p + 2);
                List<ModuleEntry> exportsTo = this.readEntryList(p += 4, ModuleEntry.class);
                p += 2 + exportsTo.size() * 2;
                elements[i] = ModuleExportInfo.of(pe, exportFlags, exportsTo);
            }
            this.exports = List.of(elements);
            cnt = this.classReader.readU2(p);
            p += 2;
            elements = new ModuleOpenInfo[cnt];
            for (i = 0; i < cnt; ++i) {
                PackageEntry po = this.classReader.readEntry(p, PackageEntry.class);
                int opensFlags = this.classReader.readU2(p + 2);
                List<ModuleEntry> opensTo = this.readEntryList(p += 4, ModuleEntry.class);
                p += 2 + opensTo.size() * 2;
                elements[i] = ModuleOpenInfo.of(po, opensFlags, opensTo);
            }
            this.opens = List.of(elements);
            this.uses = this.readEntryList(p, ClassEntry.class);
            cnt = this.classReader.readU2(p += 2 + this.uses.size() * 2);
            p += 2;
            elements = new ModuleProvideInfo[cnt];
            this.provides = new ArrayList<ModuleProvideInfo>(cnt);
            for (i = 0; i < cnt; ++i) {
                ClassEntry c = this.classReader.readEntry(p, ClassEntry.class);
                List<ClassEntry> providesWith = this.readEntryList(p += 2, ClassEntry.class);
                p += 2 + providesWith.size() * 2;
                elements[i] = ModuleProvideInfo.of(c, providesWith);
            }
            this.provides = List.of(elements);
        }
    }

    public static final class BoundExceptionsAttribute
    extends BoundAttribute<ExceptionsAttribute>
    implements ExceptionsAttribute {
        private List<ClassEntry> exceptions = null;

        public BoundExceptionsAttribute(ClassReader cf, AttributeMapper<ExceptionsAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<ClassEntry> exceptions() {
            if (this.exceptions == null) {
                this.exceptions = this.readEntryList(this.payloadStart, ClassEntry.class);
            }
            return this.exceptions;
        }
    }

    public static final class BoundModuleResolutionAttribute
    extends BoundAttribute<ModuleResolutionAttribute>
    implements ModuleResolutionAttribute {
        public BoundModuleResolutionAttribute(ClassReader cf, AttributeMapper<ModuleResolutionAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public int resolutionFlags() {
            return this.classReader.readU2(this.payloadStart);
        }
    }

    public static final class BoundSourceIDAttribute
    extends BoundAttribute<SourceIDAttribute>
    implements SourceIDAttribute {
        public BoundSourceIDAttribute(ClassReader cf, AttributeMapper<SourceIDAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public Utf8Entry sourceId() {
            return this.classReader.readEntry(this.payloadStart, Utf8Entry.class);
        }
    }

    public static final class BoundCompilationIDAttribute
    extends BoundAttribute<CompilationIDAttribute>
    implements CompilationIDAttribute {
        public BoundCompilationIDAttribute(ClassReader cf, AttributeMapper<CompilationIDAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public Utf8Entry compilationId() {
            return this.classReader.readEntry(this.payloadStart, Utf8Entry.class);
        }
    }

    public static final class BoundModuleTargetAttribute
    extends BoundAttribute<ModuleTargetAttribute>
    implements ModuleTargetAttribute {
        public BoundModuleTargetAttribute(ClassReader cf, AttributeMapper<ModuleTargetAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public Utf8Entry targetPlatform() {
            return this.classReader.readEntry(this.payloadStart, Utf8Entry.class);
        }
    }

    public static final class BoundConstantValueAttribute
    extends BoundAttribute<ConstantValueAttribute>
    implements ConstantValueAttribute {
        public BoundConstantValueAttribute(ClassReader cf, AttributeMapper<ConstantValueAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public ConstantValueEntry constant() {
            return this.classReader.readEntry(this.payloadStart, ConstantValueEntry.class);
        }
    }

    public static final class BoundSourceDebugExtensionAttribute
    extends BoundAttribute<SourceDebugExtensionAttribute>
    implements SourceDebugExtensionAttribute {
        public BoundSourceDebugExtensionAttribute(ClassReader cf, AttributeMapper<SourceDebugExtensionAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }
    }

    public static final class BoundNestHostAttribute
    extends BoundAttribute<NestHostAttribute>
    implements NestHostAttribute {
        public BoundNestHostAttribute(ClassReader cf, AttributeMapper<NestHostAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public ClassEntry nestHost() {
            return this.classReader.readEntry(this.payloadStart, ClassEntry.class);
        }
    }

    public static final class BoundModuleMainClassAttribute
    extends BoundAttribute<ModuleMainClassAttribute>
    implements ModuleMainClassAttribute {
        public BoundModuleMainClassAttribute(ClassReader cf, AttributeMapper<ModuleMainClassAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public ClassEntry mainClass() {
            return this.classReader.readEntry(this.payloadStart, ClassEntry.class);
        }
    }

    public static final class BoundSourceFileAttribute
    extends BoundAttribute<SourceFileAttribute>
    implements SourceFileAttribute {
        public BoundSourceFileAttribute(ClassReader cf, AttributeMapper<SourceFileAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public Utf8Entry sourceFile() {
            return this.classReader.readEntry(this.payloadStart, Utf8Entry.class);
        }
    }

    public static final class BoundSignatureAttribute
    extends BoundAttribute<SignatureAttribute>
    implements SignatureAttribute {
        public BoundSignatureAttribute(ClassReader cf, AttributeMapper<SignatureAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public Utf8Entry signature() {
            return this.classReader.readEntry(this.payloadStart, Utf8Entry.class);
        }
    }

    public static final class BoundDeprecatedAttribute
    extends BoundAttribute<DeprecatedAttribute>
    implements DeprecatedAttribute {
        public BoundDeprecatedAttribute(ClassReader cf, AttributeMapper<DeprecatedAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }
    }

    public static final class BoundRecordAttribute
    extends BoundAttribute<RecordAttribute>
    implements RecordAttribute {
        private List<RecordComponentInfo> components = null;

        public BoundRecordAttribute(ClassReader cf, AttributeMapper<RecordAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<RecordComponentInfo> components() {
            if (this.components == null) {
                int cnt = this.classReader.readU2(this.payloadStart);
                RecordComponentInfo[] elements = new RecordComponentInfo[cnt];
                int p = this.payloadStart + 2;
                for (int i = 0; i < cnt; ++i) {
                    elements[i] = new BoundRecordComponentInfo(this.classReader, p);
                    p = this.classReader.skipAttributeHolder(p + 4);
                }
                this.components = List.of(elements);
            }
            return this.components;
        }
    }

    public static final class BoundModuleHashesAttribute
    extends BoundAttribute<ModuleHashesAttribute>
    implements ModuleHashesAttribute {
        private List<ModuleHashInfo> hashes = null;

        public BoundModuleHashesAttribute(ClassReader cf, AttributeMapper<ModuleHashesAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public Utf8Entry algorithm() {
            return this.classReader.readEntry(this.payloadStart, Utf8Entry.class);
        }

        @Override
        public List<ModuleHashInfo> hashes() {
            if (this.hashes == null) {
                int cnt = this.classReader.readU2(this.payloadStart + 2);
                ModuleHashInfo[] elements = new ModuleHashInfo[cnt];
                int p = this.payloadStart + 4;
                for (int i = 0; i < cnt; ++i) {
                    ModuleEntry module = this.classReader.readEntry(p, ModuleEntry.class);
                    int hashLength = this.classReader.readU2(p + 2);
                    elements[i] = ModuleHashInfo.of(module, this.classReader.readBytes(p += 4, hashLength));
                    p += hashLength;
                }
                this.hashes = List.of(elements);
            }
            return this.hashes;
        }
    }

    public static final class BoundMethodParametersAttribute
    extends BoundAttribute<MethodParametersAttribute>
    implements MethodParametersAttribute {
        private List<MethodParameterInfo> parameters = null;

        public BoundMethodParametersAttribute(ClassReader cf, AttributeMapper<MethodParametersAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<MethodParameterInfo> parameters() {
            if (this.parameters == null) {
                int cnt = this.classReader.readU1(this.payloadStart);
                MethodParameterInfo[] elements = new MethodParameterInfo[cnt];
                int p = this.payloadStart + 1;
                int pEnd = p + cnt * 4;
                int i = 0;
                while (p < pEnd) {
                    Utf8Entry name = this.classReader.readEntryOrNull(p, Utf8Entry.class);
                    int accessFlags = this.classReader.readU2(p + 2);
                    elements[i] = MethodParameterInfo.of(Optional.ofNullable(name), accessFlags);
                    p += 4;
                    ++i;
                }
                this.parameters = List.of(elements);
            }
            return this.parameters;
        }
    }

    public static final class BoundLocalVariableTypeTableAttribute
    extends BoundAttribute<LocalVariableTypeTableAttribute>
    implements LocalVariableTypeTableAttribute {
        private final CodeImpl codeAttribute;
        private List<LocalVariableTypeInfo> localVars = null;

        public BoundLocalVariableTypeTableAttribute(AttributedElement enclosing, ClassReader cf, AttributeMapper<LocalVariableTypeTableAttribute> mapper, int pos) {
            super(cf, mapper, pos);
            CodeImpl ci;
            if (!(enclosing instanceof CodeImpl)) {
                throw new IllegalArgumentException("Invalid LocalVariableTypeTable attribute location");
            }
            this.codeAttribute = ci = (CodeImpl)enclosing;
        }

        @Override
        public List<LocalVariableTypeInfo> localVariableTypes() {
            if (this.localVars == null) {
                int cnt = this.classReader.readU2(this.payloadStart);
                BoundLocalVariableType[] elements = new BoundLocalVariableType[cnt];
                int p = this.payloadStart + 2;
                int pEnd = p + cnt * 10;
                int i = 0;
                while (p < pEnd) {
                    elements[i] = new BoundLocalVariableType(this.codeAttribute, p);
                    p += 10;
                    ++i;
                }
                this.localVars = List.of(elements);
            }
            return this.localVars;
        }
    }

    public static final class BoundLocalVariableTableAttribute
    extends BoundAttribute<LocalVariableTableAttribute>
    implements LocalVariableTableAttribute {
        private final CodeImpl codeAttribute;
        private List<LocalVariableInfo> localVars = null;

        public BoundLocalVariableTableAttribute(AttributedElement enclosing, ClassReader cf, AttributeMapper<LocalVariableTableAttribute> mapper, int pos) {
            super(cf, mapper, pos);
            CodeImpl ci;
            if (!(enclosing instanceof CodeImpl)) {
                throw new IllegalArgumentException("Invalid LocalVariableTable attribute location");
            }
            this.codeAttribute = ci = (CodeImpl)enclosing;
        }

        @Override
        public List<LocalVariableInfo> localVariables() {
            if (this.localVars == null) {
                int cnt = this.classReader.readU2(this.payloadStart);
                BoundLocalVariable[] elements = new BoundLocalVariable[cnt];
                int p = this.payloadStart + 2;
                int pEnd = p + cnt * 10;
                int i = 0;
                while (p < pEnd) {
                    elements[i] = new BoundLocalVariable(this.codeAttribute, p);
                    p += 10;
                    ++i;
                }
                this.localVars = List.of(elements);
            }
            return this.localVars;
        }
    }

    public static final class BoundCharacterRangeTableAttribute
    extends BoundAttribute<CharacterRangeTableAttribute>
    implements CharacterRangeTableAttribute {
        private List<CharacterRangeInfo> characterRangeTable = null;

        public BoundCharacterRangeTableAttribute(ClassReader cf, AttributeMapper<CharacterRangeTableAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<CharacterRangeInfo> characterRangeTable() {
            if (this.characterRangeTable == null) {
                int nLn = this.classReader.readU2(this.payloadStart);
                CharacterRangeInfo[] elements = new CharacterRangeInfo[nLn];
                int p = this.payloadStart + 2;
                int pEnd = p + nLn * 14;
                int i = 0;
                while (p < pEnd) {
                    int startPc = this.classReader.readU2(p);
                    int endPc = this.classReader.readU2(p + 2);
                    int characterRangeStart = this.classReader.readInt(p + 4);
                    int characterRangeEnd = this.classReader.readInt(p + 8);
                    int flags = this.classReader.readU2(p + 12);
                    elements[i] = CharacterRangeInfo.of(startPc, endPc, characterRangeStart, characterRangeEnd, flags);
                    p += 14;
                    ++i;
                }
                this.characterRangeTable = List.of(elements);
            }
            return this.characterRangeTable;
        }
    }

    public static final class BoundLineNumberTableAttribute
    extends BoundAttribute<LineNumberTableAttribute>
    implements LineNumberTableAttribute {
        private List<LineNumberInfo> lineNumbers = null;

        public BoundLineNumberTableAttribute(ClassReader cf, AttributeMapper<LineNumberTableAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }

        @Override
        public List<LineNumberInfo> lineNumbers() {
            if (this.lineNumbers == null) {
                int nLn = this.classReader.readU2(this.payloadStart);
                LineNumberInfo[] elements = new LineNumberInfo[nLn];
                int p = this.payloadStart + 2;
                int pEnd = p + nLn * 4;
                int i = 0;
                while (p < pEnd) {
                    int startPc = this.classReader.readU2(p);
                    int lineNumber = this.classReader.readU2(p + 2);
                    elements[i] = LineNumberInfo.of(startPc, lineNumber);
                    p += 4;
                    ++i;
                }
                this.lineNumbers = List.of(elements);
            }
            return this.lineNumbers;
        }
    }

    public static final class BoundSyntheticAttribute
    extends BoundAttribute<SyntheticAttribute>
    implements SyntheticAttribute {
        public BoundSyntheticAttribute(ClassReader cf, AttributeMapper<SyntheticAttribute> mapper, int pos) {
            super(cf, mapper, pos);
        }
    }

    public static final class BoundStackMapTableAttribute
    extends BoundAttribute<StackMapTableAttribute>
    implements StackMapTableAttribute {
        final MethodModel method;
        final LabelContext ctx;
        List<StackMapFrameInfo> entries = null;

        public BoundStackMapTableAttribute(CodeImpl code, ClassReader cf, AttributeMapper<StackMapTableAttribute> mapper, int pos) {
            super(cf, mapper, pos);
            this.method = code.parent().orElseThrow();
            this.ctx = code;
        }

        @Override
        public List<StackMapFrameInfo> entries() {
            if (this.entries == null) {
                this.entries = new StackMapDecoder(this.classReader, this.payloadStart, this.ctx, StackMapDecoder.initFrameLocals(this.method)).entries();
            }
            return this.entries;
        }

        @Override
        public void writeTo(BufWriterImpl buf) {
            if (buf.canWriteDirect(this.classReader) && buf.labelsMatch(this.ctx)) {
                this.classReader.copyBytesTo(buf, this.payloadStart - 6, this.payloadLen() + 6);
            } else {
                this.attributeMapper().writeAttribute(buf, this);
            }
        }
    }
}

