/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.components;

import io.smallrye.classfile.ClassFile;
import io.smallrye.classfile.ClassModel;
import io.smallrye.classfile.ClassTransform;
import io.smallrye.classfile.CodeTransform;
import io.smallrye.classfile.FieldTransform;
import io.smallrye.classfile.MethodTransform;
import io.smallrye.classfile.impl.ClassRemapperImpl;
import java.lang.constant.ClassDesc;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClassRemapper
extends ClassTransform {
    public static ClassRemapper of(Map<ClassDesc, ClassDesc> classMap) {
        Objects.requireNonNull(classMap);
        return ClassRemapper.of((ClassDesc desc) -> classMap.getOrDefault(desc, (ClassDesc)desc));
    }

    public static ClassRemapper of(Function<ClassDesc, ClassDesc> mapFunction) {
        return new ClassRemapperImpl(Objects.requireNonNull(mapFunction));
    }

    public ClassDesc map(ClassDesc var1);

    public FieldTransform asFieldTransform();

    public MethodTransform asMethodTransform();

    public CodeTransform asCodeTransform();

    default public byte[] remapClass(ClassFile context, ClassModel clm) {
        return context.transformClass(clm, this.map(clm.thisClass().asSymbol()), (ClassTransform)this);
    }
}

