/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.attribute;

import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.ClassElement;
import io.smallrye.classfile.constantpool.PackageEntry;
import io.smallrye.classfile.extras.constant.PackageDesc;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.UnboundAttribute;
import java.util.Arrays;
import java.util.List;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ModulePackagesAttribute
extends Attribute<ModulePackagesAttribute>,
ClassElement {
    public List<PackageEntry> packages();

    public static ModulePackagesAttribute of(List<PackageEntry> packages) {
        return new UnboundAttribute.UnboundModulePackagesAttribute(packages);
    }

    public static ModulePackagesAttribute of(PackageEntry ... packages) {
        return ModulePackagesAttribute.of(List.of(packages));
    }

    public static ModulePackagesAttribute ofNames(List<PackageDesc> packages) {
        PackageEntry[] p = new PackageEntry[packages.size()];
        for (int i = 0; i < packages.size(); ++i) {
            p[i] = TemporaryConstantPool.INSTANCE.packageEntry(TemporaryConstantPool.INSTANCE.utf8Entry(packages.get(i).internalName()));
        }
        return ModulePackagesAttribute.of(p);
    }

    public static ModulePackagesAttribute ofNames(PackageDesc ... packages) {
        return ModulePackagesAttribute.ofNames(Arrays.asList(packages));
    }
}

