/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile;

import io.smallrye.classfile.AttributeMapper;
import io.smallrye.classfile.ClassBuilder;
import io.smallrye.classfile.ClassHierarchyResolver;
import io.smallrye.classfile.ClassModel;
import io.smallrye.classfile.ClassTransform;
import io.smallrye.classfile.attribute.ModuleAttribute;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.constantpool.ConstantPoolBuilder;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.extras.constant.ConstantUtils;
import io.smallrye.classfile.extras.reflect.AccessFlag;
import io.smallrye.classfile.impl.ClassFileImpl;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import java.io.IOException;
import java.lang.constant.ClassDesc;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ClassFile {
    public static final int MAGIC_NUMBER = -889275714;
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ENUM = 16384;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_SUPER = 32;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_STRICT = 2048;
    public static final int ACC_MODULE = 32768;
    public static final int ACC_OPEN = 32;
    public static final int ACC_MANDATED = 32768;
    public static final int ACC_TRANSITIVE = 32;
    public static final int ACC_STATIC_PHASE = 64;
    public static final int JAVA_1_VERSION = 45;
    public static final int JAVA_2_VERSION = 46;
    public static final int JAVA_3_VERSION = 47;
    public static final int JAVA_4_VERSION = 48;
    public static final int JAVA_5_VERSION = 49;
    public static final int JAVA_6_VERSION = 50;
    public static final int JAVA_7_VERSION = 51;
    public static final int JAVA_8_VERSION = 52;
    public static final int JAVA_9_VERSION = 53;
    public static final int JAVA_10_VERSION = 54;
    public static final int JAVA_11_VERSION = 55;
    public static final int JAVA_12_VERSION = 56;
    public static final int JAVA_13_VERSION = 57;
    public static final int JAVA_14_VERSION = 58;
    public static final int JAVA_15_VERSION = 59;
    public static final int JAVA_16_VERSION = 60;
    public static final int JAVA_17_VERSION = 61;
    public static final int JAVA_18_VERSION = 62;
    public static final int JAVA_19_VERSION = 63;
    public static final int JAVA_20_VERSION = 64;
    public static final int JAVA_21_VERSION = 65;
    public static final int JAVA_22_VERSION = 66;
    public static final int JAVA_23_VERSION = 67;
    public static final int JAVA_24_VERSION = 68;
    public static final int JAVA_25_VERSION = 69;
    public static final int JAVA_26_VERSION = 70;
    public static final int PREVIEW_MINOR_VERSION = 65535;

    public static ClassFile of() {
        return ClassFileImpl.DEFAULT_CONTEXT;
    }

    public static ClassFile of(Option ... options) {
        return ClassFile.of().withOptions(options);
    }

    public ClassFile withOptions(Option ... var1);

    public ClassModel parse(byte[] var1);

    default public ClassModel parse(Path path) throws IOException {
        return this.parse(Files.readAllBytes(path));
    }

    default public byte[] build(ClassDesc thisClass, Consumer<? super ClassBuilder> handler) {
        ConstantPoolBuilder pool = ConstantPoolBuilder.of();
        return this.build(pool.classEntry(thisClass), pool, handler);
    }

    public byte[] build(ClassEntry var1, ConstantPoolBuilder var2, Consumer<? super ClassBuilder> var3);

    default public void buildTo(Path path, ClassDesc thisClass, Consumer<ClassBuilder> handler) throws IOException {
        Files.write(path, this.build(thisClass, handler), new OpenOption[0]);
    }

    default public void buildTo(Path path, ClassEntry thisClassEntry, ConstantPoolBuilder constantPool, Consumer<? super ClassBuilder> handler) throws IOException {
        Files.write(path, this.build(thisClassEntry, constantPool, handler), new OpenOption[0]);
    }

    default public byte[] buildModule(ModuleAttribute moduleAttribute) {
        return this.buildModule(moduleAttribute, clb -> {});
    }

    default public byte[] buildModule(ModuleAttribute moduleAttribute, Consumer<? super ClassBuilder> handler) {
        return this.build(ConstantUtils.CD_module_info, clb -> {
            clb.withFlags(AccessFlag.MODULE);
            clb.with(moduleAttribute);
            handler.accept((ClassBuilder)clb);
        });
    }

    default public void buildModuleTo(Path path, ModuleAttribute moduleAttribute) throws IOException {
        this.buildModuleTo(path, moduleAttribute, clb -> {});
    }

    default public void buildModuleTo(Path path, ModuleAttribute moduleAttribute, Consumer<? super ClassBuilder> handler) throws IOException {
        Files.write(path, this.buildModule(moduleAttribute, handler), new OpenOption[0]);
    }

    default public byte[] transformClass(ClassModel model, ClassTransform transform) {
        return this.transformClass(model, model.thisClass(), transform);
    }

    default public byte[] transformClass(ClassModel model, ClassDesc newClassName, ClassTransform transform) {
        return this.transformClass(model, TemporaryConstantPool.INSTANCE.classEntry(newClassName), transform);
    }

    public byte[] transformClass(ClassModel var1, ClassEntry var2, ClassTransform var3);

    public List<VerifyError> verify(ClassModel var1);

    public List<VerifyError> verify(byte[] var1);

    default public List<VerifyError> verify(Path path) throws IOException {
        return this.verify(Files.readAllBytes(path));
    }

    public static int latestMajorVersion() {
        return 70;
    }

    public static int latestMinorVersion() {
        return 0;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Option {
    }

    public static enum AttributesProcessingOption implements Option
    {
        PASS_ALL_ATTRIBUTES,
        DROP_UNKNOWN_ATTRIBUTES,
        DROP_UNSTABLE_ATTRIBUTES;

    }

    public static enum StackMapsOption implements Option
    {
        STACK_MAPS_WHEN_REQUIRED,
        GENERATE_STACK_MAPS,
        DROP_STACK_MAPS;

    }

    public static enum ShortJumpsOption implements Option
    {
        FIX_SHORT_JUMPS,
        FAIL_ON_SHORT_JUMPS;

    }

    public static enum LineNumbersOption implements Option
    {
        PASS_LINE_NUMBERS,
        DROP_LINE_NUMBERS;

    }

    public static enum DebugElementsOption implements Option
    {
        PASS_DEBUG,
        DROP_DEBUG;

    }

    public static enum DeadLabelsOption implements Option
    {
        FAIL_ON_DEAD_LABELS,
        DROP_DEAD_LABELS;

    }

    public static enum DeadCodeOption implements Option
    {
        PATCH_DEAD_CODE,
        KEEP_DEAD_CODE;

    }

    public static enum ConstantPoolSharingOption implements Option
    {
        SHARED_POOL,
        NEW_POOL;

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ClassHierarchyResolverOption
    extends Option {
        public static ClassHierarchyResolverOption of(ClassHierarchyResolver classHierarchyResolver) {
            Objects.requireNonNull(classHierarchyResolver);
            return new ClassFileImpl.ClassHierarchyResolverOptionImpl(classHierarchyResolver);
        }

        public ClassHierarchyResolver classHierarchyResolver();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface AttributeMapperOption
    extends Option {
        public static AttributeMapperOption of(Function<Utf8Entry, AttributeMapper<?>> attributeMapper) {
            Objects.requireNonNull(attributeMapper);
            return new ClassFileImpl.AttributeMapperOptionImpl(attributeMapper);
        }

        public Function<Utf8Entry, AttributeMapper<?>> attributeMapper();
    }
}

