/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.spring.commons;

import io.restassured.http.Cookie;
import io.restassured.http.Cookies;
import io.restassured.http.Headers;
import io.restassured.module.spring.commons.HeaderHelper;
import io.restassured.module.spring.commons.Serializer;
import io.restassured.module.spring.commons.config.SpecificationConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CookieHelper {
    private CookieHelper() {
    }

    public static Cookies cookies(Cookies requestCookies, Map<String, ?> cookies, Headers requestHeaders, SpecificationConfig config) {
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
        if (requestCookies.exist()) {
            for (Cookie requestCookie : requestCookies) {
                cookieList.add(requestCookie);
            }
        }
        for (Map.Entry<String, ?> stringEntry : cookies.entrySet()) {
            cookieList.add(new Cookie.Builder(stringEntry.getKey(), Serializer.serializeIfNeeded(stringEntry.getValue(), HeaderHelper.getRequestContentType(requestHeaders), config)).build());
        }
        return new Cookies(cookieList);
    }

    public static Cookies cookies(Cookies requestCookies, Cookies cookies) {
        if (cookies.exist()) {
            ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
            if (requestCookies.exist()) {
                for (Cookie cookie : requestCookies) {
                    cookieList.add(cookie);
                }
            }
            for (Cookie cookie : cookies) {
                cookieList.add(cookie);
            }
            return new Cookies(cookieList);
        }
        return requestCookies;
    }

    public static Cookies cookie(final String cookieName, final Object cookieValue, Headers requestHeaders, final SpecificationConfig config, Object ... additionalValues) {
        final String contentType = HeaderHelper.getRequestContentType(requestHeaders);
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>(){
            {
                this.add(new Cookie.Builder(cookieName, Serializer.serializeIfNeeded(cookieValue, contentType, config)).build());
            }
        };
        if (additionalValues != null) {
            for (Object additionalCookieValue : additionalValues) {
                cookieList.add(new Cookie.Builder(cookieName, Serializer.serializeIfNeeded(additionalCookieValue, contentType, config)).build());
            }
        }
        return new Cookies((List)cookieList);
    }

    public static Cookies sessionId(Cookies cookies, String sessionIdName, String sessionIdValue) {
        ArrayList<Cookie> allOtherCookies = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            if (cookie.getName().equalsIgnoreCase(sessionIdName)) continue;
            allOtherCookies.add(cookie);
        }
        allOtherCookies.add(new Cookie.Builder(sessionIdName, sessionIdValue).build());
        return new Cookies(allOtherCookies);
    }
}

