/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.SecurityIdentity;
import io.smallrye.mutiny.Uni;
import java.security.Permission;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class RolesMapping
implements Function<SecurityIdentity, SecurityIdentity> {
    static final String ROLES_MAPPING_KEY = "io.quarkus.vertx.http.runtime.security.RolesMapping";
    private final Map<String, Set<Permission>> roleToPermissions;
    private final Map<String, List<String>> roleToRoles;
    protected final boolean grantPermissions;
    protected final boolean grantRoles;

    RolesMapping(Map<String, Set<Permission>> roleToPermissions, Map<String, List<String>> roleToRoles) {
        if (roleToPermissions != null && !roleToPermissions.isEmpty()) {
            this.grantPermissions = true;
            this.roleToPermissions = Map.copyOf(roleToPermissions);
        } else {
            this.grantPermissions = false;
            this.roleToPermissions = null;
        }
        if (roleToRoles != null && !roleToRoles.isEmpty()) {
            this.grantRoles = true;
            this.roleToRoles = Map.copyOf(roleToRoles);
        } else {
            this.grantRoles = false;
            this.roleToRoles = null;
        }
    }

    public static RolesMapping of(Map<String, List<String>> roleToRoles) {
        return roleToRoles.isEmpty() ? null : new RolesMapping(null, roleToRoles);
    }

    @Override
    public SecurityIdentity apply(SecurityIdentity identity) {
        if (identity.isAnonymous()) {
            return identity;
        }
        SecurityIdentity newIdentity = this.augmentIdentity(identity);
        if (newIdentity == null) {
            return identity;
        }
        return newIdentity;
    }

    protected SecurityIdentity augmentIdentity(SecurityIdentity securityIdentity) {
        Set roles = securityIdentity.getRoles();
        if (roles != null && !roles.isEmpty()) {
            boolean addPerms;
            HashSet<Permission> permissions = this.grantPermissions ? new HashSet<Permission>() : null;
            HashSet newRoles = this.grantRoles ? new HashSet() : null;
            for (String role : roles) {
                if (this.grantPermissions && this.roleToPermissions.containsKey(role)) {
                    permissions.addAll((Collection<Permission>)this.roleToPermissions.get(role));
                }
                if (!this.grantRoles || !this.roleToRoles.containsKey(role)) continue;
                newRoles.addAll(this.roleToRoles.get(role));
            }
            boolean bl = addPerms = this.grantPermissions && !permissions.isEmpty();
            if (this.grantRoles && !newRoles.isEmpty()) {
                newRoles.addAll(roles);
                return RolesMapping.augmentIdentity(securityIdentity, permissions, Set.copyOf(newRoles), addPerms);
            }
            if (addPerms) {
                return RolesMapping.augmentIdentity(securityIdentity, permissions, roles, true);
            }
        }
        return null;
    }

    private static SecurityIdentity augmentIdentity(final SecurityIdentity securityIdentity, final Set<Permission> permissions, final Set<String> roles, final boolean addPerms) {
        return new SecurityIdentity(){

            public Principal getPrincipal() {
                return securityIdentity.getPrincipal();
            }

            public boolean isAnonymous() {
                return securityIdentity.isAnonymous();
            }

            public Set<String> getRoles() {
                return roles;
            }

            public boolean hasRole(String s) {
                return roles.contains(s);
            }

            public <T extends Credential> T getCredential(Class<T> aClass) {
                return (T)securityIdentity.getCredential(aClass);
            }

            public Set<Credential> getCredentials() {
                return securityIdentity.getCredentials();
            }

            public <T> T getAttribute(String s) {
                return (T)securityIdentity.getAttribute(s);
            }

            public Map<String, Object> getAttributes() {
                return securityIdentity.getAttributes();
            }

            public Set<Permission> getPermissions() {
                return securityIdentity.getPermissions();
            }

            public Uni<Boolean> checkPermission(Permission requiredPermission) {
                if (addPerms) {
                    for (Permission possessedPermission : permissions) {
                        if (!possessedPermission.implies(requiredPermission)) continue;
                        return Uni.createFrom().item((Object)true);
                    }
                }
                return securityIdentity.checkPermission(requiredPermission);
            }

            public boolean checkPermissionBlocking(Permission requiredPermission) {
                if (addPerms) {
                    for (Permission possessedPermission : permissions) {
                        if (!possessedPermission.implies(requiredPermission)) continue;
                        return true;
                    }
                }
                return securityIdentity.checkPermissionBlocking(requiredPermission);
            }
        };
    }
}

