/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.ListeningAddress;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class TestHostLauncher
implements ArtifactLauncher {
    private String previousHost;

    @Override
    public Optional<ListeningAddress> start() throws IOException {
        String protocol;
        int port;
        Config config = ConfigProvider.getConfig();
        this.previousHost = System.setProperty("quarkus.http.host", (String)config.getValue("quarkus.http.test-host", String.class));
        boolean testSslEnabled = config.getOptionalValue("quarkus.http.test-ssl-enabled", Boolean.TYPE).orElse(false);
        if (testSslEnabled) {
            port = ((OptionalInt)config.getValue("quarkus.http.test-ssl-port", OptionalInt.class)).orElse(8444);
            protocol = "https";
        } else {
            port = ((OptionalInt)config.getValue("quarkus.http.test-port", OptionalInt.class)).orElse(8081);
            protocol = "http";
        }
        return Optional.of(new ListeningAddress(port, protocol));
    }

    @Override
    public void close() throws IOException {
        if (this.previousHost != null) {
            System.setProperty("quarkus.http.host", this.previousHost);
        }
    }

    public void includeAsSysProps(Map systemProps) {
    }

    public void init(ArtifactLauncher.InitContext initContext) {
        throw new IllegalStateException("Should not be called");
    }

    @Override
    public ArtifactLauncher.LaunchResult runToCompletion(String[] args) {
        throw new IllegalStateException("Should not be called");
    }
}

