/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.common.runtime;

import io.quarkus.scheduler.DelayedExecution;
import io.quarkus.scheduler.FailedExecution;
import io.quarkus.scheduler.ScheduledJobPaused;
import io.quarkus.scheduler.ScheduledJobResumed;
import io.quarkus.scheduler.SchedulerPaused;
import io.quarkus.scheduler.SchedulerResumed;
import io.quarkus.scheduler.SkippedExecution;
import io.quarkus.scheduler.SuccessfulExecution;
import jakarta.enterprise.event.Event;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.jboss.logging.Logger;

public final class Events {
    private static final Logger LOG = Logger.getLogger(Events.class);
    public final Event<SkippedExecution> skippedExecution;
    public final Event<SuccessfulExecution> successExecution;
    public final Event<FailedExecution> failedExecution;
    public final Event<DelayedExecution> delayedExecution;
    public final Event<SchedulerPaused> schedulerPaused;
    public final Event<SchedulerResumed> schedulerResumed;
    public final Event<ScheduledJobPaused> scheduledJobPaused;
    public final Event<ScheduledJobResumed> scheduledJobResumed;

    public Events(Event<SkippedExecution> skippedExecution, Event<SuccessfulExecution> successExecution, Event<FailedExecution> failedExecution, Event<DelayedExecution> delayedExecution, Event<SchedulerPaused> schedulerPaused, Event<SchedulerResumed> schedulerResumed, Event<ScheduledJobPaused> scheduledJobPaused, Event<ScheduledJobResumed> scheduledJobResumed) {
        this.skippedExecution = skippedExecution;
        this.successExecution = successExecution;
        this.failedExecution = failedExecution;
        this.delayedExecution = delayedExecution;
        this.schedulerPaused = schedulerPaused;
        this.schedulerResumed = schedulerResumed;
        this.scheduledJobPaused = scheduledJobPaused;
        this.scheduledJobResumed = scheduledJobResumed;
    }

    public void fireSchedulerPaused() {
        Events.fire(this.schedulerPaused, SchedulerPaused.INSTANCE);
    }

    public void fireSchedulerResumed() {
        Events.fire(this.schedulerResumed, SchedulerResumed.INSTANCE);
    }

    public void fireScheduledJobPaused(ScheduledJobPaused payload) {
        Events.fire(this.scheduledJobPaused, payload);
    }

    public void fireScheduledJobResumed(ScheduledJobResumed payload) {
        Events.fire(this.scheduledJobResumed, payload);
    }

    public static <E> CompletionStage<E> fire(Event<E> event, E payload) {
        Objects.requireNonNull(payload);
        CompletionStage cs = event.fireAsync(payload);
        try {
            event.fire(payload);
        }
        catch (Exception e) {
            LOG.warnf("Error occurred while notifying observers of %s: %s", (Object)payload.getClass().getName(), (Object)e.getMessage());
        }
        return cs;
    }
}

