/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyInjectionReadyBuildItem;
import io.quarkus.resteasy.runtime.standalone.ResteasyStandaloneRecorder;
import io.quarkus.resteasy.server.common.deployment.ResteasyDeploymentBuildItem;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.core.deployment.InternalWebVertxBuildItem;
import io.quarkus.vertx.http.deployment.DefaultRouteBuildItem;
import io.quarkus.vertx.http.deployment.RequireVirtualHttpBuildItem;
import io.quarkus.vertx.http.runtime.HttpBuildTimeConfig;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.jar.JarEntry;

public class ResteasyStandaloneBuildStep {
    protected static final String META_INF_RESOURCES_SLASH = "META-INF/resources/";
    protected static final String META_INF_RESOURCES = "META-INF/resources";

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void staticInit(ResteasyStandaloneRecorder recorder, Capabilities capabilities, ResteasyDeploymentBuildItem deployment, ApplicationArchivesBuildItem applicationArchivesBuildItem, ResteasyInjectionReadyBuildItem resteasyInjectionReady, HttpBuildTimeConfig httpBuildTimeConfig, BuildProducer<ResteasyStandaloneBuildItem> standalone) throws Exception {
        if (capabilities.isCapabilityPresent("io.quarkus.servlet")) {
            return;
        }
        Set<String> knownPaths = this.getClasspathResources(applicationArchivesBuildItem);
        if (deployment != null) {
            String rootPath = deployment.getRootPath();
            if (!httpBuildTimeConfig.rootPath.equals("/")) {
                rootPath = httpBuildTimeConfig.rootPath + rootPath;
            }
            recorder.staticInit(deployment.getDeployment(), rootPath, knownPaths);
        } else if (!knownPaths.isEmpty()) {
            String rootPath = "/";
            if (!httpBuildTimeConfig.rootPath.equals("/")) {
                rootPath = httpBuildTimeConfig.rootPath;
            }
            recorder.staticInit(null, rootPath, knownPaths);
        }
        if (deployment != null || !knownPaths.isEmpty()) {
            standalone.produce((BuildItem)new ResteasyStandaloneBuildItem());
        }
    }

    private Set<String> getClasspathResources(ApplicationArchivesBuildItem applicationArchivesBuildItem) throws Exception {
        Path resource;
        final HashSet<String> knownPaths = new HashSet<String>();
        for (ApplicationArchive i : applicationArchivesBuildItem.getAllApplicationArchives()) {
            resource = i.getChildPath(META_INF_RESOURCES);
            if (resource == null || !Files.exists(resource, new LinkOption[0])) continue;
            Files.walk(resource, new FileVisitOption[0]).forEach(new Consumer<Path>(){

                @Override
                public void accept(Path path) {
                    if (resource.equals(path)) {
                        return;
                    }
                    Path rel = resource.relativize(path);
                    if (!Files.isDirectory(path, new LinkOption[0])) {
                        String file = rel.toString();
                        if (file.equals("index.html") || file.equals("index.htm")) {
                            knownPaths.add("/");
                        }
                        if (!file.startsWith("/")) {
                            file = "/" + file;
                        }
                        file = file.replace('\\', '/');
                        knownPaths.add(file);
                    }
                }
            });
        }
        Enumeration<URL> resources = this.getClass().getClassLoader().getResources(META_INF_RESOURCES);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            if (url.getProtocol().equals("jar")) {
                JarURLConnection jar = (JarURLConnection)url.openConnection();
                Enumeration<JarEntry> entries = jar.getJarFile().entries();
                while (entries.hasMoreElements()) {
                    String sub;
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(META_INF_RESOURCES_SLASH) || (sub = entry.getName().substring(META_INF_RESOURCES_SLASH.length())).isEmpty()) continue;
                    if (sub.equals("index.html") || sub.equals("index.htm")) {
                        knownPaths.add("/");
                    }
                    if (!sub.startsWith("/")) {
                        sub = "/" + sub;
                    }
                    knownPaths.add(sub);
                }
            }
            if (!url.getProtocol().equals("file") || (resource = Paths.get(url.toURI())) == null || !Files.exists(resource, new LinkOption[0])) continue;
            Files.walk(resource, new FileVisitOption[0]).forEach(new Consumer<Path>(){

                @Override
                public void accept(Path path) {
                    if (resource.equals(path)) {
                        return;
                    }
                    Path rel = resource.relativize(path);
                    if (!Files.isDirectory(path, new LinkOption[0])) {
                        String file = rel.toString();
                        if (file.equals("index.html") || file.equals("index.htm")) {
                            knownPaths.add("/");
                        }
                        if (!file.startsWith("/")) {
                            file = "/" + file;
                        }
                        file = file.replace('\\', '/');
                        knownPaths.add(file);
                    }
                }
            });
        }
        return knownPaths;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void boot(ShutdownContextBuildItem shutdown, ResteasyStandaloneRecorder recorder, BuildProducer<FeatureBuildItem> feature, BuildProducer<DefaultRouteBuildItem> routeProducer, InternalWebVertxBuildItem vertx, BeanContainerBuildItem beanContainer, ResteasyStandaloneBuildItem standalone, Optional<RequireVirtualHttpBuildItem> requireVirtual) throws Exception {
        if (standalone == null) {
            return;
        }
        feature.produce((BuildItem)new FeatureBuildItem("resteasy"));
        boolean isVirtual = requireVirtual.isPresent();
        Consumer ut = recorder.start(vertx.getVertx(), (ShutdownContext)shutdown, beanContainer.getValue(), isVirtual);
        routeProducer.produce((BuildItem)new DefaultRouteBuildItem(ut));
    }

    public static final class ResteasyStandaloneBuildItem
    extends SimpleBuildItem {
    }
}

