/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ClientProxy;
import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.oidc.common.OidcEndpoint;
import io.quarkus.oidc.common.OidcRequestContextProperties;
import io.quarkus.oidc.common.OidcRequestFilter;
import io.quarkus.oidc.common.OidcResponseFilter;
import io.quarkus.oidc.common.runtime.BlockingTaskRunner;
import io.quarkus.oidc.common.runtime.OidcClientRedirectException;
import io.quarkus.oidc.common.runtime.OidcEndpointAccessException;
import io.quarkus.oidc.common.runtime.OidcTlsSupport;
import io.quarkus.oidc.common.runtime.config.OidcClientCommonConfig;
import io.quarkus.oidc.common.runtime.config.OidcCommonConfig;
import io.quarkus.proxy.ProxyConfiguration;
import io.quarkus.proxy.ProxyConfigurationRegistry;
import io.quarkus.runtime.configuration.ConfigurationException;
import io.quarkus.runtime.util.ClassPathUtils;
import io.quarkus.tls.TlsConfiguration;
import io.quarkus.tls.runtime.config.TlsConfigUtils;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import io.smallrye.jwt.build.Jwt;
import io.smallrye.jwt.build.JwtSignatureBuilder;
import io.smallrye.jwt.util.KeyUtils;
import io.smallrye.jwt.util.ResourceUtils;
import io.smallrye.mutiny.Uni;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.KeyStoreOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.jboss.logging.Logger;

public class OidcCommonUtils {
    public static final Duration CONNECTION_BACKOFF_DURATION = Duration.ofSeconds(2L);
    public static final String LOCATION_RESPONSE_HEADER = String.valueOf(HttpHeaders.LOCATION);
    public static final String COOKIE_REQUEST_HEADER = String.valueOf(HttpHeaders.COOKIE);
    static final byte AMP = 38;
    static final byte EQ = 61;
    static final String HTTP_SCHEME = "http";
    private static final Logger LOG = Logger.getLogger(OidcCommonUtils.class);
    private static final BlockingTaskRunner<Void> VOID_BLOCKING_TASK_RUNNER = new BlockingTaskRunner();

    private OidcCommonUtils() {
    }

    public static void verifyEndpointUrl(String endpointUrl) {
        try {
            URI.create(endpointUrl).toURL();
        }
        catch (Throwable ex) {
            throw new ConfigurationException(String.format("'%s' is invalid", endpointUrl), ex);
        }
    }

    public static void verifyCommonConfiguration(OidcClientCommonConfig oidcConfig, boolean clientIdOptional, boolean isServerConfig) {
        String configPrefix;
        String string = configPrefix = isServerConfig ? "quarkus.oidc." : "quarkus.oidc-client.";
        if (!clientIdOptional && !oidcConfig.clientId().isPresent()) {
            throw new ConfigurationException(String.format("'%sclient-id' property must be configured", configPrefix));
        }
        OidcClientCommonConfig.Credentials creds = oidcConfig.credentials();
        if (creds.secret().isPresent() && creds.clientSecret().value().isPresent()) {
            throw new ConfigurationException(String.format("'%1$scredentials.secret' and '%1$scredentials.client-secret' properties are mutually exclusive", configPrefix));
        }
        if ((creds.secret().isPresent() || creds.clientSecret().value().isPresent()) && creds.jwt().secret().isPresent()) {
            throw new ConfigurationException(String.format("Use only '%1$scredentials.secret' or '%1$scredentials.client-secret' or '%1$scredentials.jwt.secret' property", configPrefix));
        }
        OidcClientCommonConfig.Credentials.Jwt jwt = creds.jwt();
        if (jwt.source() == OidcClientCommonConfig.Credentials.Jwt.Source.BEARER) {
            if (isServerConfig && jwt.tokenPath().isEmpty()) {
                throw new ConfigurationException("Bearer token path must be set when the JWT source is a bearer token");
            }
        } else if (jwt.tokenPath().isPresent()) {
            throw new ConfigurationException("Bearer token path can only be set when the JWT source is a bearer token");
        }
    }

    public static String prependSlash(String path) {
        return !path.startsWith("/") ? "/" + path : path;
    }

    public static io.vertx.mutiny.core.buffer.Buffer encodeForm(MultiMap form) {
        return OidcCommonUtils.encodeForm(form, io.vertx.mutiny.core.buffer.Buffer.buffer());
    }

    public static io.vertx.mutiny.core.buffer.Buffer encodeForm(MultiMap form, io.vertx.mutiny.core.buffer.Buffer buffer) {
        for (Map.Entry entry : form) {
            if (buffer.length() != 0) {
                buffer.appendByte((byte)38);
            }
            buffer.appendString((String)entry.getKey());
            buffer.appendByte((byte)61);
            buffer.appendString(OidcCommonUtils.urlEncode((String)entry.getValue()));
        }
        return buffer;
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void setHttpClientOptions(OidcCommonConfig oidcConfig, HttpClientOptions options, OidcTlsSupport.TlsConfigSupport tlsSupport, ProxyConfigurationRegistry proxyConfigurationRegistry) {
        boolean trustAll;
        OptionalInt maxPoolSize;
        Optional<ProxyOptions> proxyOpt = OidcCommonUtils.toProxyOptions(oidcConfig.proxy(), proxyConfigurationRegistry);
        if (proxyOpt.isPresent()) {
            options.setProxyOptions(proxyOpt.get());
        }
        if ((maxPoolSize = oidcConfig.maxPoolSize()).isPresent()) {
            options.setMaxPoolSize(maxPoolSize.getAsInt());
        }
        options.setConnectTimeout((int)oidcConfig.connectionTimeout().toMillis());
        if (tlsSupport.useTlsRegistry()) {
            TlsConfigUtils.configure((HttpClientOptions)options, (TlsConfiguration)tlsSupport.getTlsConfig());
            return;
        }
        boolean bl = oidcConfig.tls().verification().isPresent() ? oidcConfig.tls().verification().get() == OidcCommonConfig.Tls.Verification.NONE : (trustAll = tlsSupport.isGlobalTrustAll());
        if (trustAll) {
            options.setTrustAll(true);
            options.setVerifyHost(false);
        } else if (oidcConfig.tls().trustStoreFile().isPresent()) {
            try {
                byte[] trustStoreData = OidcCommonUtils.getFileContent(oidcConfig.tls().trustStoreFile().get());
                KeyStoreOptions trustStoreOptions = new KeyStoreOptions().setPassword(oidcConfig.tls().trustStorePassword().orElse("password")).setAlias((String)oidcConfig.tls().trustStoreCertAlias().orElse(null)).setValue(Buffer.buffer((byte[])trustStoreData)).setType(OidcCommonUtils.getKeyStoreType(oidcConfig.tls().trustStoreFileType(), oidcConfig.tls().trustStoreFile().get())).setProvider((String)oidcConfig.tls().trustStoreProvider().orElse(null));
                options.setTrustOptions((TrustOptions)trustStoreOptions);
                if (OidcCommonConfig.Tls.Verification.CERTIFICATE_VALIDATION == oidcConfig.tls().verification().orElse(OidcCommonConfig.Tls.Verification.REQUIRED)) {
                    options.setVerifyHost(false);
                }
            }
            catch (IOException ex) {
                throw new ConfigurationException(String.format("OIDC truststore file %s does not exist or can not be read", oidcConfig.tls().trustStoreFile().get()), (Throwable)ex);
            }
        }
        if (oidcConfig.tls().keyStoreFile().isPresent()) {
            try {
                byte[] keyStoreData = OidcCommonUtils.getFileContent(oidcConfig.tls().keyStoreFile().get());
                KeyStoreOptions keyStoreOptions = new KeyStoreOptions().setAlias((String)oidcConfig.tls().keyStoreKeyAlias().orElse(null)).setAliasPassword((String)oidcConfig.tls().keyStoreKeyPassword().orElse(null)).setValue(Buffer.buffer((byte[])keyStoreData)).setType(OidcCommonUtils.getKeyStoreType(oidcConfig.tls().keyStoreFileType(), oidcConfig.tls().keyStoreFile().get())).setProvider((String)oidcConfig.tls().keyStoreProvider().orElse(null));
                if (oidcConfig.tls().keyStorePassword().isPresent()) {
                    keyStoreOptions.setPassword(oidcConfig.tls().keyStorePassword().get());
                }
                options.setKeyCertOptions((KeyCertOptions)keyStoreOptions);
            }
            catch (IOException ex) {
                throw new ConfigurationException(String.format("OIDC keystore file %s does not exist or can not be read", oidcConfig.tls().keyStoreFile().get()), (Throwable)ex);
            }
        }
    }

    public static String getKeyStoreType(Optional<String> fileType, Path storePath) {
        if (fileType.isPresent()) {
            return fileType.get().toUpperCase();
        }
        return OidcCommonUtils.inferKeyStoreTypeFromFileExtension(storePath.toString());
    }

    private static String inferKeyStoreTypeFromFileExtension(String pathName) {
        if (pathName.endsWith(".p12") || pathName.endsWith(".pkcs12") || pathName.endsWith(".pfx")) {
            return "PKCS12";
        }
        return "JKS";
    }

    public static String getAuthServerUrl(OidcCommonConfig oidcConfig) {
        return OidcCommonUtils.removeLastPathSeparator(oidcConfig.authServerUrl().get());
    }

    private static String removeAudienceTrailingSlash(OidcClientCommonConfig.Credentials.Jwt jwtConfig, String value) {
        return !jwtConfig.keepAudienceTrailingSlash() ? OidcCommonUtils.removeLastPathSeparator(value) : value;
    }

    private static String removeLastPathSeparator(String value) {
        return value.endsWith("/") ? value.substring(0, value.length() - 1) : value;
    }

    public static String getOidcEndpointUrl(String authServerUrl, Optional<String> endpointPath) {
        if (endpointPath != null && endpointPath.isPresent()) {
            return OidcCommonUtils.isAbsoluteUrl(endpointPath) ? endpointPath.get() : authServerUrl + OidcCommonUtils.prependSlash(endpointPath.get());
        }
        return null;
    }

    public static boolean isAbsoluteUrl(Optional<String> endpointUrl) {
        return endpointUrl.isPresent() && endpointUrl.get().startsWith(HTTP_SCHEME);
    }

    private static long getConnectionDelay(OidcCommonConfig oidcConfig) {
        return oidcConfig.connectionDelay().isPresent() ? oidcConfig.connectionDelay().get().getSeconds() : 0L;
    }

    public static long getConnectionDelayInMillis(OidcCommonConfig oidcConfig) {
        long connectionRetryCount;
        long connectionDelayInSecs = OidcCommonUtils.getConnectionDelay(oidcConfig);
        long l = connectionRetryCount = connectionDelayInSecs > 1L ? connectionDelayInSecs / 2L : 1L;
        if (connectionRetryCount > 1L) {
            LOG.infof("Connecting to OpenId Connect Provider for up to %d times every 2 seconds", (Object)connectionRetryCount);
        }
        return connectionDelayInSecs * 1000L;
    }

    public static Optional<ProxyOptions> toProxyOptions(OidcCommonConfig.Proxy oidcProxyConfig, ProxyConfigurationRegistry proxyConfigurationRegistry) {
        Optional proxyConnectTimeoutProperty;
        Optional passwordProperty;
        Optional usernameProperty;
        int portProperty;
        String hostProperty;
        if (oidcProxyConfig.host().isEmpty() && oidcProxyConfig.proxyConfigurationName().isEmpty()) {
            return Optional.empty();
        }
        if (oidcProxyConfig.proxyConfigurationName().isPresent()) {
            Optional maybeProxyConfig = proxyConfigurationRegistry.get(oidcProxyConfig.proxyConfigurationName());
            if (maybeProxyConfig.isEmpty()) {
                throw new ConfigurationException("Cannot find the Proxy registry configuration '%s'".formatted(oidcProxyConfig.proxyConfigurationName().get()));
            }
            ProxyConfiguration proxyRegistryConfig = ((ProxyConfiguration)maybeProxyConfig.get()).assertHttpType();
            hostProperty = proxyRegistryConfig.host();
            portProperty = proxyRegistryConfig.port();
            usernameProperty = proxyRegistryConfig.username();
            passwordProperty = proxyRegistryConfig.password();
            proxyConnectTimeoutProperty = proxyRegistryConfig.proxyConnectTimeout();
            if (proxyRegistryConfig.nonProxyHosts().isPresent()) {
                throw new ConfigurationException("The OIDC proxy configuration currently does not support the 'quarkus.proxy.\"" + oidcProxyConfig.proxyConfigurationName().get() + "\".non-proxy-hosts' property");
            }
        } else {
            hostProperty = oidcProxyConfig.host().get();
            portProperty = oidcProxyConfig.port();
            usernameProperty = oidcProxyConfig.username();
            passwordProperty = oidcProxyConfig.password();
            proxyConnectTimeoutProperty = Optional.empty();
        }
        JsonObject jsonOptions = new JsonObject();
        String host = URI.create(hostProperty).getHost();
        if (host == null) {
            host = hostProperty;
        }
        jsonOptions.put("host", (Object)host);
        jsonOptions.put("port", (Object)portProperty);
        if (usernameProperty.isPresent()) {
            jsonOptions.put("username", usernameProperty.get());
        }
        if (passwordProperty.isPresent()) {
            jsonOptions.put("password", passwordProperty.get());
        }
        if (proxyConnectTimeoutProperty.isPresent()) {
            jsonOptions.put("connectTimeout", proxyConnectTimeoutProperty.get());
        }
        return Optional.of(new ProxyOptions(jsonOptions));
    }

    public static String formatConnectionErrorMessage(String authServerUrlString) {
        return String.format("OIDC server is not available at the '%s' URL. Please make sure it is correct. Note it has to end with a realm value if you work with Keycloak, for example: 'https://localhost:8180/auth/realms/quarkus'", authServerUrlString);
    }

    public static boolean isClientSecretBasicAuthRequired(OidcClientCommonConfig.Credentials creds) {
        return creds.secret().isPresent() || (creds.clientSecret().value().isPresent() || creds.clientSecret().provider().key().isPresent()) && OidcCommonUtils.clientSecretMethod(creds) == OidcClientCommonConfig.Credentials.Secret.Method.BASIC;
    }

    public static boolean isClientJwtAuthRequired(OidcClientCommonConfig.Credentials creds, boolean server) {
        HashSet<String> props = new HashSet<String>();
        if (creds.jwt().secret().isPresent()) {
            props.add(".credentials.jwt.secret");
        }
        if (creds.jwt().secretProvider().key().isPresent()) {
            props.add(".credentials.jwt.secret-provider.key");
        }
        if (creds.jwt().key().isPresent()) {
            props.add(".credentials.jwt.key");
        }
        if (creds.jwt().keyFile().isPresent()) {
            props.add(".credentials.jwt.key-file");
        }
        if (creds.jwt().keyStoreFile().isPresent()) {
            props.add(".credentials.jwt.key-store-file");
        }
        if (props.size() > 1) {
            String prefix = server ? "quarkus.oidc" : "quarkus.oidc-client";
            throw new ConfigurationException("Only a single OIDC JWT credential key property can be configured, but you have configured: %s".formatted(props.stream().map(p -> prefix + p).collect(Collectors.joining(","))));
        }
        return props.size() == 1;
    }

    public static boolean isClientSecretPostAuthRequired(OidcClientCommonConfig.Credentials creds) {
        return (creds.clientSecret().value().isPresent() || creds.clientSecret().provider().key().isPresent()) && OidcCommonUtils.clientSecretMethod(creds) == OidcClientCommonConfig.Credentials.Secret.Method.POST;
    }

    public static boolean isClientSecretPostJwtAuthRequired(OidcClientCommonConfig.Credentials creds) {
        return OidcCommonUtils.clientSecretMethod(creds) == OidcClientCommonConfig.Credentials.Secret.Method.POST_JWT;
    }

    public static boolean isJwtAssertion(OidcClientCommonConfig.Credentials creds) {
        return creds.jwt().assertion();
    }

    public static Uni<String> clientSecret(OidcClientCommonConfig.Credentials creds) {
        if (creds.secret().isPresent()) {
            return Uni.createFrom().item((Object)creds.secret().get());
        }
        if (creds.clientSecret().value().isPresent()) {
            return Uni.createFrom().item((Object)creds.clientSecret().value().get());
        }
        return OidcCommonUtils.fromCredentialsProvider(creds.clientSecret().provider());
    }

    public static Uni<String> jwtSecret(OidcClientCommonConfig.Credentials creds) {
        if (creds.jwt().secret().isPresent()) {
            return Uni.createFrom().item((Object)creds.jwt().secret().get());
        }
        return OidcCommonUtils.fromCredentialsProvider(creds.jwt().secretProvider());
    }

    public static SecretKey generateSecretKey() throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256);
        return keyGenerator.generateKey();
    }

    public static OidcClientCommonConfig.Credentials.Secret.Method clientSecretMethod(OidcClientCommonConfig.Credentials creds) {
        return creds.clientSecret().method().orElseGet(() -> OidcClientCommonConfig.Credentials.Secret.Method.BASIC);
    }

    private static Uni<String> fromCredentialsProvider(OidcClientCommonConfig.Credentials.Provider provider) {
        if (provider.key().isEmpty()) {
            return Uni.createFrom().nullItem();
        }
        return CredentialsProviderFinder.find((String)provider.name().orElse(null)).getCredentialsAsync((String)provider.keyringName().orElse(null)).onItem().ifNotNull().transform(credentials -> (String)credentials.get(provider.key().get()));
    }

    public static Uni<Key> clientJwtKey(OidcClientCommonConfig.Credentials creds) {
        Key key;
        block9: {
            if (creds.jwt().secret().isPresent() || creds.jwt().secretProvider().key().isPresent()) {
                return OidcCommonUtils.jwtSecret(creds).onItem().ifNotNull().transform(KeyUtils::createSecretKeyFromSecret);
            }
            key = null;
            try {
                if (creds.jwt().key().isPresent()) {
                    key = KeyUtils.tryAsPemSigningPrivateKey((String)creds.jwt().key().get(), (SignatureAlgorithm)OidcCommonUtils.getSignatureAlgorithm(creds, SignatureAlgorithm.RS256));
                    break block9;
                }
                if (creds.jwt().keyFile().isPresent()) {
                    key = KeyUtils.readSigningKey((String)creds.jwt().keyFile().get(), (String)creds.jwt().keyId().orElse(null), (SignatureAlgorithm)OidcCommonUtils.getSignatureAlgorithm(creds, SignatureAlgorithm.RS256));
                    break block9;
                }
                if (!creds.jwt().keyStoreFile().isPresent()) break block9;
                String keyStoreFile = creds.jwt().keyStoreFile().get();
                KeyStore ks = KeyStore.getInstance(OidcCommonUtils.inferKeyStoreTypeFromFileExtension(keyStoreFile));
                InputStream is = ResourceUtils.getResourceStream((String)keyStoreFile);
                if (creds.jwt().keyStorePassword().isPresent()) {
                    ks.load(is, creds.jwt().keyStorePassword().get().toCharArray());
                } else {
                    ks.load(is, null);
                }
                if (creds.jwt().keyPassword().isPresent()) {
                    key = ks.getKey(creds.jwt().keyId().get(), creds.jwt().keyPassword().get().toCharArray());
                    break block9;
                }
                throw new ConfigurationException("When using a key store, the `quarkus.oidc-client.credentials.jwt.key-password` property must be set");
            }
            catch (Exception ex) {
                throw new ConfigurationException("Key can not be loaded", (Throwable)ex);
            }
        }
        if (key == null) {
            throw new ConfigurationException("Key is null");
        }
        return Uni.createFrom().item((Object)key);
    }

    public static String signJwtWithKey(OidcClientCommonConfig oidcConfig, String tokenRequestUri, Key key) {
        SignatureAlgorithm signatureAlgorithm;
        JwtSignatureBuilder jwtSignatureBuilder = Jwt.claims(OidcCommonUtils.additionalClaims(oidcConfig.credentials().jwt().claims())).issuer(oidcConfig.credentials().jwt().issuer().orElse(oidcConfig.clientId().get())).subject(oidcConfig.credentials().jwt().subject().orElse(oidcConfig.clientId().get())).audience(oidcConfig.credentials().jwt().audience().isPresent() ? OidcCommonUtils.removeAudienceTrailingSlash(oidcConfig.credentials().jwt(), oidcConfig.credentials().jwt().audience().get()) : tokenRequestUri).expiresIn((long)oidcConfig.credentials().jwt().lifespan()).jws();
        if (oidcConfig.credentials().jwt().tokenKeyId().isPresent()) {
            jwtSignatureBuilder.keyId(oidcConfig.credentials().jwt().tokenKeyId().get());
        }
        if ((signatureAlgorithm = OidcCommonUtils.getSignatureAlgorithm(oidcConfig.credentials(), null)) != null) {
            jwtSignatureBuilder.algorithm(signatureAlgorithm);
        }
        if (key instanceof SecretKey) {
            return jwtSignatureBuilder.sign((SecretKey)key);
        }
        return jwtSignatureBuilder.sign((PrivateKey)key);
    }

    private static Map<String, Object> additionalClaims(Map<String, String> claims) {
        return claims;
    }

    private static SignatureAlgorithm getSignatureAlgorithm(OidcClientCommonConfig.Credentials credentials, SignatureAlgorithm defaultAlgorithm) {
        if (credentials.jwt().signatureAlgorithm().isPresent()) {
            try {
                return SignatureAlgorithm.fromAlgorithm((String)credentials.jwt().signatureAlgorithm().get());
            }
            catch (Exception ex) {
                throw new ConfigurationException("Unsupported signature algorithm");
            }
        }
        return defaultAlgorithm;
    }

    public static void verifyConfigurationId(String defaultId, String configKey, Optional<String> configId) {
        if (configKey.equals(defaultId)) {
            throw new ConfigurationException("configuration id '" + configKey + "' duplicates the default configuration id");
        }
        if (configId.isPresent() && !configKey.equals(configId.get())) {
            throw new ConfigurationException("Configuration has 2 different id values: '" + configKey + "' and '" + configId.get() + "'");
        }
    }

    public static String initClientSecretBasicAuth(OidcClientCommonConfig oidcConfig, String clientSecret) {
        if (clientSecret != null && OidcCommonUtils.isClientSecretBasicAuthRequired(oidcConfig.credentials())) {
            return OidcCommonUtils.basicSchemeValue(oidcConfig.clientId().get(), clientSecret);
        }
        return null;
    }

    public static String basicSchemeValue(String name, String secret) {
        return "Basic " + Base64.getEncoder().encodeToString((name + ":" + secret).getBytes(StandardCharsets.UTF_8));
    }

    public static Uni<Key> initClientJwtKey(OidcClientCommonConfig oidcConfig, boolean server) {
        if (OidcCommonUtils.isClientJwtAuthRequired(oidcConfig.credentials(), server)) {
            return OidcCommonUtils.clientJwtKey(oidcConfig.credentials());
        }
        return Uni.createFrom().nullItem();
    }

    public static Predicate<? super Throwable> oidcEndpointNotAvailable() {
        return t -> t instanceof SocketException || t instanceof OidcEndpointAccessException && ((OidcEndpointAccessException)t).getErrorStatus() == 404;
    }

    public static Predicate<? super Throwable> validOidcClientRedirect(String originalUri) {
        return t -> t instanceof OidcClientRedirectException && OidcCommonUtils.isValidOidcClientRedirectRequest((OidcClientRedirectException)t, originalUri);
    }

    private static boolean isValidOidcClientRedirectRequest(OidcClientRedirectException ex, String originalUrl) {
        if (!originalUrl.equals(ex.getLocation())) {
            LOG.warnf("Redirect is only allowed to %s but redirect to %s is requested", (Object)originalUrl, (Object)ex.getLocation());
            return false;
        }
        if (ex.getCookies().isEmpty()) {
            LOG.warnf("Redirect is requested to %s but no cookies are set", (Object)originalUrl);
            return false;
        }
        LOG.debugf("Single redirect to %s with cookies is approved", (Object)originalUrl);
        return true;
    }

    public static Uni<JsonObject> discoverMetadata(final WebClient client, final Map<OidcEndpoint.Type, List<OidcRequestFilter>> requestFilters, OidcRequestContextProperties contextProperties, final Map<OidcEndpoint.Type, List<OidcResponseFilter>> responseFilters, String authServerUrl, final long connectionDelayInMillisecs, final Vertx vertx, final boolean blockingDnsLookup) {
        final String discoveryUrl = OidcCommonUtils.getDiscoveryUri(authServerUrl);
        final OidcRequestContextProperties requestProps = requestFilters.isEmpty() ? null : OidcCommonUtils.getDiscoveryRequestProps(contextProperties, discoveryUrl);
        return OidcCommonUtils.doDiscoverMetadata(client, requestFilters, contextProperties, responseFilters, discoveryUrl, connectionDelayInMillisecs, vertx, blockingDnsLookup, List.of()).onFailure(OidcCommonUtils.validOidcClientRedirect(discoveryUrl)).recoverWithUni((Function)new Function<Throwable, Uni<? extends JsonObject>>(){

            @Override
            public Uni<JsonObject> apply(Throwable t) {
                OidcClientRedirectException ex = (OidcClientRedirectException)t;
                return OidcCommonUtils.doDiscoverMetadata(client, requestFilters, requestProps, responseFilters, discoveryUrl, connectionDelayInMillisecs, vertx, blockingDnsLookup, ex.getCookies());
            }
        }).onFailure().transform(t -> {
            LOG.warn((Object)"OIDC Server is not available:", t.getCause() != null ? t.getCause() : t);
            return new RuntimeException("OIDC Server is not available");
        });
    }

    public static Uni<JsonObject> doDiscoverMetadata(WebClient client, Map<OidcEndpoint.Type, List<OidcRequestFilter>> requestFilters, OidcRequestContextProperties requestProps, Map<OidcEndpoint.Type, List<OidcResponseFilter>> responseFilters, String discoveryUrl, long connectionDelayInMillisecs, Vertx vertx, boolean blockingDnsLookup, List<String> cookies) {
        HttpRequest request = client.getAbs(discoveryUrl);
        if (!cookies.isEmpty()) {
            request.putHeader(COOKIE_REQUEST_HEADER, cookies);
        }
        return OidcCommonUtils.applyRequestFilters(requestFilters, OidcEndpoint.Type.DISCOVERY, (HttpRequest<io.vertx.mutiny.core.buffer.Buffer>)request, requestProps, null).chain(() -> OidcCommonUtils.sendRequest(vertx, (HttpRequest<io.vertx.mutiny.core.buffer.Buffer>)request, blockingDnsLookup)).flatMap(resp -> OidcCommonUtils.filterHttpResponse(requestProps, (HttpResponse<io.vertx.mutiny.core.buffer.Buffer>)resp, responseFilters, OidcEndpoint.Type.DISCOVERY).map(buffer -> {
            String errorMessage;
            if (resp.statusCode() == 200) {
                JsonObject discoveredJson = buffer.toJsonObject();
                LOG.debugf("Discovered OIDC metadata: %s", (Object)discoveredJson);
                return discoveredJson;
            }
            if (resp.statusCode() == 302) {
                throw OidcCommonUtils.createOidcClientRedirectException((HttpResponse<io.vertx.mutiny.core.buffer.Buffer>)resp);
            }
            String string = errorMessage = buffer != null ? buffer.toString() : null;
            if (errorMessage != null && !errorMessage.isEmpty()) {
                LOG.warnf("Discovery request %s has failed, status code: %d, error message: %s", (Object)discoveryUrl, (Object)resp.statusCode(), (Object)errorMessage);
            } else {
                LOG.warnf("Discovery request %s has failed, status code: %d", (Object)discoveryUrl, (Object)resp.statusCode());
            }
            throw new OidcEndpointAccessException(resp.statusCode());
        })).onFailure(OidcCommonUtils.oidcEndpointNotAvailable()).retry().withBackOff(CONNECTION_BACKOFF_DURATION, CONNECTION_BACKOFF_DURATION).expireIn(connectionDelayInMillisecs);
    }

    public static OidcClientRedirectException createOidcClientRedirectException(HttpResponse<io.vertx.mutiny.core.buffer.Buffer> resp) {
        LOG.debug((Object)"OIDC client redirect is requested");
        return new OidcClientRedirectException(resp.getHeader(LOCATION_RESPONSE_HEADER), resp.cookies());
    }

    private static OidcRequestContextProperties getDiscoveryRequestProps(OidcRequestContextProperties contextProperties, String discoveryUrl) {
        HashMap<String, Object> newProperties = contextProperties == null ? new HashMap<String, Object>() : new HashMap<String, Object>(contextProperties.getAll());
        newProperties.put(OidcRequestContextProperties.DISCOVERY_ENDPOINT, discoveryUrl);
        return new OidcRequestContextProperties(newProperties);
    }

    public static Uni<io.vertx.mutiny.core.buffer.Buffer> filterHttpResponse(OidcRequestContextProperties requestProps, HttpResponse<io.vertx.mutiny.core.buffer.Buffer> resp, Map<OidcEndpoint.Type, List<OidcResponseFilter>> responseFilters, OidcEndpoint.Type type) {
        List<OidcResponseFilter> matchingResponseFilters;
        io.vertx.mutiny.core.buffer.Buffer responseBody = (io.vertx.mutiny.core.buffer.Buffer)resp.body();
        if (!responseFilters.isEmpty() && !(matchingResponseFilters = OidcCommonUtils.getMatchingOidcResponseFilters(responseFilters, type)).isEmpty()) {
            OidcResponseFilter.OidcResponseFilterContext context = new OidcResponseFilter.OidcResponseFilterContext(requestProps, resp.statusCode(), resp.headers(), responseBody);
            return OidcCommonUtils.applyResponseFilters(matchingResponseFilters, 0, context).replaceWith(() -> OidcCommonUtils.getResponseBuffer(requestProps, responseBody));
        }
        return Uni.createFrom().item((Object)responseBody);
    }

    private static Uni<Void> applyResponseFilters(List<OidcResponseFilter> responseFilters, int index, OidcResponseFilter.OidcResponseFilterContext context) {
        if (responseFilters.size() == index) {
            return Uni.createFrom().voidItem();
        }
        return responseFilters.get(index).filter(context).chain(() -> OidcCommonUtils.applyResponseFilters(responseFilters, index + 1, context));
    }

    public static io.vertx.mutiny.core.buffer.Buffer getRequestBuffer(OidcRequestContextProperties requestProps, io.vertx.mutiny.core.buffer.Buffer buffer) {
        if (requestProps == null) {
            return buffer;
        }
        io.vertx.mutiny.core.buffer.Buffer updatedRequestBody = (io.vertx.mutiny.core.buffer.Buffer)requestProps.get(OidcRequestContextProperties.REQUEST_BODY);
        return updatedRequestBody == null ? buffer : updatedRequestBody;
    }

    public static io.vertx.mutiny.core.buffer.Buffer getResponseBuffer(OidcRequestContextProperties requestProps, io.vertx.mutiny.core.buffer.Buffer buffer) {
        if (requestProps == null) {
            return buffer;
        }
        io.vertx.mutiny.core.buffer.Buffer updatedResponseBody = (io.vertx.mutiny.core.buffer.Buffer)requestProps.get(OidcRequestContextProperties.RESPONSE_BODY);
        return updatedResponseBody == null ? buffer : updatedResponseBody;
    }

    public static String getDiscoveryUri(String authServerUrl) {
        return authServerUrl + "/.well-known/openid-configuration";
    }

    private static byte[] getFileContent(Path path) throws IOException {
        byte[] data;
        InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(ClassPathUtils.toResourceName((Path)path));
        if (resource != null) {
            try (InputStream is = resource;){
                data = OidcCommonUtils.doRead(is);
            }
        }
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            data = OidcCommonUtils.doRead(is);
        }
        return data;
    }

    private static byte[] doRead(InputStream is) throws IOException {
        int r;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((r = is.read(buf)) > 0) {
            out.write(buf, 0, r);
        }
        return out.toByteArray();
    }

    public static Map<OidcEndpoint.Type, List<OidcRequestFilter>> getOidcRequestFilters(Predicate<Class<?>> appliesTo) {
        return OidcCommonUtils.getOidcFilters(OidcRequestFilter.class, appliesTo);
    }

    public static Map<OidcEndpoint.Type, List<OidcResponseFilter>> getOidcResponseFilters(Predicate<Class<?>> appliesTo) {
        return OidcCommonUtils.getOidcFilters(OidcResponseFilter.class, appliesTo);
    }

    public static Map<OidcEndpoint.Type, List<OidcRequestFilter>> getOidcRequestFilters() {
        return OidcCommonUtils.getOidcFilters(OidcRequestFilter.class, null);
    }

    public static Map<OidcEndpoint.Type, List<OidcResponseFilter>> getOidcResponseFilters() {
        return OidcCommonUtils.getOidcFilters(OidcResponseFilter.class, null);
    }

    private static <T> Map<OidcEndpoint.Type, List<T>> getOidcFilters(Class<T> filterClass, Predicate<Class<?>> appliesTo) {
        ArcContainer container = Arc.container();
        if (container != null) {
            HashMap<OidcEndpoint.Type, List<T>> map = new HashMap<OidcEndpoint.Type, List<T>>();
            for (Object filter : container.listAll(filterClass, new Annotation[0]).stream().map(handle -> handle.get()).collect(Collectors.toList())) {
                Class<?> actualBeanClass = ClientProxy.unwrap(filter).getClass();
                if (appliesTo != null && !appliesTo.test(actualBeanClass)) continue;
                OidcEndpoint endpoint = actualBeanClass.getAnnotation(OidcEndpoint.class);
                if (endpoint != null) {
                    for (OidcEndpoint.Type type : endpoint.value()) {
                        map.computeIfAbsent(type, k -> new ArrayList()).add(filter);
                    }
                    continue;
                }
                map.computeIfAbsent(OidcEndpoint.Type.ALL, k -> new ArrayList()).add(filter);
            }
            return map;
        }
        return Map.of();
    }

    public static Uni<HttpRequest<io.vertx.mutiny.core.buffer.Buffer>> filterHttpRequest(OidcRequestContextProperties requestProps, HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request, io.vertx.mutiny.core.buffer.Buffer body, Map<OidcEndpoint.Type, List<OidcRequestFilter>> requestFilters, OidcEndpoint.Type type) {
        return OidcCommonUtils.applyRequestFilters(requestFilters, type, request, requestProps, body).replaceWith(request);
    }

    private static Uni<Void> applyRequestFilters(Map<OidcEndpoint.Type, List<OidcRequestFilter>> requestFilters, OidcEndpoint.Type type, HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request, OidcRequestContextProperties requestProps, io.vertx.mutiny.core.buffer.Buffer body) {
        if (!requestFilters.isEmpty()) {
            OidcRequestFilter.OidcRequestFilterContext context = new OidcRequestFilter.OidcRequestFilterContext(request, body, requestProps);
            List<OidcRequestFilter> matchingRequestFilters = OidcCommonUtils.getMatchingOidcRequestFilters(requestFilters, type);
            if (!matchingRequestFilters.isEmpty()) {
                return OidcCommonUtils.applyRequestFilters(matchingRequestFilters, 0, context);
            }
        }
        return Uni.createFrom().voidItem();
    }

    private static Uni<Void> applyRequestFilters(List<OidcRequestFilter> requestFilters, int index, OidcRequestFilter.OidcRequestFilterContext context) {
        if (requestFilters.size() == index) {
            return Uni.createFrom().voidItem();
        }
        return requestFilters.get(index).filter(context).chain(() -> OidcCommonUtils.applyRequestFilters(requestFilters, index + 1, context));
    }

    public static List<OidcRequestFilter> getMatchingOidcRequestFilters(Map<OidcEndpoint.Type, List<OidcRequestFilter>> filters, OidcEndpoint.Type type) {
        return OidcCommonUtils.getMatchingOidcFilters(filters, type);
    }

    public static List<OidcResponseFilter> getMatchingOidcResponseFilters(Map<OidcEndpoint.Type, List<OidcResponseFilter>> filters, OidcEndpoint.Type type) {
        return OidcCommonUtils.getMatchingOidcFilters(filters, type);
    }

    private static <T> List<T> getMatchingOidcFilters(Map<OidcEndpoint.Type, List<T>> filters, OidcEndpoint.Type type) {
        List<T> typeSpecific = filters.get((Object)type);
        List<T> all = filters.get((Object)OidcEndpoint.Type.ALL);
        if (typeSpecific == null && all == null) {
            return List.of();
        }
        if (typeSpecific != null && all == null) {
            return typeSpecific;
        }
        if (typeSpecific == null && all != null) {
            return all;
        }
        ArrayList<T> combined = new ArrayList<T>(typeSpecific.size() + all.size());
        combined.addAll(typeSpecific);
        combined.addAll(all);
        return combined;
    }

    public static Uni<HttpResponse<io.vertx.mutiny.core.buffer.Buffer>> sendRequest(io.vertx.core.Vertx vertx, HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request, boolean blockingDnsLookup) {
        if (blockingDnsLookup) {
            return OidcCommonUtils.sendRequest(new Vertx(vertx), request, true);
        }
        return request.send();
    }

    public static Uni<HttpResponse<io.vertx.mutiny.core.buffer.Buffer>> sendRequest(Vertx vertx, final HttpRequest<io.vertx.mutiny.core.buffer.Buffer> request, boolean blockingDnsLookup) {
        if (blockingDnsLookup) {
            return vertx.executeBlocking((Callable)new Callable<Void>(){

                @Override
                public Void call() {
                    try {
                        InetAddress.getByName(request.host());
                    }
                    catch (UnknownHostException e) {
                        throw new RuntimeException(e);
                    }
                    return null;
                }
            }).flatMap((Function)new Function<Void, Uni<? extends HttpResponse<io.vertx.mutiny.core.buffer.Buffer>>>(){

                @Override
                public Uni<? extends HttpResponse<io.vertx.mutiny.core.buffer.Buffer>> apply(Void unused) {
                    return request.send();
                }
            });
        }
        return request.send();
    }

    public static JsonObject decodeJwtContent(String jwt) {
        String encodedContent = OidcCommonUtils.getJwtContentPart(jwt);
        if (encodedContent == null) {
            return null;
        }
        return OidcCommonUtils.decodeAsJsonObject(encodedContent);
    }

    public static String getJwtContentPart(String jwt) {
        StringTokenizer tokens = new StringTokenizer(jwt, ".");
        tokens.nextToken();
        if (!tokens.hasMoreTokens()) {
            return null;
        }
        String encodedContent = tokens.nextToken();
        if (tokens.countTokens() != 1) {
            return null;
        }
        return encodedContent;
    }

    public static String base64UrlDecode(String encodedContent) {
        return new String(Base64.getUrlDecoder().decode(encodedContent), StandardCharsets.UTF_8);
    }

    public static String base64UrlEncode(byte[] bytes) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    public static JsonObject decodeAsJsonObject(String encodedContent) {
        String json = null;
        try {
            json = OidcCommonUtils.base64UrlDecode(encodedContent);
        }
        catch (IllegalArgumentException ex) {
            LOG.debugf("Invalid Base64URL content: %s", (Object)encodedContent);
            return null;
        }
        try {
            return new JsonObject(json);
        }
        catch (DecodeException ex) {
            LOG.debugf("Invalid JSON content: %s", (Object)json);
            return null;
        }
    }

    public static Uni<Void> runBlocking(Runnable runnable) {
        return VOID_BLOCKING_TASK_RUNNER.runBlocking(() -> {
            runnable.run();
            return null;
        });
    }
}

