/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.launcher;

import io.quarkus.test.junit.classloading.FacadeClassLoader;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.LauncherSessionListener;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;

public class CustomLauncherInterceptor
implements LauncherDiscoveryListener,
LauncherSessionListener,
TestExecutionListener {
    private static FacadeClassLoader facadeLoader = null;
    private static ClassLoader origCl = null;
    private static boolean discoveryStarted = false;

    private static boolean isProductionModeTests() {
        return System.getProperty("prod.mode.tests") != null;
    }

    public void launcherSessionOpened(LauncherSession session) {
        boolean shouldSetTCCL;
        boolean bl = shouldSetTCCL = !discoveryStarted;
        if (!CustomLauncherInterceptor.isProductionModeTests() && shouldSetTCCL) {
            this.actuallyIntercept();
        }
    }

    private void actuallyIntercept() {
        if (origCl == null) {
            origCl = Thread.currentThread().getContextClassLoader();
        }
        this.initializeFacadeClassLoader();
        this.adjustContextClassLoader();
    }

    private void initializeFacadeClassLoader() {
        ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
        if ((currentCl == null || currentCl != facadeLoader && !currentCl.getClass().getName().equals(FacadeClassLoader.class.getName())) && facadeLoader == null) {
            facadeLoader = new FacadeClassLoader(currentCl);
        }
    }

    public void launcherDiscoveryStarted(LauncherDiscoveryRequest request) {
        discoveryStarted = true;
        if (!CustomLauncherInterceptor.isProductionModeTests()) {
            this.initializeFacadeClassLoader();
            this.adjustContextClassLoader();
            System.setProperty("java.util.concurrent.ForkJoinPool.common.threadFactory", "io.quarkus.bootstrap.forkjoin.QuarkusForkJoinWorkerThreadFactory");
        }
    }

    private void adjustContextClassLoader() {
        ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
        if (currentCl == null || currentCl != facadeLoader && !currentCl.getClass().getName().equals(FacadeClassLoader.class.getName())) {
            Thread.currentThread().setContextClassLoader(facadeLoader);
        }
    }

    public void launcherDiscoveryFinished(LauncherDiscoveryRequest request) {
        if (!CustomLauncherInterceptor.isProductionModeTests() && !facadeLoader.isServiceLoaderMechanism()) {
            Thread.currentThread().setContextClassLoader(origCl);
        }
    }

    public void launcherSessionClosed(LauncherSession session) {
        CustomLauncherInterceptor.clearContextClassloader();
    }

    private static void clearContextClassloader() {
        try {
            if (facadeLoader != null) {
                if (Thread.currentThread().getContextClassLoader() == facadeLoader) {
                    Thread.currentThread().setContextClassLoader(origCl);
                }
                facadeLoader.close();
                facadeLoader = null;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to close custom classloader", e);
        }
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        CustomLauncherInterceptor.clearContextClassloader();
    }
}

