/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.client.maven;

import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.registry.config.RegistryConfig;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;

class RegistryCacheRefreshLogger
implements TransferListener {
    private final RegistryConfig config;
    private final MessageWriter log;
    private final TransferListener delegate;
    boolean loggedCatalogRefreshMsg;

    public RegistryCacheRefreshLogger(RegistryConfig config, MessageWriter log, TransferListener delegate) {
        this.config = config;
        this.log = log;
        this.delegate = delegate;
    }

    public void transferInitiated(TransferEvent event) throws TransferCancelledException {
        if (!this.loggedCatalogRefreshMsg && !event.getResource().getResourceName().contains(this.config.getDescriptor().getArtifact().getArtifactId())) {
            this.loggedCatalogRefreshMsg = true;
            this.log.info("Looking for the newly published extensions in " + this.config.getId());
        }
        if (this.delegate != null) {
            this.delegate.transferInitiated(event);
        }
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        if (this.delegate != null) {
            this.delegate.transferStarted(event);
        }
    }

    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
        if (this.delegate != null) {
            this.delegate.transferProgressed(event);
        }
    }

    public void transferCorrupted(TransferEvent event) throws TransferCancelledException {
        if (this.delegate != null) {
            this.delegate.transferCorrupted(event);
        }
    }

    public void transferSucceeded(TransferEvent event) {
        if (this.delegate != null) {
            this.delegate.transferSucceeded(event);
        }
    }

    public void transferFailed(TransferEvent event) {
        if (this.delegate != null) {
            this.delegate.transferFailed(event);
        }
    }
}

