/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project;

import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.buildfile.GroovyGradleBuildFile;
import io.quarkus.devtools.project.buildfile.KotlinGradleBuildFile;
import io.quarkus.devtools.project.buildfile.MavenBuildFile;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.nio.file.Path;
import java.util.Locale;

public enum BuildTool {
    MAVEN("\n# Maven\ntarget/\npom.xml.tag\npom.xml.releaseBackup\npom.xml.versionsBackup\nrelease.properties", "target", new String[]{"pom.xml"}),
    GRADLE("\n# Gradle\n.gradle/\nbuild/", "build", new String[]{"build.gradle", "settings.gradle", "gradle.properties"}),
    GRADLE_KOTLIN_DSL("\n# Gradle\n.gradle/\nbuild/", "build", new String[]{"build.gradle.kts", "settings.gradle.kts", "gradle.properties"}),
    JBANG("\n# JBang\n.target/\nbuild/", "build", new String[0]);

    private final String gitIgnoreEntries;
    private final String buildDirectory;
    private final String[] buildFiles;

    private BuildTool(String gitIgnoreEntries, String buildDirectory, String[] buildFiles) {
        this.gitIgnoreEntries = gitIgnoreEntries;
        this.buildDirectory = buildDirectory;
        this.buildFiles = buildFiles;
    }

    public String getGitIgnoreEntries() {
        return this.gitIgnoreEntries;
    }

    public String[] getBuildFiles() {
        return this.buildFiles;
    }

    public String getDependenciesFile() {
        return this.buildFiles[0];
    }

    public String getBuildDirectory() {
        return this.buildDirectory;
    }

    public ExtensionManager createExtensionManager(Path projectDirPath, ExtensionCatalog catalog) {
        switch (this) {
            case GRADLE: {
                return new GroovyGradleBuildFile();
            }
            case GRADLE_KOTLIN_DSL: {
                return new KotlinGradleBuildFile();
            }
        }
        return new MavenBuildFile(projectDirPath, catalog);
    }

    public String getKey() {
        return this.toString().toLowerCase(Locale.ROOT).replace('_', '-');
    }

    public static BuildTool resolveExistingProject(Path path) {
        return QuarkusProject.resolveExistingProjectBuildTool(path);
    }

    public static BuildTool findTool(String tool) {
        for (BuildTool value : BuildTool.values()) {
            if (!value.toString().equalsIgnoreCase(tool) && !value.getKey().equalsIgnoreCase(tool)) continue;
            return value;
        }
        return null;
    }
}

