/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.bootstrap.model.AppArtifactCoords;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandlers;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.buildfile.GradleBuildFilesCreator;
import io.quarkus.devtools.project.codegen.ProjectGeneratorRegistry;
import io.quarkus.devtools.project.codegen.SourceType;
import io.quarkus.devtools.project.extensions.ExtensionManager;
import io.quarkus.platform.descriptor.QuarkusPlatformDescriptor;
import io.quarkus.platform.tools.ConsoleMessageFormats;
import io.quarkus.platform.tools.ToolsUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;

public class CreateProjectCommandHandler
implements QuarkusCommandHandler {
    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        QuarkusPlatformDescriptor platformDescr = invocation.getPlatformDescriptor();
        invocation.setValue("bom_groupId", platformDescr.getBomGroupId());
        invocation.setValue("bom_artifactId", platformDescr.getBomArtifactId());
        invocation.setValue("quarkus_version", platformDescr.getQuarkusVersion());
        invocation.setValue("bom_version", platformDescr.getBomVersion());
        Set<String> extensionsQuery = invocation.getValue("extensions", Collections.emptySet());
        Properties quarkusProps = ToolsUtils.readQuarkusProperties(platformDescr);
        quarkusProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String name = k.toString().replace("-", "_");
            if (!invocation.hasValue(name)) {
                invocation.setValue(k.toString().replace("-", "_"), v.toString());
            }
        }));
        try {
            List<AppArtifactCoords> extensionsToAdd;
            String className = invocation.getStringValue("class_name");
            if (className != null) {
                className = invocation.getValue("source_type", SourceType.JAVA).stripExtensionFrom(className);
                int idx = className.lastIndexOf(46);
                if (idx >= 0) {
                    String pkgName = invocation.getStringValue("package_name");
                    if (pkgName == null) {
                        invocation.setValue("package_name", className.substring(0, idx));
                    }
                    className = className.substring(idx + 1);
                }
                invocation.setValue("class_name", className);
            }
            if ((extensionsToAdd = QuarkusCommandHandlers.computeCoordsFromQuery(invocation, extensionsQuery)) != null) {
                ProjectGeneratorRegistry.get("basic-rest").generate(invocation);
                if (invocation.getQuarkusProject().getBuildTool().equals((Object)BuildTool.GRADLE)) {
                    GradleBuildFilesCreator creator = new GradleBuildFilesCreator(invocation.getQuarkusProject());
                    creator.create(invocation.getStringValue("project_groupId"), invocation.getStringValue("project_artifactId"), invocation.getStringValue("project_version"), quarkusProps, extensionsToAdd);
                } else {
                    ExtensionManager.InstallResult result = invocation.getQuarkusProject().getExtensionManager().install(extensionsToAdd);
                    result.getInstalled().forEach(a -> invocation.log().info(ConsoleMessageFormats.ok((String)("Extension " + a.getGroupId() + ":" + a.getArtifactId())) + " has been installed"));
                }
            }
        }
        catch (IOException e) {
            throw new QuarkusCommandException("Failed to create project", e);
        }
        return QuarkusCommandOutcome.success();
    }
}

