/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.runner.DevModeMediator;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.changeagent.ClassChangeAgent;
import io.quarkus.deployment.dev.AlwaysFalsePredicate;
import io.quarkus.deployment.dev.ClassComparisonUtil;
import io.quarkus.deployment.dev.ClassScanResult;
import io.quarkus.deployment.dev.CodeGenLock;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.IsolatedRemoteDevModeMain;
import io.quarkus.deployment.dev.QuarkusCompiler;
import io.quarkus.deployment.dev.filesystem.watch.FileChangeCallback;
import io.quarkus.deployment.dev.filesystem.watch.FileChangeEvent;
import io.quarkus.deployment.dev.filesystem.watch.WatchServiceFileSystemWatcher;
import io.quarkus.deployment.dev.testing.TestListener;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.dev.console.StatusLine;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.dev.testing.TestScanningLock;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.instrument.ClassDefinition;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class RuntimeUpdatesProcessor
implements HotReplacementContext,
Closeable {
    public static final boolean IS_LINUX = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("linux");
    private static final Logger log = Logger.getLogger(RuntimeUpdatesProcessor.class);
    private static final String CLASS_EXTENSION = ".class";
    public static volatile RuntimeUpdatesProcessor INSTANCE;
    private final Path applicationRoot;
    private final DevModeContext context;
    private final QuarkusCompiler compiler;
    private final DevModeType devModeType;
    volatile Throwable compileProblem;
    volatile Throwable testCompileProblem;
    volatile Throwable hotReloadProblem;
    private final AtomicReference<Throwable> deploymentProblem;
    private volatile Predicate<ClassInfo> disableInstrumentationForClassPredicate = new AlwaysFalsePredicate<ClassInfo>();
    private volatile Predicate<Index> disableInstrumentationForIndexPredicate = new AlwaysFalsePredicate<Index>();
    private static volatile boolean instrumentationLogPrinted;
    private final TimestampSet main = new TimestampSet();
    private final TimestampSet test = new TimestampSet();
    final Map<Path, Long> sourceFileTimestamps = new ConcurrentHashMap<Path, Long>();
    private Map<DotName, Set<DotName>> classToRecompilationTargets = new HashMap<DotName, Set<DotName>>();
    private final List<Runnable> preScanSteps = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> preRestartSteps = new CopyOnWriteArrayList<Runnable>();
    private final List<Runnable> postRestartSteps = new CopyOnWriteArrayList<Runnable>();
    private final List<Consumer<Set<String>>> noRestartChangesConsumers = new CopyOnWriteArrayList<Consumer<Set<String>>>();
    private final List<HotReplacementSetup> hotReplacementSetup = new ArrayList<HotReplacementSetup>();
    private final List<Runnable> deploymentFailedStartHandlers = new ArrayList<Runnable>();
    private final BiConsumer<Set<String>, ClassScanResult> restartCallback;
    private final BiConsumer<DevModeContext.ModuleInfo, String> copyResourceNotification;
    private final BiFunction<String, byte[], byte[]> classTransformers;
    private final ReentrantLock scanLock = new ReentrantLock();
    private final Lock codeGenLock = CodeGenLock.lockForCompilation();
    private static volatile IndexView lastStartIndex;
    private final Map<DevModeContext.CompilationUnit, Set<Path>> correspondingResources = new ConcurrentHashMap<DevModeContext.CompilationUnit, Set<Path>>();
    private final TestSupport testSupport;
    private volatile boolean firstTestScanComplete;
    private volatile Boolean instrumentationEnabled;
    private volatile boolean configuredInstrumentationEnabled;
    private volatile boolean liveReloadEnabled = true;
    private WatchServiceFileSystemWatcher testClassChangeWatcher;
    private Timer testClassChangeTimer;
    volatile StatusLine compileOutput;

    public RuntimeUpdatesProcessor(Path applicationRoot, DevModeContext context, QuarkusCompiler compiler, DevModeType devModeType, BiConsumer<Set<String>, ClassScanResult> restartCallback, BiConsumer<DevModeContext.ModuleInfo, String> copyResourceNotification, BiFunction<String, byte[], byte[]> classTransformers, TestSupport testSupport, AtomicReference<Throwable> deploymentProblem) {
        this.applicationRoot = applicationRoot;
        this.context = context;
        this.compiler = compiler;
        this.devModeType = devModeType;
        this.restartCallback = restartCallback;
        this.copyResourceNotification = copyResourceNotification;
        this.classTransformers = classTransformers;
        this.testSupport = testSupport;
        if (testSupport != null) {
            testSupport.addListener(new TestListener(){

                @Override
                public void testsEnabled() {
                    if (!RuntimeUpdatesProcessor.this.firstTestScanComplete) {
                        RuntimeUpdatesProcessor.this.checkForChangedTestClasses(true);
                        RuntimeUpdatesProcessor.this.firstTestScanComplete = true;
                    }
                    RuntimeUpdatesProcessor.this.startTestScanningTimer();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void testsDisabled() {
                    RuntimeUpdatesProcessor runtimeUpdatesProcessor = RuntimeUpdatesProcessor.this;
                    synchronized (runtimeUpdatesProcessor) {
                        if (RuntimeUpdatesProcessor.this.testClassChangeWatcher != null) {
                            try {
                                RuntimeUpdatesProcessor.this.testClassChangeWatcher.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            RuntimeUpdatesProcessor.this.testClassChangeWatcher = null;
                        }
                        if (RuntimeUpdatesProcessor.this.testClassChangeTimer != null) {
                            RuntimeUpdatesProcessor.this.testClassChangeTimer.cancel();
                            RuntimeUpdatesProcessor.this.testClassChangeTimer = null;
                        }
                    }
                }
            });
        }
        this.deploymentProblem = deploymentProblem;
    }

    public TestSupport getTestSupport() {
        return this.testSupport;
    }

    public List<Path> getClassesDir() {
        List<DevModeContext.ModuleInfo> allModules = this.context.getAllModules();
        ArrayList<Path> paths = new ArrayList<Path>(allModules.size());
        for (DevModeContext.ModuleInfo i : allModules) {
            paths.add(Path.of(i.getMain().getClassesPath(), new String[0]));
        }
        return paths;
    }

    public List<Path> getSourcesDir() {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (DevModeContext.ModuleInfo m : this.context.getAllModules()) {
            for (Path p : m.getMain().getSourcePaths()) {
                paths.add(p);
            }
        }
        return paths;
    }

    public List<Path> getTestSourcesDir() {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (DevModeContext.ModuleInfo m : this.context.getAllModules()) {
            if (!m.getTest().isPresent()) continue;
            for (Path p : m.getTest().get().getSourcePaths()) {
                paths.add(p);
            }
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startTestScanningTimer() {
        RuntimeUpdatesProcessor runtimeUpdatesProcessor = this;
        synchronized (runtimeUpdatesProcessor) {
            if (this.testClassChangeWatcher == null && this.testClassChangeTimer == null) {
                if (IS_LINUX) {
                    this.testClassChangeWatcher = new WatchServiceFileSystemWatcher("Quarkus Test Watcher", true);
                    final FileChangeCallback callback = new FileChangeCallback(){

                        @Override
                        public void handleChanges(Collection<FileChangeEvent> changes) {
                            try {
                                if (RuntimeUpdatesProcessor.this.context.isTest()) {
                                    Thread.sleep(500L);
                                }
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                            RuntimeUpdatesProcessor.this.periodicTestCompile();
                        }
                    };
                    this.testClassChangeWatcher.watchFiles(Path.of(this.context.getApplicationRoot().getProjectDirectory(), new String[0]), List.of(Path.of(".env", new String[0])), callback);
                    final HashSet<Path> nonExistent = new HashSet<Path>();
                    for (DevModeContext.ModuleInfo module : this.context.getAllModules()) {
                        for (Path path : module.getMain().getSourcePaths()) {
                            this.testClassChangeWatcher.watchDirectoryRecursively(path, callback);
                        }
                        for (Path path : module.getMain().getResourcePaths()) {
                            this.testClassChangeWatcher.watchDirectoryRecursively(path, callback);
                        }
                    }
                    for (DevModeContext.ModuleInfo module : this.context.getAllModules()) {
                        if (!module.getTest().isPresent()) continue;
                        for (Path path : module.getTest().get().getSourcePaths()) {
                            if (!Files.isDirectory(path, new LinkOption[0])) {
                                nonExistent.add(path);
                                continue;
                            }
                            this.testClassChangeWatcher.watchDirectoryRecursively(path, callback);
                        }
                        for (Path path : module.getTest().get().getResourcePaths()) {
                            if (!Files.isDirectory(path, new LinkOption[0])) {
                                nonExistent.add(path);
                                continue;
                            }
                            this.testClassChangeWatcher.watchDirectoryRecursively(path, callback);
                        }
                    }
                    this.testClassChangeTimer = new Timer("Test Compile Timer", true);
                    if (!nonExistent.isEmpty()) {
                        this.testClassChangeTimer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                boolean added = false;
                                Iterator iterator = nonExistent.iterator();
                                while (iterator.hasNext()) {
                                    Path i = (Path)iterator.next();
                                    if (!Files.isDirectory(i, new LinkOption[0])) continue;
                                    iterator.remove();
                                    RuntimeUpdatesProcessor.this.testClassChangeWatcher.watchDirectoryRecursively(i, callback);
                                    added = true;
                                }
                                if (added) {
                                    RuntimeUpdatesProcessor.this.periodicTestCompile();
                                }
                            }
                        }, 1L, 1000L);
                    }
                    this.testClassChangeTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            RuntimeUpdatesProcessor.this.periodicTestCompile();
                        }
                    }, 0L);
                } else {
                    this.testClassChangeTimer = new Timer("Test Compile Timer", true);
                    this.testClassChangeTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            RuntimeUpdatesProcessor.this.periodicTestCompile();
                        }
                    }, 1L, 1000L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void periodicTestCompile() {
        this.scanLock.lock();
        TestScanningLock.lockForTests();
        try {
            ClassScanResult changedApp = this.checkForChangedClasses(this.compiler, DevModeContext.ModuleInfo::getMain, false, this.test, true);
            ClassScanResult changedTestClassResult = this.compileTestClasses();
            if (changedApp.compilationHappened) {
                if (this.testCompileProblem != null) {
                    this.testSupport.testCompileFailed(this.testCompileProblem);
                } else {
                    this.testSupport.testCompileSucceeded();
                }
            }
            HashSet<String> filesChanges = new HashSet<String>(this.checkForFileChange(s -> s.getTest().orElse(null), this.test));
            filesChanges.addAll(this.checkForFileChange(DevModeContext.ModuleInfo::getMain, this.test));
            boolean fileRestartNeeded = filesChanges.stream().anyMatch(this.test::isRestartNeeded);
            ClassScanResult merged = ClassScanResult.merge(changedTestClassResult, changedApp);
            if (fileRestartNeeded) {
                if (this.testCompileProblem == null) {
                    this.testSupport.runTests(null);
                }
            } else if (merged.isChanged() && this.testCompileProblem == null) {
                this.testSupport.runTests(merged);
            }
        }
        finally {
            TestScanningLock.unlockForTests();
            this.scanLock.unlock();
        }
    }

    private ClassScanResult compileTestClasses() {
        QuarkusCompiler testCompiler = this.testSupport.getCompiler();
        ClassScanResult changedTestClassResult = new ClassScanResult();
        try {
            changedTestClassResult = this.checkForChangedClasses(testCompiler, m -> m.getTest().orElse(DevModeContext.EMPTY_COMPILATION_UNIT), false, this.test, true);
            if (this.compileProblem != null) {
                this.testSupport.testCompileFailed(this.compileProblem);
            } else if (changedTestClassResult.isChanged()) {
                this.testSupport.testCompileSucceeded();
            }
        }
        catch (Throwable e) {
            this.testSupport.testCompileFailed(e);
        }
        return changedTestClassResult;
    }

    public List<Path> getResourcesDir() {
        ArrayList<Path> ret = new ArrayList<Path>();
        for (DevModeContext.ModuleInfo i : this.context.getAllModules()) {
            if (!i.getMain().getResourcePaths().isEmpty()) {
                for (Path path : i.getMain().getResourcePaths()) {
                    ret.add(path);
                }
                continue;
            }
            if (i.getMain().getResourcesOutputPath() == null) continue;
            ret.add(Paths.get(i.getMain().getResourcesOutputPath(), new String[0]));
        }
        Collections.reverse(ret);
        return ret;
    }

    public Throwable getDeploymentProblem() {
        return this.compileProblem != null ? this.compileProblem : (this.deploymentProblem.get() != null ? this.deploymentProblem.get() : this.hotReloadProblem);
    }

    public void setRemoteProblem(Throwable throwable) {
        this.compileProblem = throwable;
        if (throwable == null) {
            this.getCompileOutput().setMessage(null);
        } else {
            this.getCompileOutput().setMessage(throwable.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatusLine getCompileOutput() {
        if (this.compileOutput == null) {
            RuntimeUpdatesProcessor runtimeUpdatesProcessor = this;
            synchronized (runtimeUpdatesProcessor) {
                if (this.compileOutput == null) {
                    this.compileOutput = QuarkusConsole.INSTANCE.registerStatusLine(300);
                }
            }
        }
        return this.compileOutput;
    }

    public void updateFile(String file, byte[] data) {
        if (file.startsWith("/")) {
            file = file.substring(1);
        }
        try {
            Path resolve = this.applicationRoot.resolve(file);
            if (!Files.exists(resolve.getParent(), new LinkOption[0])) {
                Files.createDirectories(resolve.getParent(), new FileAttribute[0]);
            }
            Files.write(resolve, data, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isTest() {
        return this.context.isTest();
    }

    public DevModeType getDevModeType() {
        return this.devModeType;
    }

    public boolean doScan(boolean userInitiated) throws IOException {
        return this.doScan(userInitiated, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean doScan(boolean userInitiated, boolean forceRestart) {
        if (!this.liveReloadEnabled && !forceRestart) {
            return false;
        }
        this.scanLock.lock();
        this.codeGenLock.lock();
        try {
            startNanoseconds = System.nanoTime();
            for (Runnable step : this.preScanSteps) {
                try {
                    step.run();
                }
                catch (Throwable t) {
                    RuntimeUpdatesProcessor.log.error((Object)"Pre Scan step failed", t);
                }
            }
            changedClassResults = this.checkForChangedClasses(this.compiler, (Function<DevModeContext.ModuleInfo, DevModeContext.CompilationUnit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getMain(), (Lio/quarkus/deployment/dev/DevModeContext$ModuleInfo;)Lio/quarkus/deployment/dev/DevModeContext$CompilationUnit;)(), false, this.main, false);
            filesChanged = this.checkForFileChange((Function<DevModeContext.ModuleInfo, DevModeContext.CompilationUnit>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getMain(), (Lio/quarkus/deployment/dev/DevModeContext$ModuleInfo;)Lio/quarkus/deployment/dev/DevModeContext$CompilationUnit;)(), this.main);
            if (forceRestart) ** GOTO lbl-1000
            if (filesChanged.stream().anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isRestartNeeded(java.lang.String ), (Ljava/lang/String;)Z)((TimestampSet)this.main))) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            fileRestartNeeded = v0;
            instrumentationChange = false;
            changedFilesForRestart = new ArrayList<Path>();
            if (fileRestartNeeded) {
                filesChanged.stream().filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isRestartNeeded(java.lang.String ), (Ljava/lang/String;)Z)((TimestampSet)this.main)).map((Function<String, Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$doScan$2(java.lang.String ), (Ljava/lang/String;)Ljava/nio/file/Path;)()).forEach((Consumer<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, add(E ), (Ljava/nio/file/Path;)V)(changedFilesForRestart));
            }
            changedFilesForRestart.addAll(changedClassResults.getChangedClasses());
            changedFilesForRestart.addAll(changedClassResults.getAddedClasses());
            changedFilesForRestart.addAll(changedClassResults.getDeletedClasses());
            if (ClassChangeAgent.getInstrumentation() != null && RuntimeUpdatesProcessor.lastStartIndex != null && !fileRestartNeeded && this.devModeType != DevModeType.REMOTE_LOCAL_SIDE && this.instrumentationEnabled() && changedClassResults.deletedClasses.isEmpty() && changedClassResults.addedClasses.isEmpty() && !changedClassResults.changedClasses.isEmpty()) {
                try {
                    indexer = new Indexer();
                    defs = new ClassDefinition[changedClassResults.changedClasses.size()];
                    index = 0;
                    for (Path i : changedClassResults.changedClasses) {
                        bytes = Files.readAllBytes(i);
                        name = indexer.indexWithSummary((InputStream)new ByteArrayInputStream((byte[])bytes)).name().toString();
                        defs[index++] = new ClassDefinition(Thread.currentThread().getContextClassLoader().loadClass(name), this.classTransformers.apply(name, (byte[])bytes));
                    }
                    current = indexer.complete();
                    v1 = ok = this.disableInstrumentationForIndexPredicate.test(current) == false;
                    if (ok) {
                        bytes = current.getKnownClasses().iterator();
                        while (bytes.hasNext()) {
                            clazz = (ClassInfo)bytes.next();
                            if (ClassComparisonUtil.isSameStructure(clazz, old = RuntimeUpdatesProcessor.lastStartIndex.getClassByName(clazz.name())) && !this.disableInstrumentationForClassPredicate.test(clazz)) continue;
                            ok = false;
                            break;
                        }
                    }
                    if (ok) {
                        RuntimeUpdatesProcessor.log.info((Object)"Application restart not required, replacing classes via instrumentation");
                        ClassChangeAgent.getInstrumentation().redefineClasses(defs);
                        instrumentationChange = true;
                    }
                }
                catch (Exception e) {
                    RuntimeUpdatesProcessor.log.error((Object)"Failed to replace classes via instrumentation", (Throwable)e);
                    instrumentationChange = false;
                }
            }
            if (this.compileProblem != null) {
                e = false;
                return e;
            }
            v2 = restartNeeded = instrumentationChange == false && (changedClassResults.isChanged() != false || this.deploymentProblem.get() != null && userInitiated != false || fileRestartNeeded != false);
            if (restartNeeded) {
                changeString = changedFilesForRestart.stream().map((Function<Path, Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getFileName(), (Ljava/nio/file/Path;)Ljava/nio/file/Path;)()).map((Function<Path, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Ljava/nio/file/Path;)Ljava/lang/String;)()).collect(Collectors.joining(", "));
                if (!changeString.isEmpty()) {
                    RuntimeUpdatesProcessor.log.infof("Restarting quarkus due to changes in %s.", (Object)changeString);
                } else if (forceRestart && userInitiated) {
                    RuntimeUpdatesProcessor.log.info((Object)"Restarting as requested by the user.");
                }
                for (Runnable step : this.preRestartSteps) {
                    try {
                        step.run();
                    }
                    catch (Throwable t) {
                        RuntimeUpdatesProcessor.log.error((Object)"Pre Restart step failed", t);
                    }
                }
                this.restartCallback.accept(filesChanged, changedClassResults);
                timeNanoSeconds = System.nanoTime() - startNanoseconds;
                RuntimeUpdatesProcessor.log.infof("Live reload total time: %ss ", (Object)Timing.convertToSecondsString((long)timeNanoSeconds));
                for (Runnable step : this.postRestartSteps) {
                    try {
                        step.run();
                    }
                    catch (Throwable t) {
                        RuntimeUpdatesProcessor.log.error((Object)"Post Restart step failed", t);
                    }
                }
                if (TimeUnit.SECONDS.convert(timeNanoSeconds, TimeUnit.NANOSECONDS) >= 4L && !this.instrumentationEnabled() && !RuntimeUpdatesProcessor.instrumentationLogPrinted) {
                    RuntimeUpdatesProcessor.instrumentationLogPrinted = true;
                    RuntimeUpdatesProcessor.log.info((Object)"Live reload took more than 4 seconds, you may want to enable instrumentation based reload (quarkus.live-reload.instrumentation=true). This allows small changes to take effect without restarting Quarkus.");
                }
                var14_25 = true;
                return var14_25;
            }
            if (!filesChanged.isEmpty()) {
                try {
                    this.notifyExtensions(filesChanged);
                    this.hotReloadProblem = null;
                    this.getCompileOutput().setMessage(null);
                }
                catch (Throwable t) {
                    this.hotReloadProblem = t;
                    this.getCompileOutput().setMessage(t.getMessage());
                }
                RuntimeUpdatesProcessor.log.infof("Files changed but restart not needed - notified extensions in: %ss ", (Object)Timing.convertToSecondsString((long)(System.nanoTime() - startNanoseconds)));
            } else if (instrumentationChange) {
                RuntimeUpdatesProcessor.log.infof("Live reload performed via instrumentation, no restart needed, total time: %ss ", (Object)Timing.convertToSecondsString((long)(System.nanoTime() - startNanoseconds)));
            }
            var11_16 = false;
            return var11_16;
        }
        finally {
            this.scanLock.unlock();
            this.codeGenLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyExtensions(Set<String> noRestartChangedFiles) {
        if (lastStartIndex == null) {
            return;
        }
        this.scanLock.lock();
        this.codeGenLock.lock();
        try {
            for (Consumer<Set<String>> consumer : this.noRestartChangesConsumers) {
                consumer.accept(noRestartChangedFiles);
            }
        }
        finally {
            this.scanLock.unlock();
            this.codeGenLock.unlock();
        }
    }

    public boolean instrumentationEnabled() {
        if (this.instrumentationEnabled != null) {
            return this.instrumentationEnabled;
        }
        return this.configuredInstrumentationEnabled;
    }

    public RuntimeUpdatesProcessor setLiveReloadEnabled(boolean liveReloadEnabled) {
        this.liveReloadEnabled = liveReloadEnabled;
        return this;
    }

    public RuntimeUpdatesProcessor setConfiguredInstrumentationEnabled(boolean configuredInstrumentationEnabled) {
        this.configuredInstrumentationEnabled = configuredInstrumentationEnabled;
        return this;
    }

    public void addPreScanStep(Runnable runnable) {
        this.preScanSteps.add(runnable);
    }

    public void addPreRestartStep(Runnable runnable) {
        this.preRestartSteps.add(runnable);
    }

    public void addPostRestartStep(Runnable runnable) {
        this.postRestartSteps.add(runnable);
    }

    public void consumeNoRestartChanges(Consumer<Set<String>> consumer) {
        this.noRestartChangesConsumers.add(consumer);
    }

    public Set<String> syncState(Map<String, String> fileHashes) {
        if (this.getDevModeType() != DevModeType.REMOTE_SERVER_SIDE) {
            throw new RuntimeException("Can only sync state on the server side of remote dev mode");
        }
        HashSet<String> ret = new HashSet<String>();
        try {
            HashMap<String, String> ourHashes = new HashMap<String, String>(IsolatedRemoteDevModeMain.createHashes(this.applicationRoot));
            for (Map.Entry<String, String> i : fileHashes.entrySet()) {
                String ours = (String)ourHashes.remove(i.getKey());
                if (Objects.equals(ours, i.getValue())) continue;
                ret.add(i.getKey());
            }
            List<Path> removedFiles = List.of();
            for (Map.Entry remaining : ourHashes.entrySet()) {
                String file = (String)remaining.getKey();
                if (file.endsWith("META-INF/MANIFEST.MF") || file.contains("META-INF/maven") || !file.contains("/")) continue;
                if (removedFiles.isEmpty()) {
                    removedFiles = new ArrayList();
                }
                removedFiles.add(this.applicationRoot.resolve(file));
            }
            if (!removedFiles.isEmpty()) {
                DevModeMediator.scheduleDelete(removedFiles);
            }
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    ClassScanResult checkForChangedClasses(boolean firstScan) {
        ClassScanResult classScanResult = this.checkForChangedClasses(this.compiler, DevModeContext.ModuleInfo::getMain, firstScan, this.main, false);
        if (firstScan) {
            this.test.merge(this.main);
        }
        return classScanResult;
    }

    ClassScanResult checkForChangedTestClasses(boolean firstScan) {
        if (!this.testSupport.isStarted()) {
            return new ClassScanResult();
        }
        ClassScanResult ret = this.checkForChangedClasses(this.testSupport.getCompiler(), s -> s.getTest().orElse(DevModeContext.EMPTY_COMPILATION_UNIT), firstScan, this.test, true);
        if (firstScan) {
            this.startTestScanningTimer();
        }
        return ret;
    }

    private void collectRecompilationTargets(DotName changedDependency, Set<DotName> knownRecompilationTargets) {
        ArrayDeque<DotName> toResolve = new ArrayDeque<DotName>();
        toResolve.add(changedDependency);
        while (!toResolve.isEmpty()) {
            DotName currentDependency = (DotName)toResolve.poll();
            Set<DotName> recompilationTargets = this.classToRecompilationTargets.get(currentDependency);
            if (recompilationTargets == null) continue;
            for (DotName className : recompilationTargets) {
                if (!knownRecompilationTargets.add(className)) continue;
                toResolve.add(className);
            }
        }
    }

    ClassScanResult checkForChangedClasses(QuarkusCompiler compiler, Function<DevModeContext.ModuleInfo, DevModeContext.CompilationUnit> cuf, boolean firstScan, TimestampSet timestampSet, boolean compilingTests) {
        record RecompilableLocationsBySourcePath(Path sourcePath, Set<File> changedFiles, Set<File> changedDependencies) {
        }
        ClassScanResult classScanResult = new ClassScanResult();
        record ChangeDetectionResult(DevModeContext.ModuleInfo moduleInfo, List<RecompilableLocationsBySourcePath> changedLocations) {
            private final List<RecompilableLocationsBySourcePath> changedLocations;

            ChangeDetectionResult(DevModeContext.ModuleInfo moduleInfo, List<RecompilableLocationsBySourcePath> changedLocations) {
                this.moduleInfo = moduleInfo;
                this.changedLocations = changedLocations;
            }

            public List<RecompilableLocationsBySourcePath> changedLocations() {
                return this.changedLocations;
            }
        }
        ArrayList<ChangeDetectionResult> changeDetectionResults = new ArrayList<ChangeDetectionResult>();
        HashSet<DotName> knownRecompilationTargets = new HashSet<DotName>();
        for (DevModeContext.ModuleInfo module : this.context.getAllModules()) {
            ChangeDetectionResult changeDetectionResult = new ChangeDetectionResult(module, new ArrayList<RecompilableLocationsBySourcePath>());
            for (Path sourcePath : cuf.apply(module).getSourcePaths()) {
                Set changedSourceFiles;
                if (!Files.exists(sourcePath, new LinkOption[0])) continue;
                try (Stream<Path> sourcesStream = Files.walk(sourcePath, new FileVisitOption[0]);){
                    changedSourceFiles = ((Stream)sourcesStream.parallel()).filter(p -> this.matchingHandledExtension((Path)p).isPresent() && this.sourceFileWasRecentModified((Path)p, firstScan, firstScan)).map(Path::toFile).collect(Collectors.toCollection(ConcurrentSkipListSet::new));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (changedSourceFiles.isEmpty()) continue;
                RecompilableLocationsBySourcePath recompilableLocationsBySourcePath = new RecompilableLocationsBySourcePath(sourcePath, changedSourceFiles, new HashSet<File>());
                changeDetectionResult.changedLocations().add(recompilableLocationsBySourcePath);
                Iterator<Object> iterator = changedSourceFiles.iterator();
                while (iterator.hasNext()) {
                    File file2 = (File)iterator.next();
                    String changedDependency = this.convertFileToClassname(sourcePath, file2);
                    this.collectRecompilationTargets(DotName.createSimple((String)changedDependency), knownRecompilationTargets);
                }
            }
            changeDetectionResults.add(changeDetectionResult);
        }
        block14: for (DotName recompilationTarget : knownRecompilationTargets) {
            String partialRelativePath = recompilationTarget.toString('/');
            for (ChangeDetectionResult changeDetectionResult : changeDetectionResults) {
                for (RecompilableLocationsBySourcePath recompilableLocationsBySourcePath : changeDetectionResult.changedLocations()) {
                    for (String string : compiler.allHandledExtensions()) {
                        Path resolved = recompilableLocationsBySourcePath.sourcePath().resolve(partialRelativePath + string);
                        if (!Files.exists(resolved, new LinkOption[0])) continue;
                        recompilableLocationsBySourcePath.changedDependencies().add(resolved.toFile());
                        continue block14;
                    }
                }
            }
        }
        for (ChangeDetectionResult changeDetectionResult : changeDetectionResults) {
            ArrayList<Path> moduleChangedSourceFilePaths = new ArrayList<Path>();
            for (RecompilableLocationsBySourcePath recompilableLocationsBySourcePath : changeDetectionResult.changedLocations()) {
                boolean bl;
                Path sourcePath = recompilableLocationsBySourcePath.sourcePath();
                Set<File> changedSourceFiles = recompilableLocationsBySourcePath.changedFiles();
                if (changedSourceFiles.isEmpty() && recompilableLocationsBySourcePath.changedDependencies().isEmpty()) continue;
                classScanResult.compilationHappened = true;
                for (File file3 : changedSourceFiles) {
                    if (file3.length() != 0L) continue;
                    try {
                        Thread.sleep(200L);
                        break;
                    }
                    catch (InterruptedException resolved) {
                    }
                }
                HashMap<File, Long> compileTimestamps = new HashMap<File, Long>();
                for (File i3 : changedSourceFiles) {
                    compileTimestamps.put(i3, i3.lastModified());
                }
                do {
                    try {
                        HashMap<String, Set<File>> hashMap = new HashMap<String, Set<File>>();
                        HashSet changedPaths = new HashSet();
                        Stream.concat(changedSourceFiles.stream(), recompilableLocationsBySourcePath.changedDependencies.stream()).forEach(file -> {
                            changedPaths.add(file.toPath());
                            Set files = changedFilesByExtension.computeIfAbsent(this.getFileExtension((File)file), k -> new HashSet());
                            files.add(file);
                        });
                        moduleChangedSourceFilePaths.addAll(changedPaths);
                        compiler.compile(sourcePath.toString(), hashMap);
                        this.compileProblem = null;
                        if (compilingTests) {
                            this.testCompileProblem = null;
                        }
                        this.getCompileOutput().setMessage(null);
                    }
                    catch (Exception exception) {
                        if (compilingTests) {
                            this.testCompileProblem = exception;
                        } else {
                            this.compileProblem = exception;
                        }
                        this.getCompileOutput().setMessage(exception.getMessage());
                        return classScanResult;
                    }
                    boolean bl2 = false;
                    for (Map.Entry entry : compileTimestamps.entrySet()) {
                        if (((File)entry.getKey()).lastModified() == ((Long)entry.getValue()).longValue()) continue;
                        bl = true;
                        entry.setValue(((File)entry.getKey()).lastModified());
                    }
                } while (bl);
                for (Map.Entry entry : compileTimestamps.entrySet()) {
                    this.sourceFileTimestamps.put(((File)entry.getKey()).toPath(), (Long)entry.getValue());
                }
            }
            this.checkForClassFilesChangesInModule(changeDetectionResult.moduleInfo(), moduleChangedSourceFilePaths, firstScan, classScanResult, cuf, timestampSet);
        }
        for (Path changedClass : classScanResult.changedClasses) {
            Path classSourcePath = timestampSet.classFilePathToSourceFilePath.get(changedClass);
            if (classSourcePath == null) continue;
            for (DevModeContext.ModuleInfo module : this.context.getAllModules()) {
                String generatedSourcesPath = cuf.apply(module).getGeneratedSourcesPath();
                if (generatedSourcesPath == null || !classSourcePath.startsWith(generatedSourcesPath)) continue;
                this.sourceFileTimestamps.put(classSourcePath, classSourcePath.toFile().lastModified());
            }
        }
        return classScanResult;
    }

    public Throwable getCompileProblem() {
        return this.compileProblem;
    }

    private void checkForClassFilesChangesInModule(DevModeContext.ModuleInfo module, List<Path> moduleChangedSourceFiles, boolean isInitialRun, ClassScanResult classScanResult, Function<DevModeContext.ModuleInfo, DevModeContext.CompilationUnit> cuf, TimestampSet timestampSet) {
        if (cuf.apply(module).getClassesPath() == null) {
            return;
        }
        try {
            for (String folder : cuf.apply(module).getClassesPath().split(File.pathSeparator)) {
                Path moduleClassesPath = Paths.get(folder, new String[0]);
                if (!Files.exists(moduleClassesPath, new LinkOption[0])) continue;
                try (Stream<Path> classesStream = Files.walk(moduleClassesPath, new FileVisitOption[0]);){
                    Set classFilePaths = ((Stream)classesStream.parallel()).filter(path -> path.toString().endsWith(CLASS_EXTENSION)).collect(Collectors.toSet());
                    for (Path classFilePath : classFilePaths) {
                        Path sourceFilePath = this.retrieveSourceFilePathForClassFile(classFilePath, moduleChangedSourceFiles, module, cuf, timestampSet, false);
                        if (sourceFilePath != null) {
                            Path updated;
                            if (!sourceFilePath.toFile().exists() && (updated = this.retrieveSourceFilePathForClassFile(classFilePath, moduleChangedSourceFiles, module, cuf, timestampSet, true)) != null) {
                                sourceFilePath = updated;
                            }
                            if (!sourceFilePath.toFile().exists()) {
                                this.cleanUpClassFile(classFilePath, timestampSet);
                                this.sourceFileTimestamps.remove(sourceFilePath);
                                classScanResult.addDeletedClass(moduleClassesPath, classFilePath);
                                continue;
                            }
                            timestampSet.classFilePathToSourceFilePath.put(classFilePath, sourceFilePath);
                            if (this.classFileWasAdded(classFilePath, isInitialRun, timestampSet)) {
                                classScanResult.addAddedClass(moduleClassesPath, classFilePath);
                                continue;
                            }
                            if (this.classFileWasRecentModified(classFilePath, isInitialRun, timestampSet)) {
                                classScanResult.addChangedClass(moduleClassesPath, classFilePath);
                                continue;
                            }
                            if (!moduleChangedSourceFiles.contains(sourceFilePath)) continue;
                            this.cleanUpClassFile(classFilePath, timestampSet);
                            classScanResult.addDeletedClass(moduleClassesPath, classFilePath);
                            continue;
                        }
                        if (this.classFileWasAdded(classFilePath, isInitialRun, timestampSet)) {
                            classScanResult.addAddedClass(moduleClassesPath, classFilePath);
                            continue;
                        }
                        if (!this.classFileWasRecentModified(classFilePath, isInitialRun, timestampSet)) continue;
                        classScanResult.addChangedClass(moduleClassesPath, classFilePath);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Path retrieveSourceFilePathForClassFile(Path classFilePath, List<Path> moduleChangedSourceFiles, DevModeContext.ModuleInfo module, Function<DevModeContext.ModuleInfo, DevModeContext.CompilationUnit> cuf, TimestampSet timestampSet, boolean forceRefresh) {
        Path sourceFilePath = timestampSet.classFilePathToSourceFilePath.get(classFilePath);
        if (sourceFilePath == null || moduleChangedSourceFiles.contains(sourceFilePath) || forceRefresh) {
            sourceFilePath = this.compiler.findSourcePath(classFilePath, cuf.apply(module).getSourcePaths(), cuf.apply(module).getClassesPath());
        }
        return sourceFilePath;
    }

    private void cleanUpClassFile(Path classFilePath, TimestampSet timestampSet) throws IOException {
        Files.deleteIfExists(classFilePath);
        timestampSet.classFileChangeTimeStamps.remove(classFilePath);
        timestampSet.classFilePathToSourceFilePath.remove(classFilePath);
    }

    private Optional<String> matchingHandledExtension(Path p) {
        return this.compiler.allHandledExtensions().stream().filter(e -> p.toString().endsWith((String)e)).findFirst();
    }

    private String getFileExtension(File file) {
        String name = file.getName();
        int lastIndexOf = name.lastIndexOf(46);
        if (lastIndexOf == -1) {
            return "";
        }
        return name.substring(lastIndexOf);
    }

    private String convertFileToClassname(Path sourcePath, File file) {
        String className = sourcePath.relativize(file.toPath()).toString();
        int lastIndexOf = (className = className.replace(File.separatorChar, '.')).lastIndexOf(46);
        if (lastIndexOf > 0) {
            className = className.substring(0, lastIndexOf);
        }
        return className;
    }

    Set<String> checkForFileChange() {
        return this.checkForFileChange(DevModeContext.ModuleInfo::getMain, this.main);
    }

    /*
     * Unable to fully structure code
     */
    Set<String> checkForFileChange(Function<DevModeContext.ModuleInfo, DevModeContext.CompilationUnit> cuf, TimestampSet timestampSet) {
        ret = new HashSet<String>();
        for (DevModeContext.ModuleInfo module : this.context.getAllModules()) {
            compilationUnit = cuf.apply(module);
            if (compilationUnit == null) continue;
            moduleResources = this.correspondingResources.computeIfAbsent(compilationUnit, (Function<DevModeContext.CompilationUnit, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkForFileChange$9(io.quarkus.deployment.dev.DevModeContext$CompilationUnit ), (Lio/quarkus/deployment/dev/DevModeContext$CompilationUnit;)Ljava/util/Set;)());
            doCopy = true;
            rootPaths = compilationUnit.getResourcePaths();
            outputPath = compilationUnit.getResourcesOutputPath();
            if (rootPaths.isEmpty()) {
                rootPath = compilationUnit.getClassesPath();
                if (rootPath != null) {
                    rootPaths = PathList.of((Path[])new Path[]{Paths.get(rootPath, new String[0])});
                }
                outputPath = rootPath;
                doCopy = false;
            }
            if (rootPaths.isEmpty() || outputPath == null) continue;
            outputDir = Paths.get(outputPath, new String[0]);
            roots = rootPaths.stream().filter((Predicate<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$checkForFileChange$10(java.nio.file.Path ), (Ljava/nio/file/Path;)Z)()).filter((Predicate<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isReadable(java.nio.file.Path ), (Ljava/nio/file/Path;)Z)()).collect(Collectors.toList());
            if (doCopy) {
                seen = new HashSet<E>(moduleResources);
                try {
                    for (Path root : roots) {
                        walk = Files.walk(root, new FileVisitOption[0]);
                        try {
                            walk.forEach((Consumer<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$checkForFileChange$11(java.nio.file.Path java.nio.file.Path java.util.Set io.quarkus.deployment.dev.RuntimeUpdatesProcessor$TimestampSet java.util.Set java.util.Set io.quarkus.deployment.dev.DevModeContext$ModuleInfo java.nio.file.Path ), (Ljava/nio/file/Path;)V)((RuntimeUpdatesProcessor)this, (Path)root, (Path)outputDir, seen, (TimestampSet)timestampSet, (Set)moduleResources, ret, (DevModeContext.ModuleInfo)module));
                        }
                        finally {
                            if (walk == null) continue;
                            walk.close();
                        }
                    }
                    for (Path i : seen) {
                        moduleResources.remove(i);
                        if (Files.isDirectory(i, new LinkOption[0])) continue;
                        try {
                            Files.delete(i);
                        }
                        catch (IOException e) {
                            RuntimeUpdatesProcessor.log.error((Object)"Failed to delete resources", (Throwable)e);
                        }
                    }
                }
                catch (IOException e) {
                    RuntimeUpdatesProcessor.log.error((Object)"Unable to walk through the directory", (Throwable)e);
                }
            }
            for (WatchedPath watchedPath : timestampSet.watchedPaths.values()) {
                isAbsolute = watchedPath.isAbsolute();
                if (!isAbsolute) {
                    if (roots.stream().noneMatch((Predicate<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, startsWith(java.nio.file.Path ), (Ljava/nio/file/Path;)Z)((Path)watchedPath.filePath))) continue;
                }
                pathCurrentlyExisting = false;
                pathPreviouslyExisting = false;
                if (Files.exists(watchedPath.filePath, new LinkOption[0])) {
                    pathCurrentlyExisting = true;
                    try {
                        current = Files.getLastModifiedTime(watchedPath.filePath, new LinkOption[0]).toMillis();
                        last = watchedPath.lastModified;
                        if (current <= last) ** GOTO lbl86
                        ret.add(isAbsolute != false ? watchedPath.filePath.toString() : watchedPath.getOSAgnosticMatchPath());
                        if (Files.size(watchedPath.filePath) == 0L) {
                            try {
                                Thread.sleep(200L);
                            }
                            catch (InterruptedException var22_29) {
                                // empty catch block
                            }
                        }
                        current = Files.getLastModifiedTime(watchedPath.filePath, new LinkOption[0]).toMillis();
                        RuntimeUpdatesProcessor.log.infof("File change detected: %s", (Object)watchedPath.filePath);
                        if (!isAbsolute && doCopy && !Files.isDirectory(watchedPath.filePath, new LinkOption[0])) {
                            target = outputDir.resolve(watchedPath.matchPath);
                            data = Files.readAllBytes(watchedPath.filePath);
                            out = new FileOutputStream(target.toFile());
                            try {
                                out.write(data);
                            }
                            finally {
                                out.close();
                            }
                        }
                        watchedPath.lastModified = current;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                } else {
                    prevValue = watchedPath.lastModified;
                    watchedPath.lastModified = 0L;
                    v0 = pathPreviouslyExisting = prevValue > 0L;
                }
lbl86:
                // 3 sources

                if (pathCurrentlyExisting) continue;
                if (pathPreviouslyExisting) {
                    ret.add(isAbsolute != false ? watchedPath.filePath.toString() : watchedPath.getOSAgnosticMatchPath());
                }
                if (isAbsolute) continue;
                target = outputDir.resolve(watchedPath.matchPath);
                try {
                    FileUtil.deleteIfExists(target);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
        return ret;
    }

    private boolean sourceFileWasRecentModified(Path sourcePath, boolean ignoreFirstScanChanges, boolean firstScan) {
        return this.checkIfFileModified(sourcePath, this.sourceFileTimestamps, ignoreFirstScanChanges, firstScan);
    }

    private boolean classFileWasRecentModified(Path classFilePath, boolean ignoreFirstScanChanges, TimestampSet timestampSet) {
        return this.checkIfFileModified(classFilePath, timestampSet.classFileChangeTimeStamps, ignoreFirstScanChanges, true);
    }

    private boolean classFileWasAdded(Path classFilePath, boolean ignoreFirstScanChanges, TimestampSet timestampSet) {
        Long lastRecordedChange = timestampSet.classFileChangeTimeStamps.get(classFilePath);
        if (lastRecordedChange == null) {
            try {
                timestampSet.classFileChangeTimeStamps.put(classFilePath, Files.getLastModifiedTime(classFilePath, new LinkOption[0]).toMillis());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return lastRecordedChange == null && !ignoreFirstScanChanges;
    }

    private boolean checkIfFileModified(Path path, Map<Path, Long> pathModificationTimes, boolean ignoreFirstScanChanges, boolean updateTimestamp) {
        try {
            long lastModificationTime = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            Long lastRecordedChange = pathModificationTimes.get(path);
            if (lastRecordedChange == null) {
                if (updateTimestamp) {
                    pathModificationTimes.put(path, lastModificationTime);
                }
                return !ignoreFirstScanChanges;
            }
            if (lastRecordedChange != lastModificationTime) {
                if (updateTimestamp) {
                    pathModificationTimes.put(path, lastModificationTime);
                }
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public RuntimeUpdatesProcessor setDisableInstrumentationForClassPredicate(Predicate<ClassInfo> disableInstrumentationForClassPredicate) {
        this.disableInstrumentationForClassPredicate = disableInstrumentationForClassPredicate;
        return this;
    }

    public RuntimeUpdatesProcessor setDisableInstrumentationForIndexPredicate(Predicate<Index> disableInstrumentationForIndexPredicate) {
        this.disableInstrumentationForIndexPredicate = disableInstrumentationForIndexPredicate;
        return this;
    }

    public RuntimeUpdatesProcessor setClassToRecompilationTargets(Map<DotName, Set<DotName>> classToRecompilationTargets) {
        this.classToRecompilationTargets = classToRecompilationTargets;
        return this;
    }

    public RuntimeUpdatesProcessor setWatchedFilePaths(Map<String, Boolean> watchedFilePaths, List<Map.Entry<Predicate<String>, Boolean>> watchedFilePredicates, boolean isTest) {
        if (isTest) {
            this.setWatchedFilePathsInternal(watchedFilePaths, this.test, s -> s.getTest().isPresent() ? Arrays.asList(s.getTest().get(), s.getMain()) : Collections.singletonList(s.getMain()), watchedFilePredicates);
        } else {
            this.setWatchedFilePathsInternal(watchedFilePaths, this.main, s -> Collections.singletonList(s.getMain()), watchedFilePredicates);
        }
        return this;
    }

    private RuntimeUpdatesProcessor setWatchedFilePathsInternal(Map<String, Boolean> watchedFilePaths, final TimestampSet timestamps, Function<DevModeContext.ModuleInfo, List<DevModeContext.CompilationUnit>> cuf, List<Map.Entry<Predicate<String>, Boolean>> watchedFilePredicates) {
        timestamps.watchedFilePaths = watchedFilePaths;
        timestamps.watchedFilePredicates = watchedFilePredicates;
        for (DevModeContext.ModuleInfo moduleInfo : this.context.getAllModules()) {
            List<DevModeContext.CompilationUnit> compilationUnits = cuf.apply(moduleInfo);
            for (DevModeContext.CompilationUnit unit : compilationUnits) {
                PathCollection rootPaths = unit.getResourcePaths();
                if (rootPaths.isEmpty()) {
                    String rootPath = unit.getClassesPath();
                    if (rootPath == null) continue;
                    rootPaths = PathList.of((Path[])new Path[]{Path.of(rootPath, new String[0])});
                }
                List roots = rootPaths.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(Files::isReadable).collect(Collectors.toList());
                for (final Path root : roots) {
                    HashSet watchedRootPaths = new HashSet();
                    try (Stream<Path> walk = Files.walk(root, new FileVisitOption[0]);){
                        walk.forEach(path -> {
                            if (path.equals(root) || Files.isDirectory(path, new LinkOption[0])) {
                                return;
                            }
                            Path relativePath = root.relativize((Path)path);
                            String relativePathStr = RuntimeUpdatesProcessor.toOSAgnosticPathStr(relativePath.toString());
                            Boolean restart = (Boolean)watchedFilePaths.get(relativePathStr);
                            if (restart == null) {
                                restart = watchedFilePredicates.stream().filter(p -> ((Predicate)p.getKey()).test(relativePathStr)).map(Map.Entry::getValue).findFirst().orElse(null);
                            }
                            if (restart != null) {
                                log.debugf("Watch %s from: %s", (Object)relativePath, (Object)root);
                                watchedRootPaths.add(relativePathStr);
                                this.putLastModifiedTime((Path)path, relativePath, restart, timestamps);
                            }
                        });
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    for (final Map.Entry<String, Boolean> e : watchedFilePaths.entrySet()) {
                        final String watchedFilePath = e.getKey();
                        Path path2 = Paths.get(this.sanitizedPattern(watchedFilePath), new String[0]);
                        if (path2.isAbsolute() || watchedRootPaths.contains(e.getKey()) || !this.maybeGlobPattern(watchedFilePath)) continue;
                        try {
                            final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + watchedFilePath);
                            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                @Override
                                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                                    Path relativePath = root.relativize(file);
                                    if (matcher.matches(relativePath)) {
                                        log.debugf("Glob pattern [%s] matched %s from %s", (Object)watchedFilePath, (Object)relativePath, (Object)root);
                                        WatchedPath extra = new WatchedPath(file, relativePath, (Boolean)e.getValue(), attrs.lastModifiedTime().toMillis());
                                        timestamps.watchedPaths.put(extra.filePath, extra);
                                    }
                                    return FileVisitResult.CONTINUE;
                                }

                                @Override
                                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                                    return FileVisitResult.CONTINUE;
                                }
                            });
                        }
                        catch (IOException ex) {
                            throw new UncheckedIOException(ex);
                        }
                    }
                }
            }
        }
        for (Map.Entry entry : watchedFilePaths.entrySet()) {
            String watchedFilePath = (String)entry.getKey();
            Path path3 = Paths.get(this.sanitizedPattern(watchedFilePath), new String[0]);
            if (!path3.isAbsolute()) continue;
            path3 = Paths.get(watchedFilePath, new String[0]);
            log.debugf("Watch %s", (Object)path3);
            if (Files.exists(path3, new LinkOption[0])) {
                this.putLastModifiedTime(path3, path3, (Boolean)entry.getValue(), timestamps);
                continue;
            }
            timestamps.watchedPaths.put(path3, new WatchedPath(path3, path3, (Boolean)entry.getValue(), -1L));
        }
        log.debugf("Watched paths: %s", timestamps.watchedPaths.values());
        return this;
    }

    private String sanitizedPattern(String pattern) {
        return pattern.replaceAll("[*?]", "");
    }

    private boolean maybeGlobPattern(String path) {
        return path.contains("*") || path.contains("?");
    }

    private void putLastModifiedTime(Path path, Path relativePath, boolean restart, TimestampSet timestamps) {
        try {
            FileTime lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0]);
            timestamps.watchedPaths.put(path, new WatchedPath(path, relativePath, restart, lastModifiedTime.toMillis()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void addHotReplacementSetup(HotReplacementSetup service) {
        this.hotReplacementSetup.add(service);
    }

    public void addDeploymentFailedStartHandler(Runnable service) {
        this.deploymentFailedStartHandlers.add(service);
    }

    public void startupFailed() {
        for (HotReplacementSetup hotReplacementSetup : this.hotReplacementSetup) {
            hotReplacementSetup.handleFailedInitialStart();
        }
        for (Runnable runnable : this.deploymentFailedStartHandlers) {
            runnable.run();
        }
        lastStartIndex = null;
    }

    public static void setLastStartIndex(IndexView lastStartIndex) {
        RuntimeUpdatesProcessor.lastStartIndex = lastStartIndex;
    }

    @Override
    public void close() throws IOException {
        this.compiler.close();
        if (this.testClassChangeWatcher != null) {
            this.testClassChangeWatcher.close();
        }
        if (this.testClassChangeTimer != null) {
            this.testClassChangeTimer.cancel();
        }
    }

    public boolean toggleInstrumentation() {
        this.instrumentationEnabled = !this.instrumentationEnabled();
        if (this.instrumentationEnabled.booleanValue()) {
            log.info((Object)"Instrumentation based restart enabled");
        } else {
            log.info((Object)"Instrumentation based restart disabled");
        }
        return this.instrumentationEnabled;
    }

    public boolean toggleLiveReloadEnabled() {
        boolean bl = this.liveReloadEnabled = !this.liveReloadEnabled;
        if (this.liveReloadEnabled) {
            log.info((Object)"Live reload enabled");
        } else {
            log.info((Object)"Live reload disabled");
        }
        return this.liveReloadEnabled;
    }

    public boolean isLiveReloadEnabled() {
        return this.liveReloadEnabled;
    }

    private static String toOSAgnosticPathStr(String path) {
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        return path;
    }

    public String[] getCommandLineArgs() {
        String[] contextArgs = this.context.getArgs();
        if (contextArgs == null) {
            return new String[0];
        }
        return contextArgs;
    }

    public RuntimeUpdatesProcessor setCommandLineArgs(String[] commandLineArgs) {
        this.context.setArgs(commandLineArgs);
        return this;
    }

    private /* synthetic */ void lambda$checkForFileChange$11(Path root, Path outputDir, Set seen, TimestampSet timestampSet, Set moduleResources, Set ret, DevModeContext.ModuleInfo module, Path path) {
        try {
            Path relative = root.relativize(path);
            Path target = outputDir.resolve(relative);
            seen.remove(target);
            if (!timestampSet.watchedPaths.containsKey(path)) {
                moduleResources.add(target);
                long current = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
                if (!Files.exists(target, new LinkOption[0]) || Files.getLastModifiedTime(target, new LinkOption[0]).toMillis() < current) {
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        Files.createDirectories(target, new FileAttribute[0]);
                    } else {
                        Files.createDirectories(target.getParent(), new FileAttribute[0]);
                        ret.add(RuntimeUpdatesProcessor.toOSAgnosticPathStr(relative.toString()));
                        Files.copy(path, target, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                        if (this.copyResourceNotification != null) {
                            this.copyResourceNotification.accept(module, relative.toString());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Failed to copy resources", (Throwable)e);
        }
    }

    private static /* synthetic */ boolean lambda$checkForFileChange$10(Path x$0) {
        return Files.exists(x$0, new LinkOption[0]);
    }

    private static /* synthetic */ Set lambda$checkForFileChange$9(DevModeContext.CompilationUnit m) {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    private static /* synthetic */ Path lambda$doScan$2(String x$0) {
        return Paths.get(x$0, new String[0]);
    }

    static {
        instrumentationLogPrinted = false;
    }

    static class TimestampSet {
        final Map<Path, Long> classFileChangeTimeStamps = new ConcurrentHashMap<Path, Long>();
        final Map<Path, Path> classFilePathToSourceFilePath = new ConcurrentHashMap<Path, Path>();
        volatile Map<Path, WatchedPath> watchedPaths = new ConcurrentHashMap<Path, WatchedPath>();
        volatile Map<String, Boolean> watchedFilePaths;
        volatile List<Map.Entry<Predicate<String>, Boolean>> watchedFilePredicates;

        TimestampSet() {
        }

        public void merge(TimestampSet other) {
            this.classFileChangeTimeStamps.putAll(other.classFileChangeTimeStamps);
            this.classFilePathToSourceFilePath.putAll(other.classFilePathToSourceFilePath);
            HashMap<Path, WatchedPath> newVal = new HashMap<Path, WatchedPath>(this.watchedPaths);
            newVal.putAll(other.watchedPaths);
            this.watchedPaths = newVal;
        }

        boolean isRestartNeeded(String changedFile) {
            Boolean ret;
            for (WatchedPath path : this.watchedPaths.values()) {
                if (!path.matches(changedFile)) continue;
                return path.restartNeeded;
            }
            Boolean bl = ret = this.watchedFilePaths != null ? this.watchedFilePaths.get(changedFile) : null;
            if (ret == null) {
                ret = Boolean.FALSE;
                if (this.watchedFilePredicates != null) {
                    for (Map.Entry<Predicate<String>, Boolean> e : this.watchedFilePredicates) {
                        if (!e.getKey().test(changedFile)) continue;
                        ret = ret != false || e.getValue() != false;
                    }
                }
            }
            return ret;
        }
    }

    private static class WatchedPath {
        final Path filePath;
        final Path matchPath;
        volatile long lastModified;
        final boolean restartNeeded;

        private WatchedPath(Path path, Path relativePath, boolean restartNeeded, long lastModified) {
            this.filePath = path;
            this.matchPath = relativePath;
            this.restartNeeded = restartNeeded;
            this.lastModified = lastModified;
        }

        private boolean matches(String changedFile) {
            return this.isAbsolute() ? this.filePath.toString().equals(changedFile) : this.getOSAgnosticMatchPath().equals(changedFile);
        }

        private String getOSAgnosticMatchPath() {
            return RuntimeUpdatesProcessor.toOSAgnosticPathStr(this.matchPath.toString());
        }

        private boolean isAbsolute() {
            return this.matchPath.isAbsolute();
        }

        public String toString() {
            return "WatchedPath [matchPath=" + String.valueOf(this.matchPath) + ", filePath=" + String.valueOf(this.filePath) + ", restartNeeded=" + this.restartNeeded + ", lastModified=" + this.lastModified + "]";
        }
    }
}

