/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.dev.RecompilationDependenciesBuildItem;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;

public class RecompilationDependenciesProcessor {
    @BuildStep
    @Produce(value=ServiceStartBuildItem.class)
    public void consolidateRecompilationDependencies(CombinedIndexBuildItem combinedIndexBuildItem, List<RecompilationDependenciesBuildItem> recompilationDependenciesBuildItems) {
        HashMap<DotName, Set<DotName>> classToRecompilationTargets = new HashMap<DotName, Set<DotName>>();
        for (RecompilationDependenciesBuildItem buildItem : recompilationDependenciesBuildItems) {
            buildItem.getClassToRecompilationTargets().forEach((dependency, recompilationTargets) -> {
                if ((dependency = this.resolveOutermostClassName((DotName)dependency, combinedIndexBuildItem.getIndex())) == null) {
                    return;
                }
                for (DotName recompilationTarget : recompilationTargets) {
                    if ((recompilationTarget = this.resolveOutermostClassName(recompilationTarget, combinedIndexBuildItem.getIndex())) == null) continue;
                    classToRecompilationTargets.computeIfAbsent((DotName)dependency, k -> new HashSet()).add(recompilationTarget);
                }
            });
        }
        if (RuntimeUpdatesProcessor.INSTANCE != null) {
            RuntimeUpdatesProcessor.INSTANCE.setClassToRecompilationTargets(classToRecompilationTargets);
        }
    }

    private DotName resolveOutermostClassName(DotName name, IndexView index) {
        ClassInfo classInfo = index.getClassByName(name);
        if (classInfo == null) {
            return null;
        }
        if (classInfo.nestingType() != ClassInfo.NestingType.TOP_LEVEL) {
            return this.resolveOutermostClassName(classInfo.enclosingClassAlways(), index);
        }
        return name;
    }
}

