/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ClientProxy;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.ObserverRegistrationPhaseBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.processor.AnnotationStore;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.ObserverConfigurator;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.Startup;
import io.quarkus.runtime.StartupEvent;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.OptionalInt;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class StartupBuildSteps {
    static final DotName STARTUP_NAME = DotName.createSimple((String)Startup.class.getName());
    static final MethodDescriptor ARC_CONTAINER = MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]);
    static final MethodDescriptor ARC_CONTAINER_BEAN = MethodDescriptor.ofMethod(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class});
    static final MethodDescriptor ARC_CONTAINER_INSTANCE = MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{InjectableBean.class});
    static final MethodDescriptor INSTANCE_HANDLE_GET = MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]);
    static final MethodDescriptor CLIENT_PROXY_CONTEXTUAL_INSTANCE = MethodDescriptor.ofMethod(ClientProxy.class, (String)"arc_contextualInstance", Object.class, (Class[])new Class[0]);
    static final MethodDescriptor CONTEXTUAL_CREATE = MethodDescriptor.ofMethod(Contextual.class, (String)"create", Object.class, (Class[])new Class[]{CreationalContext.class});
    static final MethodDescriptor CONTEXTUAL_DESTROY = MethodDescriptor.ofMethod(Contextual.class, (String)"destroy", Void.TYPE, (Class[])new Class[]{Object.class, CreationalContext.class});
    private static final Logger LOG = Logger.getLogger(StartupBuildSteps.class);

    @BuildStep
    AutoAddScopeBuildItem addScope(CustomScopeAnnotationsBuildItem customScopes) {
        return AutoAddScopeBuildItem.builder().defaultScope(BuiltinScope.APPLICATION).match(new AutoAddScopeBuildItem.MatchPredicate(){

            @Override
            public boolean test(ClassInfo clazz, Collection<AnnotationInstance> annotations, IndexView index) {
                if (Annotations.contains(annotations, (DotName)STARTUP_NAME)) {
                    return true;
                }
                for (MethodInfo method : clazz.methods()) {
                    if (!method.hasAnnotation(STARTUP_NAME) || method.hasAnnotation(DotNames.PRODUCES)) continue;
                    return true;
                }
                return false;
            }
        }).reason("Found classes containing @Startup annotation.").build();
    }

    @BuildStep
    UnremovableBeanBuildItem unremovableBeans() {
        return new UnremovableBeanBuildItem(new Predicate<BeanInfo>(){

            @Override
            public boolean test(BeanInfo bean) {
                if (bean.isClassBean()) {
                    return ((AnnotationTarget)bean.getTarget().get()).asClass().hasAnnotation(STARTUP_NAME);
                }
                if (bean.isProducerMethod()) {
                    return !Annotations.getAnnotations((AnnotationTarget.Kind)AnnotationTarget.Kind.METHOD, (DotName)STARTUP_NAME, (Collection)((AnnotationTarget)bean.getTarget().get()).asMethod().annotations()).isEmpty();
                }
                if (bean.isProducerField()) {
                    return ((AnnotationTarget)bean.getTarget().get()).asField().hasAnnotation(STARTUP_NAME);
                }
                return false;
            }
        });
    }

    @BuildStep
    void registerStartupObservers(ObserverRegistrationPhaseBuildItem observerRegistration, BuildProducer<ObserverRegistrationPhaseBuildItem.ObserverConfiguratorBuildItem> configurators) {
        AnnotationStore annotationStore = (AnnotationStore)observerRegistration.getContext().get(BuildExtension.Key.ANNOTATION_STORE);
        for (BeanInfo bean : observerRegistration.getContext().beans()) {
            if (bean.isSynthetic()) {
                OptionalInt startupPriority = bean.getStartupPriority();
                if (!startupPriority.isPresent()) continue;
                this.registerStartupObserver(observerRegistration, bean, bean.getIdentifier(), startupPriority.getAsInt(), null);
                continue;
            }
            AnnotationTarget target = (AnnotationTarget)bean.getTarget().get();
            AnnotationInstance startupAnnotation = annotationStore.getAnnotation(target, STARTUP_NAME);
            if (startupAnnotation != null) {
                AnnotationValue priority = startupAnnotation.value();
                this.registerStartupObserver(observerRegistration, bean, bean.getIdentifier(), priority != null ? priority.asInt() : 2500, null);
            }
            if (target.kind() != AnnotationTarget.Kind.CLASS) continue;
            ArrayList<MethodInfo> startupMethods = new ArrayList<MethodInfo>();
            for (MethodInfo method : target.asClass().methods()) {
                if (!annotationStore.hasAnnotation((AnnotationTarget)method, STARTUP_NAME)) continue;
                if (!(method.isSynthetic() || Modifier.isPrivate(method.flags()) || Modifier.isStatic(method.flags()) || method.parametersCount() != 0 || annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.PRODUCES))) {
                    startupMethods.add(method);
                    continue;
                }
                if (annotationStore.hasAnnotation((AnnotationTarget)method, DotNames.PRODUCES)) continue;
                LOG.warnf("Ignored an invalid @Startup method declared on %s: %s", (Object)method.declaringClass().name(), (Object)method);
            }
            if (startupMethods.isEmpty()) continue;
            for (MethodInfo method : startupMethods) {
                AnnotationValue priority = annotationStore.getAnnotation((AnnotationTarget)method, STARTUP_NAME).value();
                this.registerStartupObserver(observerRegistration, bean, bean.getIdentifier() + method.toString(), priority != null ? priority.asInt() : 2500, method);
            }
        }
    }

    private void registerStartupObserver(ObserverRegistrationPhaseBuildItem observerRegistration, BeanInfo bean, String id, int priority, MethodInfo startupMethod) {
        ObserverConfigurator configurator = observerRegistration.getContext().configure().beanClass(bean.getBeanClass()).observedType(StartupEvent.class);
        configurator.id(id);
        configurator.priority(priority);
        configurator.notify(mc -> {
            ResultHandle containerHandle = mc.invokeStaticMethod(ARC_CONTAINER, new ResultHandle[0]);
            ResultHandle beanHandle = mc.invokeInterfaceMethod(ARC_CONTAINER_BEAN, containerHandle, new ResultHandle[]{mc.load(bean.getIdentifier())});
            if (bean.canBeInactive()) {
                boolean isInjectedInAlwaysActiveBean = false;
                for (InjectionPointInfo ip : observerRegistration.getBeanProcessor().getBeanDeployment().getInjectionPoints()) {
                    if (!bean.equals((Object)ip.getResolvedBean()) || !ip.getTargetBean().isPresent() || ((BeanInfo)ip.getTargetBean().get()).canBeInactive()) continue;
                    isInjectedInAlwaysActiveBean = true;
                    break;
                }
                if (!isInjectedInAlwaysActiveBean) {
                    ResultHandle isActive = mc.invokeInterfaceMethod(MethodDescriptor.ofMethod(InjectableBean.class, (String)"isActive", Boolean.TYPE, (Class[])new Class[0]), beanHandle, new ResultHandle[0]);
                    mc.ifFalse(isActive).trueBranch().returnVoid();
                }
            }
            if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
                ResultHandle creationalContext = mc.newInstance(MethodDescriptor.ofConstructor(CreationalContextImpl.class, (Class[])new Class[]{Contextual.class}), new ResultHandle[]{beanHandle});
                instance = mc.invokeInterfaceMethod(CONTEXTUAL_CREATE, beanHandle, new ResultHandle[]{creationalContext});
                if (startupMethod != null) {
                    TryBlock tryBlock = mc.tryBlock();
                    tryBlock.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)startupMethod), instance, new ResultHandle[0]);
                    CatchBlockCreator catchBlock = tryBlock.addCatch(Exception.class);
                    catchBlock.invokeInterfaceMethod(CONTEXTUAL_DESTROY, beanHandle, new ResultHandle[]{instance, creationalContext});
                    catchBlock.throwException(RuntimeException.class, "Error destroying bean with @Startup method", catchBlock.getCaughtException());
                }
                mc.invokeInterfaceMethod(CONTEXTUAL_DESTROY, beanHandle, new ResultHandle[]{instance, creationalContext});
            } else {
                ResultHandle instanceHandle = mc.invokeInterfaceMethod(ARC_CONTAINER_INSTANCE, containerHandle, new ResultHandle[]{beanHandle});
                instance = mc.invokeInterfaceMethod(INSTANCE_HANDLE_GET, instanceHandle, new ResultHandle[0]);
                if (startupMethod != null) {
                    mc.invokeVirtualMethod(MethodDescriptor.of((MethodInfo)startupMethod), instance, new ResultHandle[0]);
                } else if (bean.getScope().isNormal()) {
                    ResultHandle proxyHandle = mc.checkCast(instance, ClientProxy.class);
                    mc.invokeInterfaceMethod(CLIENT_PROXY_CONTEXTUAL_INSTANCE, proxyHandle, new ResultHandle[0]);
                }
            }
            mc.returnVoid();
        });
        configurator.done();
    }
}

