/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.builder.Json;
import io.quarkus.builder.JsonReader;
import io.quarkus.builder.JsonTransform;
import io.quarkus.builder.json.JsonMember;
import io.quarkus.builder.json.JsonMultiValue;
import io.quarkus.builder.json.JsonObject;
import io.quarkus.builder.json.JsonString;
import io.quarkus.builder.json.JsonValue;
import io.quarkus.maven.QuarkusBootstrapMojo;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="native-image-agent", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class NativeImageAgentMojo
extends QuarkusBootstrapMojo {
    private final Pattern resourceSkipPattern = NativeImageAgentMojo.discardPattern("application.properties", "jakarta", "jboss", "logging.properties", "microprofile", "quarkus", "slf4j", "smallrye", "vertx");

    @Override
    protected boolean beforeExecute() throws MojoExecutionException, MojoFailureException {
        return !QuarkusBootstrapMojo.isNativeProfileEnabled(this.mavenProject());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        String dirName = "native-image-agent-base-config";
        Path basePath = this.buildDir().toPath().resolve(Path.of("native-image-agent-base-config", new String[0]));
        this.getLog().debug((CharSequence)("Checking if native image agent config folder exits at " + basePath));
        if (basePath.toFile().exists()) {
            try {
                Path targetPath = this.buildDir().toPath().resolve(Path.of("native-image-agent-final-config", new String[0]));
                if (!targetPath.toFile().exists()) {
                    targetPath.toFile().mkdirs();
                }
                this.getLog().debug((CharSequence)("Native image agent config folder exits, copy and transform to " + targetPath));
                Path reflectConfigJsonPath = basePath.resolve("reflect-config.json");
                if (reflectConfigJsonPath.toFile().exists()) {
                    Files.copy(reflectConfigJsonPath, targetPath.resolve("reflect-config.json"), StandardCopyOption.REPLACE_EXISTING);
                    Files.copy(basePath.resolve("serialization-config.json"), targetPath.resolve("serialization-config.json"), StandardCopyOption.REPLACE_EXISTING);
                    Files.copy(basePath.resolve("jni-config.json"), targetPath.resolve("jni-config.json"), StandardCopyOption.REPLACE_EXISTING);
                    Files.copy(basePath.resolve("proxy-config.json"), targetPath.resolve("proxy-config.json"), StandardCopyOption.REPLACE_EXISTING);
                    this.transformJsonObject(basePath, "resource-config.json", targetPath, JsonTransform.dropping(this::discardResource));
                    if (!this.getLog().isInfoEnabled()) return;
                    this.getLog().info((CharSequence)("Discovered native image agent generated files in " + targetPath));
                    return;
                }
                Path reflectOriginsTxtPath = basePath.resolve("reflect-origins.txt");
                if (!reflectOriginsTxtPath.toFile().exists()) return;
                this.getLog().info((CharSequence)("Native image agent configuration origin files exist, inspect them manually inside " + basePath));
                return;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to transform native image agent configuration", (Exception)e);
            }
        } else {
            this.getLog().info((CharSequence)"Missing native-image-agent-base-config directory with native image agent configuration to transform");
        }
    }

    private void transformJsonObject(Path base, String name, Path target, JsonTransform transform) throws IOException {
        this.getLog().debug((CharSequence)("Discarding resources from native image configuration that match the following regular expression: " + this.resourceSkipPattern));
        String original = Files.readString(base.resolve(name));
        JsonObject jsonRead = (JsonObject)JsonReader.of((String)original).read();
        Json.JsonObjectBuilder jsonBuilder = Json.object((boolean)false, (boolean)true);
        jsonBuilder.transform((JsonMultiValue)jsonRead, transform);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(target.resolve(name).toFile(), StandardCharsets.UTF_8));){
            jsonBuilder.appendTo((Appendable)writer);
        }
    }

    private boolean discardResource(JsonValue value) {
        JsonMember member;
        if (value instanceof JsonMember && "pattern".equals((member = (JsonMember)value).attribute().value())) {
            JsonString memberValue = (JsonString)member.value();
            boolean discarded = this.resourceSkipPattern.matcher(memberValue.value()).find();
            if (discarded) {
                this.getLog().debug((CharSequence)("Discarded included resource with pattern: " + memberValue.value()));
            }
            return discarded;
        }
        return false;
    }

    private static Pattern discardPattern(String ... ignoredElements) {
        String pattern = Arrays.stream(ignoredElements).collect(Collectors.joining("|", ".*(", ").*"));
        return Pattern.compile(pattern);
    }
}

