/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Label;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;

final class TryCatch
extends Item {
    private final BlockCreatorImpl body;
    private List<Catch> catches = List.of();

    TryCatch(BlockCreatorImpl body) {
        this.body = body;
    }

    @Override
    public boolean mayFallThrough() {
        return this.body.mayFallThrough() || this.catches.stream().map(Catch::body).anyMatch(BlockCreatorImpl::mayFallThrough);
    }

    BlockCreatorImpl addCatch(ClassDesc superType, Set<ClassDesc> types, String caughtName) {
        BlockCreatorImpl bci = new BlockCreatorImpl(this.body.parent(), superType);
        Catch catch_ = new Catch(types, caughtName, bci);
        List<Catch> list = this.catches;
        if (list instanceof ArrayList) {
            ArrayList al = (ArrayList)list;
            al.add(catch_);
        } else {
            this.catches = Util.listWith(this.catches, catch_);
        }
        return bci;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        Label after = cb.newLabel();
        this.body.writeCode(cb, block);
        if (this.body.mayFallThrough()) {
            cb.goto_(after);
        }
        for (Catch catch_ : this.catches) {
            BlockCreatorImpl catchBody = catch_.body();
            catchBody.writeCode(cb, block);
            if (catchBody.mayFallThrough()) {
                cb.goto_(after);
            }
            for (ClassDesc type : catch_.types()) {
                if (type.equals(ConstantDescs.CD_Throwable)) {
                    cb.exceptionCatchAll(this.body.startLabel(), this.body.endLabel(), catchBody.startLabel());
                    continue;
                }
                cb.exceptionCatch(this.body.startLabel(), this.body.endLabel(), catchBody.startLabel(), type);
            }
        }
        cb.labelBinding(after);
    }

    static final class Catch {
        private final Set<ClassDesc> types;
        private final String caughtName;
        private final BlockCreatorImpl body;

        Catch(Set<ClassDesc> types, String caughtName, BlockCreatorImpl body) {
            this.types = types;
            this.caughtName = caughtName;
            this.body = body;
        }

        Set<ClassDesc> types() {
            return this.types;
        }

        BlockCreatorImpl body() {
            return this.body;
        }

        void accept(BiConsumer<BlockCreator, ? super LocalVar> builder) {
            this.body().accept((? super BlockCreatorImpl b, Expr e) -> builder.accept((BlockCreator)b, b.localVar(this.caughtName, (Expr)e)));
        }
    }
}

