/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl.constant;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.StackMapBuilder;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicConstantDesc;
import java.util.Optional;

public final class BooleanConst
extends ConstImpl {
    private final boolean value;
    public static final BooleanConst FALSE = new BooleanConst(false);
    public static final BooleanConst TRUE = new BooleanConst(true);

    private BooleanConst(boolean value) {
        super(ConstantDescs.CD_boolean);
        this.value = value;
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block, StackMapBuilder smb) {
        if (this.value) {
            cb.iconst_1();
        } else {
            cb.iconst_0();
        }
        smb.push(this.type());
        smb.wroteCode();
    }

    @Override
    public DynamicConstantDesc<Boolean> desc() {
        return this.value ? ConstantDescs.TRUE : ConstantDescs.FALSE;
    }

    public Optional<DynamicConstantDesc<Boolean>> describeConstable() {
        return Optional.of(this.desc());
    }

    @Override
    public boolean isZero() {
        return !this.value;
    }

    @Override
    public boolean isNonZero() {
        return this.value;
    }

    @Override
    public boolean equals(ConstImpl other) {
        return this == other;
    }

    @Override
    public String toString() {
        return Boolean.toString(this.value);
    }

    @Override
    public StringBuilder toShortString(StringBuilder b) {
        return b.append(this.value);
    }

    @Override
    public int hashCode() {
        return Boolean.hashCode(this.value);
    }
}

