/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor;

import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.arc.InjectableInterceptor;
import io.quarkus.arc.InterceptorCreator;
import io.quarkus.arc.processor.AnnotationLiteralProcessor;
import io.quarkus.arc.processor.BeanGenerator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanProcessor;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.MethodDescs;
import io.quarkus.arc.processor.ReflectionRegistration;
import io.quarkus.arc.processor.ResourceClassOutput;
import io.quarkus.arc.processor.ResourceOutput;
import io.quarkus.arc.processor.SyntheticComponentsUtil;
import io.quarkus.gizmo2.Assignable;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.InstanceFieldVar;
import io.quarkus.gizmo2.LocalVar;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.StaticFieldVar;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.interceptor.InvocationContext;
import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;

public class InterceptorGenerator
extends BeanGenerator {
    protected static final String FIELD_NAME_BINDINGS = "bindings";

    public InterceptorGenerator(AnnotationLiteralProcessor annotationLiterals, Predicate<DotName> applicationClassPredicate, BeanProcessor.PrivateMembersCollector privateMembers, boolean generateSources, ReflectionRegistration reflectionRegistration, Set<String> existingClasses, Map<BeanInfo, String> beanToGeneratedName, Predicate<DotName> injectionPointAnnotationsPredicate) {
        super(annotationLiterals, applicationClassPredicate, privateMembers, generateSources, reflectionRegistration, existingClasses, beanToGeneratedName, injectionPointAnnotationsPredicate, Collections.emptyList());
    }

    void precomputeGeneratedName(InterceptorInfo interceptor) {
        String targetPackage;
        Object baseName;
        if (interceptor.isSynthetic()) {
            DotName creatorClassName = DotName.createSimple(interceptor.getCreatorClass());
            baseName = InterceptorCreator.InterceptFunction.class.getSimpleName() + "_" + interceptor.getIdentifier();
            targetPackage = DotNames.packagePrefix(creatorClassName);
        } else {
            ClassInfo interceptorClass = interceptor.getTarget().get().asClass();
            baseName = interceptorClass.name().withoutPackagePrefix();
            targetPackage = DotNames.packagePrefix(interceptor.getProviderType().name());
        }
        this.beanToGeneratedBaseName.put(interceptor, baseName);
        String generatedName = InterceptorGenerator.generatedNameFromTarget(targetPackage, (String)baseName, "_Bean");
        this.beanToGeneratedName.put(interceptor, generatedName);
    }

    Collection<ResourceOutput.Resource> generate(InterceptorInfo interceptor) {
        DotName targetPackageClassName = interceptor.isSynthetic() ? DotName.createSimple(interceptor.getCreatorClass()) : interceptor.getProviderType().name();
        DotName isApplicationClassName = interceptor.isSynthetic() ? targetPackageClassName : interceptor.getBeanClass();
        String baseName = (String)this.beanToGeneratedBaseName.get(interceptor);
        String targetPackage = DotNames.packagePrefix(targetPackageClassName);
        String generatedName = (String)this.beanToGeneratedName.get(interceptor);
        if (this.existingClasses.contains(generatedName)) {
            return Collections.emptyList();
        }
        boolean isApplicationClass = this.applicationClassPredicate.test(isApplicationClassName) || interceptor.isForceApplicationClass();
        ResourceClassOutput classOutput = new ResourceClassOutput(isApplicationClass, name -> name.equals(generatedName) ? ResourceOutput.Resource.SpecialType.INTERCEPTOR_BEAN : null, this.generateSources);
        Gizmo gizmo = InterceptorGenerator.gizmo(classOutput);
        this.generateInterceptor(gizmo, interceptor, generatedName, baseName, targetPackage, isApplicationClass);
        return classOutput.getResources();
    }

    private void generateInterceptor(Gizmo gizmo, InterceptorInfo interceptor, String generatedName, String baseName, String targetPackage, boolean isApplicationClass) {
        gizmo.class_(generatedName, cc -> {
            cc.implements_(InjectableInterceptor.class);
            cc.implements_(Supplier.class);
            FieldDesc beanTypesField = cc.field("types", fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Set.class);
            });
            FieldDesc bindingsField = cc.field(FIELD_NAME_BINDINGS, fc -> {
                fc.private_();
                fc.final_();
                fc.setType(Set.class);
            });
            HashMap<InjectionPointInfo, FieldDesc> injectionPointToProviderField = new HashMap<InjectionPointInfo, FieldDesc>();
            this.generateProviderFields(interceptor, (ClassCreator)cc, (Map<InjectionPointInfo, FieldDesc>)injectionPointToProviderField, Map.of(), Map.of());
            this.generateConstructor((ClassCreator)cc, interceptor, beanTypesField, bindingsField, (Map<InjectionPointInfo, FieldDesc>)injectionPointToProviderField, isApplicationClass, interceptor.isSynthetic() ? bc -> SyntheticComponentsUtil.addParamsFieldAndInit(cc, bc, interceptor.getParams(), this.annotationLiterals, interceptor.getDeployment().getBeanArchiveIndex()) : ignored -> {});
            this.generateCreate((ClassCreator)cc, interceptor, new BeanGenerator.ProviderType(interceptor.getProviderType()), baseName, (Map<InjectionPointInfo, FieldDesc>)injectionPointToProviderField, Map.of(), Map.of(), targetPackage, isApplicationClass);
            this.generateSupplierGet((ClassCreator)cc);
            this.generateInjectableReferenceProviderGet(interceptor, (ClassCreator)cc, baseName);
            this.generateGetIdentifier((ClassCreator)cc, interceptor);
            this.generateGetTypes(beanTypesField, (ClassCreator)cc);
            this.generateGetPriority((ClassCreator)cc, interceptor);
            this.generateGetBeanClass((ClassCreator)cc, interceptor);
            this.generateGetInjectionPoints((ClassCreator)cc, interceptor);
            this.generateEquals((ClassCreator)cc, interceptor);
            this.generateHashCode((ClassCreator)cc, interceptor);
            this.generateToString((ClassCreator)cc);
            this.generateGetInterceptorBindings((ClassCreator)cc, bindingsField);
            this.generateIntercepts((ClassCreator)cc, interceptor);
            this.generateIntercept((ClassCreator)cc, interceptor, isApplicationClass);
        });
    }

    private void generateConstructor(ClassCreator cc, InterceptorInfo interceptor, FieldDesc beanTypesField, FieldDesc bindingsField, Map<InjectionPointInfo, FieldDesc> injectionPointToProviderField, boolean isApplicationClass, Consumer<BlockCreator> additionalCode) {
        super.generateConstructor(cc, interceptor, beanTypesField, null, null, null, injectionPointToProviderField, Map.of(), Map.of(), bc -> {
            LocalVar bindings = bc.localVar(FIELD_NAME_BINDINGS, bc.new_(HashSet.class));
            for (AnnotationInstance binding : interceptor.getBindings()) {
                ClassInfo bindingClass = interceptor.getDeployment().getInterceptorBinding(binding.name());
                bc.withSet((Expr)bindings).add(this.annotationLiterals.create((BlockCreator)bc, bindingClass, binding));
            }
            bc.set((Assignable)cc.this_().field(bindingsField), (Expr)bindings);
            ClassDesc interceptorClass = Jandex2Gizmo.classDescOf((Type)interceptor.getProviderType());
            this.generateInterceptorMethodsField(cc, (BlockCreator)bc, InterceptionType.AROUND_INVOKE, interceptor.getAroundInvokes(), interceptorClass, isApplicationClass);
            this.generateInterceptorMethodsField(cc, (BlockCreator)bc, InterceptionType.AROUND_CONSTRUCT, interceptor.getAroundConstructs(), interceptorClass, isApplicationClass);
            this.generateInterceptorMethodsField(cc, (BlockCreator)bc, InterceptionType.POST_CONSTRUCT, interceptor.getPostConstructs(), interceptorClass, isApplicationClass);
            this.generateInterceptorMethodsField(cc, (BlockCreator)bc, InterceptionType.PRE_DESTROY, interceptor.getPreDestroys(), interceptorClass, isApplicationClass);
            additionalCode.accept((BlockCreator)bc);
        });
    }

    private void generateInterceptorMethodsField(ClassCreator cc, BlockCreator bc, InterceptionType interceptionType, List<MethodInfo> methods, ClassDesc interceptorClass, boolean isApplicationClass) {
        if (methods.size() < 2) {
            return;
        }
        FieldDesc fieldDesc = cc.field(this.interceptorMethodsField(interceptionType), fc -> {
            fc.private_();
            fc.final_();
            fc.setType(List.class);
        });
        LocalVar list = bc.localVar(fieldDesc.name(), bc.new_(ArrayList.class));
        for (MethodInfo method : methods) {
            Expr bifunc = bc.lambda(BiFunction.class, lc -> {
                ParamVar interceptor = lc.parameter("interceptor", 0);
                ParamVar invocationContext = lc.parameter("invocationContext", 1);
                lc.body(lbc -> {
                    Expr result = this.invokeInterceptorMethod((BlockCreator)lbc, interceptorClass, method, interceptionType, isApplicationClass, invocationContext, interceptor);
                    lbc.return_((Expr)(interceptionType == InterceptionType.AROUND_INVOKE ? result : Const.ofNull(Object.class)));
                });
            });
            bc.withList((Expr)list).add(bifunc);
        }
        bc.set((Assignable)cc.this_().field(fieldDesc), (Expr)list);
    }

    protected void generateGetBeanClass(ClassCreator cc, InterceptorInfo interceptor) {
        cc.method("getBeanClass", mc -> {
            mc.returning(Class.class);
            mc.body(bc -> bc.return_((Expr)(interceptor.isSynthetic() ? Const.of(interceptor.getCreatorClass()) : Const.of((ClassDesc)Jandex2Gizmo.classDescOf((DotName)interceptor.getBeanClass())))));
        });
    }

    protected void generateGetInterceptorBindings(ClassCreator cc, FieldDesc bindingsField) {
        cc.method("getInterceptorBindings", mc -> {
            mc.returning(Set.class);
            mc.body(bc -> bc.return_((Expr)cc.this_().field(bindingsField)));
        });
    }

    protected void generateIntercepts(ClassCreator cc, InterceptorInfo interceptor) {
        cc.method("intercepts", mc -> {
            mc.returning(Boolean.TYPE);
            ParamVar interceptionType = mc.parameter("interceptionType", InterceptionType.class);
            mc.body(bc -> {
                if (interceptor.isSynthetic()) {
                    StaticFieldVar enumValue = Expr.staticField((FieldDesc)FieldDesc.of(InterceptionType.class, (String)interceptor.getInterceptionType().name()));
                    bc.return_(bc.eq((Expr)enumValue, (Expr)interceptionType));
                } else {
                    this.generateIntercepts(interceptor, InterceptionType.AROUND_INVOKE, (BlockCreator)bc, interceptionType);
                    this.generateIntercepts(interceptor, InterceptionType.POST_CONSTRUCT, (BlockCreator)bc, interceptionType);
                    this.generateIntercepts(interceptor, InterceptionType.PRE_DESTROY, (BlockCreator)bc, interceptionType);
                    this.generateIntercepts(interceptor, InterceptionType.AROUND_CONSTRUCT, (BlockCreator)bc, interceptionType);
                    bc.returnFalse();
                }
            });
        });
    }

    private void generateIntercepts(InterceptorInfo interceptor, InterceptionType interceptionType, BlockCreator bc, ParamVar interceptionTypeParam) {
        if (interceptor.intercepts(interceptionType)) {
            StaticFieldVar enumValue = Expr.staticField((FieldDesc)FieldDesc.of(InterceptionType.class, (String)interceptionType.name()));
            bc.if_(bc.eq((Expr)enumValue, (Expr)interceptionTypeParam), BlockCreator::returnTrue);
        }
    }

    protected void generateIntercept(ClassCreator cc, InterceptorInfo interceptor, boolean isApplicationClass) {
        cc.method("intercept", mc -> {
            mc.returning(Object.class);
            ParamVar interceptionType = mc.parameter("interceptionType", InterceptionType.class);
            ParamVar interceptorInstance = mc.parameter("interceptorInstance", Object.class);
            ParamVar invocationContext = mc.parameter("invocationContext", InvocationContext.class);
            mc.body(b0 -> {
                if (interceptor.isSynthetic()) {
                    b0.if_(b0.eq((Expr)Const.of((Constable)interceptor.getInterceptionType()), (Expr)interceptionType), b1 -> {
                        Expr interceptFunction = b1.cast((Expr)interceptorInstance, InterceptorCreator.InterceptFunction.class);
                        b1.return_(b1.invokeInterface(MethodDescs.INTERCEPT_FUNCTION_INTERCEPT, interceptFunction, (Expr)invocationContext));
                    });
                } else {
                    ClassDesc interceptorClass = Jandex2Gizmo.classDescOf((Type)interceptor.getProviderType());
                    this.generateIntercept(cc, (BlockCreator)b0, interceptor.getAroundInvokes(), InterceptionType.AROUND_INVOKE, interceptorClass, isApplicationClass, interceptionType, interceptorInstance, invocationContext);
                    this.generateIntercept(cc, (BlockCreator)b0, interceptor.getPostConstructs(), InterceptionType.POST_CONSTRUCT, interceptorClass, isApplicationClass, interceptionType, interceptorInstance, invocationContext);
                    this.generateIntercept(cc, (BlockCreator)b0, interceptor.getPreDestroys(), InterceptionType.PRE_DESTROY, interceptorClass, isApplicationClass, interceptionType, interceptorInstance, invocationContext);
                    this.generateIntercept(cc, (BlockCreator)b0, interceptor.getAroundConstructs(), InterceptionType.AROUND_CONSTRUCT, interceptorClass, isApplicationClass, interceptionType, interceptorInstance, invocationContext);
                }
                b0.return_((Expr)Const.ofNull(Object.class));
            });
        });
    }

    private void generateIntercept(ClassCreator cc, BlockCreator b0, List<MethodInfo> interceptorMethods, InterceptionType interceptionType, ClassDesc interceptorClass, boolean isApplicationClass, ParamVar interceptionTypeParam, ParamVar interceptorInstanceParam, ParamVar invocationContextParam) {
        if (interceptorMethods.isEmpty()) {
            return;
        }
        b0.if_(b0.eq((Expr)Const.of((Constable)interceptionType), (Expr)interceptionTypeParam), b1 -> {
            Expr result;
            if (interceptorMethods.size() == 1) {
                MethodInfo interceptorMethod = (MethodInfo)interceptorMethods.get(0);
                result = this.invokeInterceptorMethod((BlockCreator)b1, interceptorClass, interceptorMethod, interceptionType, isApplicationClass, invocationContextParam, interceptorInstanceParam);
            } else {
                InstanceFieldVar list = cc.this_().field(FieldDesc.of((ClassDesc)cc.type(), (String)this.interceptorMethodsField(interceptionType), List.class));
                Object params = interceptionType == InterceptionType.AROUND_INVOKE ? b1.invokeInterface(MethodDescs.INVOCATION_CONTEXT_GET_PARAMETERS, (Expr)invocationContextParam) : Const.ofNull(Object[].class);
                result = b1.invokeStatic(MethodDescs.INVOCATION_CONTEXTS_PERFORM_SUPERCLASS, new Expr[]{invocationContextParam, list, interceptorInstanceParam, params});
            }
            b1.return_((Expr)(InterceptionType.AROUND_INVOKE == interceptionType ? result : Const.ofNull(Object.class)));
        });
    }

    private String interceptorMethodsField(InterceptionType interceptionType) {
        return switch (interceptionType) {
            case InterceptionType.AROUND_INVOKE -> "aroundInvokes";
            case InterceptionType.AROUND_CONSTRUCT -> "aroundConstructs";
            case InterceptionType.POST_CONSTRUCT -> "postConstructs";
            case InterceptionType.PRE_DESTROY -> "preDestroys";
            default -> throw new IllegalArgumentException("Unsupported interception type: " + String.valueOf(interceptionType));
        };
    }

    private Expr invokeInterceptorMethod(BlockCreator bc, ClassDesc interceptorClass, MethodInfo interceptorMethod, InterceptionType interceptionType, boolean isApplicationClass, ParamVar invocationContext, ParamVar interceptorInstance) {
        Class<Object> resultType = InterceptionType.AROUND_INVOKE.equals((Object)interceptionType) ? Object.class : (interceptorMethod.returnType().kind().equals((Object)Type.Kind.VOID) ? Void.TYPE : Object.class);
        Class invocationContextClass = interceptorMethod.parameterType(0).name().equals((Object)DotNames.INVOCATION_CONTEXT) ? InvocationContext.class : ArcInvocationContext.class;
        if (Modifier.isPrivate(interceptorMethod.flags())) {
            this.privateMembers.add(isApplicationClass, String.format("Interceptor method %s#%s()", interceptorMethod.declaringClass().name(), interceptorMethod.name()));
            this.reflectionRegistration.registerMethod(interceptorMethod);
            Expr paramTypes = bc.newArray(Class.class, new Expr[]{Const.of(invocationContextClass)});
            Expr args = bc.newArray(Object.class, new Expr[]{invocationContext});
            return bc.invokeStatic(MethodDescs.REFLECTIONS_INVOKE_METHOD, new Expr[]{Const.of((ClassDesc)Jandex2Gizmo.classDescOf((ClassInfo)interceptorMethod.declaringClass())), Const.of((String)interceptorMethod.name()), paramTypes, interceptorInstance, args});
        }
        return bc.invokeVirtual((MethodDesc)ClassMethodDesc.of((ClassDesc)interceptorClass, (String)interceptorMethod.name(), resultType, (Class[])new Class[]{invocationContextClass}), (Expr)interceptorInstance, (Expr)invocationContext);
    }
}

