/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.spring.repository;

import jakarta.persistence.EntityManager;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Objects;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.springframework.transaction.support.TransactionSynchronizationManager;

class StatelessSessionUtil
implements Serializable {
    private final Connection connection;

    public StatelessSessionUtil(Connection connection) {
        this.connection = connection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatelessSessionUtil)) {
            return false;
        }
        StatelessSessionUtil that = (StatelessSessionUtil)o;
        return Objects.equals(this.connection, that.connection);
    }

    public int hashCode() {
        return Objects.hash(this.connection);
    }

    public static StatelessSession statelessSession(EntityManager entityManager) {
        Session session = (Session)entityManager.unwrap(Session.class);
        return (StatelessSession)session.doReturningWork(connection -> {
            StatelessSessionUtil statelessSessionKey = new StatelessSessionUtil(connection);
            StatelessSession statelessSession = (StatelessSession)TransactionSynchronizationManager.getResource((Object)statelessSessionKey);
            if (statelessSession != null) {
                return statelessSession;
            }
            statelessSession = session.getSessionFactory().openStatelessSession(connection);
            TransactionSynchronizationManager.bindResource((Object)statelessSessionKey, (Object)statelessSession);
            return statelessSession;
        });
    }
}

