/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.dockerui;

import io.hawt.dockerui.ProxyDetails;
import io.hawt.util.Strings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Formatter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.HeaderGroup;
import org.apache.http.util.EntityUtils;

public class ProxyServlet
extends HttpServlet {
    public static final String P_LOG = "log";
    public static final String P_FORWARDEDFOR = "forwardip";
    private static final String P_TARGET_URI = "targetUri";
    protected boolean doLog = false;
    protected boolean doForwardIP = true;
    protected boolean doSendUrlFragment = true;
    protected CloseableHttpClient proxyClient;
    private static final String STRING_HOST_HEADER_NAME = "Host";
    public static final String DEFAULT_HOST_AND_PORT = "http://localhost:4243";
    public static final String DEFAULT_SOCKET_PATH = "/var/run/docker.sock";
    private ServletContext servletContext;
    private String hostAndPort = "http://localhost:4243";
    protected static final HeaderGroup hopByHopHeaders;
    protected static final BitSet asciiQueryChars;

    public String getServletInfo() {
        return "A proxy servlet by David Smiley, dsmiley@mitre.org";
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        String doLogStr;
        super.init(servletConfig);
        String doForwardIPString = servletConfig.getInitParameter(P_FORWARDEDFOR);
        if (doForwardIPString != null) {
            this.doForwardIP = Boolean.parseBoolean(doForwardIPString);
        }
        if ((doLogStr = servletConfig.getInitParameter(P_LOG)) != null) {
            this.doLog = Boolean.parseBoolean(doLogStr);
        }
        this.proxyClient = HttpClients.createSystem();
        this.servletContext = servletConfig.getServletContext();
        boolean useSocket = false;
        String dockerHost = System.getenv("DOCKER_HOST");
        if (Strings.isBlank((String)dockerHost)) {
            dockerHost = DEFAULT_HOST_AND_PORT;
        }
        this.hostAndPort = dockerHost;
        if (this.hostAndPort.startsWith("tcp:")) {
            this.hostAndPort = "http:" + this.hostAndPort.substring(4);
        }
        String socketPath = DEFAULT_SOCKET_PATH;
        if (useSocket) {
            this.servletContext.log("Using docker socket : " + socketPath);
        } else {
            this.servletContext.log("Using docker URL: " + this.hostAndPort);
        }
    }

    public void destroy() {
        try {
            this.proxyClient.close();
        }
        catch (IOException e) {
            this.log("While destroying servlet, shutting down httpclient: " + e, (Throwable)e);
        }
        super.destroy();
    }

    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        BasicHttpRequest proxyRequest;
        String method = servletRequest.getMethod();
        String proxyRequestUri = this.rewriteUrlFromRequest(servletRequest);
        URI targetUriObj = null;
        try {
            targetUriObj = new URI(proxyRequestUri);
        }
        catch (URISyntaxException e) {
            throw new ServletException((Throwable)e);
        }
        if (servletRequest.getHeader("Content-Length") != null || servletRequest.getHeader("Transfer-Encoding") != null) {
            BasicHttpEntityEnclosingRequest eProxyRequest = new BasicHttpEntityEnclosingRequest(method, proxyRequestUri);
            eProxyRequest.setEntity((HttpEntity)new InputStreamEntity((InputStream)servletRequest.getInputStream(), (long)servletRequest.getContentLength()));
            proxyRequest = eProxyRequest;
        } else {
            proxyRequest = new BasicHttpRequest(method, proxyRequestUri);
        }
        this.copyRequestHeaders(servletRequest, (HttpRequest)proxyRequest, targetUriObj);
        this.setXForwardedForHeader(servletRequest, (HttpRequest)proxyRequest);
        CloseableHttpResponse proxyResponse = null;
        try {
            int statusCode;
            if (this.doLog) {
                this.log("proxy " + method + " uri: " + servletRequest.getRequestURI() + " -- " + proxyRequest.getRequestLine().getUri());
            }
            if (this.doResponseRedirectOrNotModifiedLogic(servletRequest, servletResponse, (HttpResponse)(proxyResponse = this.proxyClient.execute(URIUtils.extractHost((URI)targetUriObj), (HttpRequest)proxyRequest)), statusCode = proxyResponse.getStatusLine().getStatusCode(), targetUriObj)) {
                return;
            }
            servletResponse.setStatus(statusCode, proxyResponse.getStatusLine().getReasonPhrase());
            this.copyResponseHeaders((HttpResponse)proxyResponse, servletResponse);
            this.copyResponseEntity((HttpResponse)proxyResponse, servletResponse);
        }
        catch (Exception e) {
            if (proxyRequest instanceof AbortableHttpRequest) {
                AbortableHttpRequest abortableHttpRequest = (AbortableHttpRequest)proxyRequest;
                abortableHttpRequest.abort();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new RuntimeException(e);
        }
        finally {
            if (proxyResponse != null) {
                EntityUtils.consumeQuietly((HttpEntity)proxyResponse.getEntity());
            }
        }
    }

    protected boolean doResponseRedirectOrNotModifiedLogic(HttpServletRequest servletRequest, HttpServletResponse servletResponse, HttpResponse proxyResponse, int statusCode, URI targetUriObj) throws ServletException, IOException {
        if (statusCode >= 300 && statusCode < 304) {
            Header locationHeader = proxyResponse.getLastHeader("Location");
            if (locationHeader == null) {
                throw new ServletException("Received status code: " + statusCode + " but no " + "Location" + " header was found in the response");
            }
            String locStr = this.rewriteUrlFromResponse(servletRequest, locationHeader.getValue(), targetUriObj.toString());
            servletResponse.sendRedirect(locStr);
            return true;
        }
        if (statusCode == 304) {
            servletResponse.setIntHeader("Content-Length", 0);
            servletResponse.setStatus(304);
            return true;
        }
        return false;
    }

    protected void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            this.log(e.getMessage(), (Throwable)e);
        }
    }

    protected void copyRequestHeaders(HttpServletRequest servletRequest, HttpRequest proxyRequest, URI targetUriObj) {
        Enumeration enumerationOfHeaderNames = servletRequest.getHeaderNames();
        while (enumerationOfHeaderNames.hasMoreElements()) {
            String headerName = (String)enumerationOfHeaderNames.nextElement();
            if (headerName.equalsIgnoreCase("Content-Length") || hopByHopHeaders.containsHeader(headerName)) continue;
            Enumeration headers = servletRequest.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                String headerValue = (String)headers.nextElement();
                if (headerName.equalsIgnoreCase(STRING_HOST_HEADER_NAME)) {
                    HttpHost host = URIUtils.extractHost((URI)targetUriObj);
                    headerValue = host.getHostName();
                    if (host.getPort() != -1) {
                        headerValue = headerValue + ":" + host.getPort();
                    }
                }
                proxyRequest.addHeader(headerName, headerValue);
            }
        }
    }

    private void setXForwardedForHeader(HttpServletRequest servletRequest, HttpRequest proxyRequest) {
        String headerName = "X-Forwarded-For";
        if (this.doForwardIP) {
            String newHeader = servletRequest.getRemoteAddr();
            String existingHeader = servletRequest.getHeader(headerName);
            if (existingHeader != null) {
                newHeader = existingHeader + ", " + newHeader;
            }
            proxyRequest.setHeader(headerName, newHeader);
        }
    }

    protected void copyResponseHeaders(HttpResponse proxyResponse, HttpServletResponse servletResponse) {
        for (Header header : proxyResponse.getAllHeaders()) {
            if (hopByHopHeaders.containsHeader(header.getName())) continue;
            servletResponse.addHeader(header.getName(), header.getValue());
        }
    }

    protected void copyResponseEntity(HttpResponse proxyResponse, HttpServletResponse servletResponse) throws IOException {
        HttpEntity entity = proxyResponse.getEntity();
        if (entity != null) {
            ServletOutputStream servletOutputStream = servletResponse.getOutputStream();
            entity.writeTo((OutputStream)servletOutputStream);
        }
    }

    protected String rewriteUrlFromRequest(HttpServletRequest servletRequest) {
        ProxyDetails details = new ProxyDetails(this.hostAndPort, servletRequest, this.servletContext);
        return details.getStringProxyURL();
    }

    protected String rewriteUrlFromResponse(HttpServletRequest servletRequest, String theUrl, String targetUri) {
        if (theUrl.startsWith(targetUri)) {
            String curUrl = servletRequest.getRequestURL().toString();
            String pathInfo = servletRequest.getPathInfo();
            if (pathInfo != null) {
                assert (curUrl.endsWith(pathInfo));
                curUrl = curUrl.substring(0, curUrl.length() - pathInfo.length());
            }
            theUrl = curUrl + theUrl.substring(targetUri.length());
        }
        return theUrl;
    }

    protected static CharSequence encodeUriQuery(CharSequence in) {
        CharSequence outBuf = null;
        Formatter formatter = null;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            boolean escape = true;
            if (c < '\u0080') {
                if (asciiQueryChars.get(c)) {
                    escape = false;
                }
            } else if (!Character.isISOControl(c) && !Character.isSpaceChar(c)) {
                escape = false;
            }
            if (!escape) {
                if (outBuf == null) continue;
                ((StringBuilder)outBuf).append(c);
                continue;
            }
            if (outBuf == null) {
                outBuf = new StringBuilder(in.length() + 15);
                ((StringBuilder)outBuf).append(in, 0, i);
                formatter = new Formatter((Appendable)((Object)outBuf));
            }
            formatter.format("%%%02X", c);
        }
        return outBuf != null ? outBuf : in;
    }

    static {
        int c;
        String[] headers;
        hopByHopHeaders = new HeaderGroup();
        for (String header : headers = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade"}) {
            hopByHopHeaders.addHeader((Header)new BasicHeader(header, null));
        }
        char[] c_unreserved = "_-!.~'()*".toCharArray();
        char[] c_punct = ",;:$&+=".toCharArray();
        char[] c_reserved = "?/[]@".toCharArray();
        asciiQueryChars = new BitSet(128);
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (char c2 : c_unreserved) {
            asciiQueryChars.set(c2);
        }
        for (char c2 : c_punct) {
            asciiQueryChars.set(c2);
        }
        for (char c2 : c_reserved) {
            asciiQueryChars.set(c2);
        }
        asciiQueryChars.set(37);
    }
}

